/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewPropertyAnimator;
import eu.davidea.fastscroller.FastScroller;
import eu.davidea.flexibleadapter.FlexibleAdapter;

public class EmptyViewHelper
implements FlexibleAdapter.OnUpdateListener,
FlexibleAdapter.OnFilterListener {
    private FlexibleAdapter mAdapter;
    private OnEmptyViewListener mEmptyViewListener;
    private View mEmptyDataView;
    private View mEmptyFilterView;

    public static EmptyViewHelper create(FlexibleAdapter adapter, View emptyDataView) {
        return new EmptyViewHelper(adapter, emptyDataView);
    }

    public static EmptyViewHelper create(FlexibleAdapter adapter, View emptyDataView, View emptyFilterView) {
        return new EmptyViewHelper(adapter, emptyDataView, emptyFilterView);
    }

    public static EmptyViewHelper create(FlexibleAdapter adapter, View emptyDataView, View emptyFilterView, @Nullable OnEmptyViewListener emptyViewListener) {
        return new EmptyViewHelper(adapter, emptyDataView, emptyFilterView, emptyViewListener);
    }

    private EmptyViewHelper(FlexibleAdapter adapter, View emptyDataView) {
        this(adapter, emptyDataView, null);
    }

    private EmptyViewHelper(FlexibleAdapter adapter, View emptyDataView, View emptyFilterView) {
        this(adapter, emptyDataView, emptyFilterView, null);
    }

    private EmptyViewHelper(FlexibleAdapter adapter, View emptyDataView, View emptyFilterView, @Nullable OnEmptyViewListener emptyViewListener) {
        this.mEmptyDataView = emptyDataView;
        this.mEmptyFilterView = emptyFilterView;
        this.mEmptyViewListener = emptyViewListener;
        this.mAdapter = adapter;
        this.mAdapter.addListener((Object)this);
    }

    public View getEmptyDataView() {
        return this.mEmptyDataView;
    }

    public View getEmptyFilterView() {
        return this.mEmptyFilterView;
    }

    public final void showEmptyDataView() {
        EmptyViewHelper.showView(this.mEmptyDataView);
    }

    public final void hideEmptyDataView() {
        EmptyViewHelper.hideView(this.mEmptyDataView);
    }

    public final void showEmptyFilterView() {
        EmptyViewHelper.showView(this.mEmptyFilterView);
    }

    public final void hideEmptyFilterView() {
        EmptyViewHelper.hideView(this.mEmptyFilterView);
    }

    public final void onUpdateEmptyView(int size) {
        FastScroller fastScroller = this.mAdapter.getFastScroller();
        this.hideEmptyFilterView();
        if (size > 0) {
            this.hideEmptyDataView();
            if (fastScroller != null && fastScroller.isEnabled()) {
                fastScroller.showScrollbar();
            }
        } else if (this.mEmptyDataView != null && this.mEmptyDataView.getAlpha() == 0.0f) {
            this.showEmptyDataView();
            if (fastScroller != null && !fastScroller.isHidden()) {
                fastScroller.hideScrollbar();
            }
        }
        if (this.mEmptyViewListener != null) {
            this.mEmptyViewListener.onUpdateEmptyDataView(size);
        }
    }

    public final void onUpdateFilterView(int size) {
        FastScroller fastScroller = this.mAdapter.getFastScroller();
        this.hideEmptyDataView();
        if (size > 0) {
            this.hideEmptyFilterView();
            if (fastScroller != null && fastScroller.isEnabled()) {
                fastScroller.showScrollbar();
            }
        } else if (this.mEmptyFilterView != null && this.mEmptyFilterView.getAlpha() == 0.0f) {
            this.showEmptyFilterView();
            if (fastScroller != null && !fastScroller.isHidden()) {
                fastScroller.hideScrollbar();
            }
        }
        if (this.mEmptyViewListener != null) {
            this.mEmptyViewListener.onUpdateEmptyFilterView(size);
        }
    }

    private static void showView(View view) {
        if (view != null) {
            ViewPropertyAnimator animator = view.animate();
            animator.cancel();
            animator.alpha(1.0f);
        }
    }

    public static void hideView(View view) {
        if (view != null) {
            ViewPropertyAnimator animator = view.animate();
            animator.cancel();
            animator.alpha(0.0f);
        }
    }

    public static interface OnEmptyViewListener {
        public void onUpdateEmptyDataView(int var1);

        public void onUpdateEmptyFilterView(int var1);
    }
}

