/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.SparseArray;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.items.IFlexible;
import eu.davidea.flexibleadapter.utils.LayoutUtils;
import java.util.Arrays;
import java.util.List;

public class FlexibleItemDecoration
extends RecyclerView.ItemDecoration {
    private Context context;
    private SparseArray<ItemDecoration> mDecorations;
    private List<Integer> mViewTypes;
    private final ItemDecoration mDefaultDecoration = new ItemDecoration();
    private int mOffset;
    private int mSectionOffset;
    private int mDividerOnLastItem = 1;
    private int mSectionGapOnLastItem = 1;
    private boolean withLeftEdge;
    private boolean withTopEdge;
    private boolean withRightEdge;
    private boolean withBottomEdge;
    protected Drawable mDivider;
    protected final Rect mBounds = new Rect();
    protected boolean mDrawOver;
    protected static final int[] ATTRS = new int[]{16843284};

    public FlexibleItemDecoration(@NonNull Context context) {
        this.context = context;
    }

    public FlexibleItemDecoration withDefaultDivider(Integer ... viewTypes) {
        TypedArray styledAttributes = this.context.obtainStyledAttributes(ATTRS);
        this.mDivider = styledAttributes.getDrawable(0);
        styledAttributes.recycle();
        this.mViewTypes = Arrays.asList(viewTypes);
        return this;
    }

    public FlexibleItemDecoration withDivider(@DrawableRes int resId, Integer ... viewTypes) {
        this.mDivider = ContextCompat.getDrawable((Context)this.context, (int)resId);
        this.mViewTypes = Arrays.asList(viewTypes);
        return this;
    }

    public FlexibleItemDecoration withDrawDividerOnLastItem(boolean lastItem) {
        this.mDividerOnLastItem = lastItem ? 0 : 1;
        return this;
    }

    public FlexibleItemDecoration removeDivider() {
        this.mDivider = null;
        return this;
    }

    public FlexibleItemDecoration withDrawOver(boolean drawOver) {
        this.mDrawOver = drawOver;
        return this;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDivider != null && !this.mDrawOver) {
            this.draw(c, parent);
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDivider != null && this.mDrawOver) {
            this.draw(c, parent);
        }
    }

    protected void draw(Canvas c, RecyclerView parent) {
        if (parent.getLayoutManager() == null) {
            return;
        }
        if (LayoutUtils.getOrientation((RecyclerView)parent) == 1) {
            this.drawVertical(c, parent);
        } else {
            this.drawHorizontal(c, parent);
        }
    }

    @SuppressLint(value={"NewApi"})
    protected void drawVertical(Canvas canvas, RecyclerView parent) {
        int right;
        int left;
        canvas.save();
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
            canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        } else {
            left = 0;
            right = parent.getWidth();
        }
        int itemCount = parent.getChildCount();
        for (int i = 0; i < itemCount - this.mDividerOnLastItem; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.ViewHolder viewHolder = parent.getChildViewHolder(child);
            if (!this.shouldDrawDivider(viewHolder)) continue;
            parent.getDecoratedBoundsWithMargins(child, this.mBounds);
            int bottom = this.mBounds.bottom + Math.round(child.getTranslationY());
            int top = bottom - this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(canvas);
        }
        canvas.restore();
    }

    @SuppressLint(value={"NewApi"})
    protected void drawHorizontal(Canvas canvas, RecyclerView parent) {
        int bottom;
        int top;
        canvas.save();
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
            canvas.clipRect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
        } else {
            top = 0;
            bottom = parent.getHeight();
        }
        int itemCount = parent.getChildCount();
        for (int i = 0; i < itemCount - this.mDividerOnLastItem; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.ViewHolder viewHolder = parent.getChildViewHolder(child);
            if (!this.shouldDrawDivider(viewHolder)) continue;
            parent.getLayoutManager().getDecoratedBoundsWithMargins(child, this.mBounds);
            int right = this.mBounds.right + Math.round(child.getTranslationX());
            int left = right - this.mDivider.getIntrinsicWidth();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(canvas);
        }
        canvas.restore();
    }

    protected boolean shouldDrawDivider(RecyclerView.ViewHolder viewHolder) {
        return this.mViewTypes == null || this.mViewTypes.isEmpty() || this.mViewTypes.contains(viewHolder.getItemViewType());
    }

    public FlexibleItemDecoration withSectionGapOffset(@IntRange(from=0L) int sectionOffset) {
        this.mSectionOffset = (int)(this.context.getResources().getDisplayMetrics().density * (float)sectionOffset);
        return this;
    }

    public FlexibleItemDecoration withSectionGapOnLastItem(boolean lastItem) {
        this.mSectionGapOnLastItem = lastItem ? 1 : 0;
        return this;
    }

    public FlexibleItemDecoration withEdge(boolean withEdge) {
        this.withRightEdge = this.withBottomEdge = withEdge;
        this.withTopEdge = this.withBottomEdge;
        this.withLeftEdge = this.withBottomEdge;
        return this;
    }

    public FlexibleItemDecoration withLeftEdge(boolean withLeftEdge) {
        this.withLeftEdge = withLeftEdge;
        return this;
    }

    public FlexibleItemDecoration withTopEdge(boolean withTopEdge) {
        this.withTopEdge = withTopEdge;
        return this;
    }

    public FlexibleItemDecoration withBottomEdge(boolean withBottomEdge) {
        this.withBottomEdge = withBottomEdge;
        return this;
    }

    public FlexibleItemDecoration withRightEdge(boolean withRightEdge) {
        this.withRightEdge = withRightEdge;
        return this;
    }

    public int getOffset() {
        return (int)((float)this.mOffset / this.context.getResources().getDisplayMetrics().density);
    }

    public FlexibleItemDecoration withOffset(@IntRange(from=0L) int offset) {
        this.mOffset = (int)(this.context.getResources().getDisplayMetrics().density * (float)offset);
        return this;
    }

    public FlexibleItemDecoration addItemViewType(@LayoutRes int viewType) {
        return this.addItemViewType(viewType, -1);
    }

    public FlexibleItemDecoration addItemViewType(@LayoutRes int viewType, int offset) {
        return this.addItemViewType(viewType, offset, offset, offset, offset);
    }

    public FlexibleItemDecoration addItemViewType(@LayoutRes int viewType, int left, int top, int right, int bottom) {
        if (this.mDecorations == null) {
            this.mDecorations = new SparseArray();
        }
        left = (int)(this.context.getResources().getDisplayMetrics().density * (float)left);
        top = (int)(this.context.getResources().getDisplayMetrics().density * (float)top);
        right = (int)(this.context.getResources().getDisplayMetrics().density * (float)right);
        bottom = (int)(this.context.getResources().getDisplayMetrics().density * (float)bottom);
        this.mDecorations.put(viewType, (Object)new ItemDecoration(left, top, right, bottom));
        return this;
    }

    public FlexibleItemDecoration removeItemViewType(@LayoutRes int viewType) {
        this.mDecorations.remove(viewType);
        return this;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        GridLayoutManager lm;
        GridLayoutManager.LayoutParams lp;
        int position = recyclerView.getChildAdapterPosition(view);
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        int itemType = position != -1 ? adapter.getItemViewType(position) : 0;
        ItemDecoration deco = this.getItemDecoration(itemType);
        if (!deco.hasOffset()) {
            deco = new ItemDecoration(this.mOffset);
        }
        int spanIndex = 0;
        int spanSize = 1;
        int spanCount = 1;
        int orientation = 1;
        if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
            lp = (GridLayoutManager.LayoutParams)view.getLayoutParams();
            spanIndex = lp.getSpanIndex();
            spanSize = lp.getSpanSize();
            lm = (GridLayoutManager)recyclerView.getLayoutManager();
            spanCount = lm.getSpanCount();
            orientation = lm.getOrientation();
        } else if (recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
            lp = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams();
            spanIndex = lp.getSpanIndex();
            lm = (StaggeredGridLayoutManager)recyclerView.getLayoutManager();
            spanCount = lm.getSpanCount();
            spanSize = lp.isFullSpan() ? spanCount : 1;
            orientation = lm.getOrientation();
        }
        boolean isFirstRowOrColumn = this.isFirstRowOrColumn(position, adapter, spanIndex, itemType);
        boolean isLastRowOrColumn = this.isLastRowOrColumn(position, adapter, spanIndex, spanCount, spanSize, itemType);
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        if (orientation == 1) {
            int index = spanIndex;
            if (this.withLeftEdge) {
                index = spanCount - spanIndex;
            }
            left = deco.left * index / spanCount;
            index = spanCount - (spanIndex + spanSize - 1) - 1;
            if (this.withRightEdge) {
                index = spanIndex + spanSize;
            }
            right = deco.right * index / spanCount;
            if (isFirstRowOrColumn && this.withTopEdge) {
                top = deco.top;
            }
            if (isLastRowOrColumn) {
                if (this.withBottomEdge) {
                    bottom = deco.bottom;
                }
            } else {
                bottom = deco.bottom;
            }
        } else {
            int index = spanIndex;
            if (this.withTopEdge) {
                index = spanCount - spanIndex;
            }
            top = deco.top * index / spanCount;
            index = spanCount - (spanIndex + spanSize - 1) - 1;
            if (this.withBottomEdge) {
                index = spanIndex + spanSize;
            }
            bottom = deco.bottom * index / spanCount;
            if (isFirstRowOrColumn && this.withLeftEdge) {
                left = deco.left;
            }
            if (isLastRowOrColumn) {
                if (this.withRightEdge) {
                    right = deco.right;
                }
            } else {
                right = deco.right;
            }
        }
        outRect.set(left, top, right, bottom);
        this.applySectionGap(outRect, adapter, position, orientation);
    }

    @NonNull
    private ItemDecoration getItemDecoration(int itemType) {
        ItemDecoration deco = null;
        if (this.mDecorations != null) {
            deco = (ItemDecoration)this.mDecorations.get(itemType);
        }
        if (deco == null) {
            deco = this.mDefaultDecoration;
        }
        return deco;
    }

    private boolean isFirstRowOrColumn(int position, RecyclerView.Adapter adapter, int spanIndex, int itemType) {
        int prePos = position > 0 ? position - 1 : -1;
        int preRowPos = position > spanIndex ? position - (1 + spanIndex) : -1;
        return position == 0 || prePos == -1 || itemType != adapter.getItemViewType(prePos) || preRowPos == -1 || itemType != adapter.getItemViewType(preRowPos);
    }

    private boolean isLastRowOrColumn(int position, RecyclerView.Adapter adapter, int spanIndex, int spanCount, int spanSize, int itemType) {
        int itemCount = adapter.getItemCount();
        int nextPos = position < itemCount - 1 ? position + 1 : -1;
        int nextRowPos = position < itemCount - (spanCount / spanSize - spanIndex) ? position + (spanCount / spanSize - spanIndex) : -1;
        return position == itemCount - 1 || nextPos == -1 || itemType != adapter.getItemViewType(nextPos) || nextRowPos == -1 || itemType != adapter.getItemViewType(nextRowPos);
    }

    private void applySectionGap(Rect outRect, RecyclerView.Adapter adapter, int position, int orientation) {
        if (this.mSectionOffset > 0 && adapter instanceof FlexibleAdapter) {
            FlexibleAdapter flexibleAdapter = (FlexibleAdapter)adapter;
            IFlexible nextItem = flexibleAdapter.getItem(position + 1);
            if (flexibleAdapter.isHeader(nextItem)) {
                if (orientation == 1) {
                    outRect.bottom += this.mSectionOffset;
                } else {
                    outRect.right += this.mSectionOffset;
                }
            }
            if (position >= adapter.getItemCount() - this.mSectionGapOnLastItem) {
                if (orientation == 1) {
                    outRect.bottom += this.mSectionOffset;
                } else {
                    outRect.right += this.mSectionOffset;
                }
            }
        }
    }

    private static class ItemDecoration {
        private int left;
        private int top;
        private int right;
        private int bottom;

        ItemDecoration() {
            this(-1);
        }

        ItemDecoration(int offset) {
            this(offset, offset, offset, offset);
        }

        ItemDecoration(int left, int top, int right, int bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        final boolean hasOffset() {
            return this.top >= 0 || this.left >= 0 || this.right >= 0 || this.bottom >= 0;
        }
    }
}

