/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.widget.TextView;
import eu.davidea.flexibleadapter.helpers.R;
import java.util.Locale;

public final class FlexibleUtils {
    public static final String SPLIT_EXPRESSION = "([, ]+)";
    public static final int INVALID_COLOR = -1;
    public static int colorAccent = -1;

    public static boolean hasOreo() {
        return Build.VERSION.SDK_INT >= 26;
    }

    public static boolean hasNougat() {
        return Build.VERSION.SDK_INT >= 24;
    }

    public static boolean hasMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static boolean hasLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean hasJellyBean() {
        return Build.VERSION.SDK_INT >= 16;
    }

    @NonNull
    @SuppressLint(value={"SwitchIntDef"})
    public static String getModeName(int mode) {
        switch (mode) {
            case 1: {
                return "SINGLE";
            }
            case 2: {
                return "MULTI";
            }
        }
        return "IDLE";
    }

    @NonNull
    public static String getClassName(@Nullable Object o) {
        return o == null ? "null" : o.getClass().getSimpleName();
    }

    public static void highlightText(@NonNull TextView textView, @Nullable String originalText, @Nullable String constraint) {
        int accentColor = FlexibleUtils.fetchAccentColor(textView.getContext(), 1);
        FlexibleUtils.highlightText(textView, originalText, constraint, accentColor);
    }

    public static void highlightText(@NonNull TextView textView, @Nullable String originalText, @Nullable String constraint, @ColorInt int color) {
        constraint = FlexibleUtils.toLowerCase(constraint);
        int start = FlexibleUtils.toLowerCase(originalText).indexOf(constraint);
        if (start != -1) {
            Spannable spanText = Spannable.Factory.getInstance().newSpannable((CharSequence)originalText);
            FlexibleUtils.spanText(originalText, constraint, color, start, spanText);
            textView.setText((CharSequence)spanText, TextView.BufferType.SPANNABLE);
        } else {
            textView.setText((CharSequence)originalText, TextView.BufferType.NORMAL);
        }
    }

    public static void highlightWords(@NonNull TextView textView, @Nullable String originalText, @Nullable String constraints) {
        int accentColor = FlexibleUtils.fetchAccentColor(textView.getContext(), 1);
        FlexibleUtils.highlightWords(textView, originalText, constraints, accentColor);
    }

    public static void highlightWords(@NonNull TextView textView, @Nullable String originalText, @Nullable String constraints, @ColorInt int color) {
        constraints = FlexibleUtils.toLowerCase(constraints);
        Spannable spanText = null;
        for (String constraint : constraints.split(SPLIT_EXPRESSION)) {
            int start = FlexibleUtils.toLowerCase(originalText).indexOf(constraint);
            if (start == -1) continue;
            if (spanText == null) {
                spanText = Spannable.Factory.getInstance().newSpannable((CharSequence)originalText);
            }
            FlexibleUtils.spanText(originalText, constraint, color, start, spanText);
        }
        if (spanText != null) {
            textView.setText(spanText, TextView.BufferType.SPANNABLE);
        } else {
            textView.setText((CharSequence)originalText, TextView.BufferType.NORMAL);
        }
    }

    private static void spanText(@NonNull String originalText, @NonNull String constraint, @ColorInt int color, int start, @NonNull Spannable spanText) {
        int end;
        do {
            end = start + constraint.length();
            spanText.setSpan((Object)new ForegroundColorSpan(color), start, end, 33);
            spanText.setSpan((Object)new StyleSpan(1), start, end, 33);
        } while ((start = FlexibleUtils.toLowerCase(originalText).indexOf(constraint, end + 1)) != -1);
    }

    public static String toLowerCase(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        return text.toLowerCase(Locale.getDefault());
    }

    public static void resetAccentColor() {
        colorAccent = -1;
    }

    public static int fetchAccentColor(Context context, @ColorInt int defColor) {
        if (colorAccent == -1) {
            int attr2 = R.attr.colorAccent;
            if (FlexibleUtils.hasLollipop()) {
                attr2 = 16843829;
            }
            TypedArray androidAttr = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            colorAccent = androidAttr.getColor(0, defColor);
            androidAttr.recycle();
        }
        return colorAccent;
    }
}

