/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.view.ViewCompat;
import android.util.TypedValue;
import android.view.View;
import eu.davidea.flexibleadapter.helpers.R;
import eu.davidea.flexibleadapter.utils.FlexibleUtils;
import java.util.Arrays;

public final class DrawableUtils {
    public static void setBackgroundCompat(View view, Drawable drawable) {
        ViewCompat.setBackground((View)view, (Drawable)drawable);
    }

    public static void setBackgroundCompat(View view, @DrawableRes int drawableRes) {
        DrawableUtils.setBackgroundCompat(view, DrawableUtils.getDrawableCompat(view.getContext(), drawableRes));
    }

    public static Drawable getDrawableCompat(Context context, @DrawableRes int drawableRes) {
        try {
            if (FlexibleUtils.hasLollipop()) {
                return context.getResources().getDrawable(drawableRes, context.getTheme());
            }
            return context.getResources().getDrawable(drawableRes);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Drawable getSelectableItemBackground(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        return DrawableUtils.getDrawableCompat(context, outValue.resourceId);
    }

    @ColorInt
    public static int getColorControlHighlight(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorControlHighlight, outValue, true);
        if (FlexibleUtils.hasMarshmallow()) {
            return context.getColor(outValue.resourceId);
        }
        return context.getResources().getColor(outValue.resourceId);
    }

    public static Drawable getSelectableBackgroundCompat(@ColorInt int normalColor, @ColorInt int pressedColor, @ColorInt int rippleColor) {
        if (FlexibleUtils.hasLollipop()) {
            return new RippleDrawable(ColorStateList.valueOf((int)rippleColor), (Drawable)DrawableUtils.getStateListDrawable(normalColor, pressedColor), DrawableUtils.getRippleMask(normalColor));
        }
        return DrawableUtils.getStateListDrawable(normalColor, pressedColor);
    }

    public static Drawable getRippleDrawable(Drawable drawable, @ColorInt int rippleColor) {
        if (FlexibleUtils.hasLollipop()) {
            return new RippleDrawable(ColorStateList.valueOf((int)rippleColor), drawable, DrawableUtils.getRippleMask(-16777216));
        }
        return drawable;
    }

    private static Drawable getRippleMask(@ColorInt int color) {
        float[] outerRadii = new float[8];
        Arrays.fill(outerRadii, 3.0f);
        RoundRectShape r = new RoundRectShape(outerRadii, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)r);
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }

    private static StateListDrawable getStateListDrawable(@ColorInt int normalColor, @ColorInt int pressedColor) {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16843518}, (Drawable)DrawableUtils.getColorDrawable(pressedColor));
        if (!FlexibleUtils.hasLollipop()) {
            states.addState(new int[]{16842919}, (Drawable)DrawableUtils.getColorDrawable(pressedColor));
        }
        states.addState(new int[0], (Drawable)DrawableUtils.getColorDrawable(normalColor));
        if (!FlexibleUtils.hasLollipop() || FlexibleUtils.hasNougat()) {
            int duration = 200;
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        return states;
    }

    public static ColorDrawable getColorDrawable(@ColorInt int color) {
        return new ColorDrawable(color);
    }
}

