/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.design.widget.BaseTransientBottomBar;
import android.support.design.widget.Snackbar;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.utils.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class UndoHelper
extends Snackbar.Callback
implements FlexibleAdapter.OnDeleteCompleteListener {
    public static final int UNDO_TIMEOUT = 5000;
    private int mAction = 0;
    @ColorInt
    private int mActionTextColor = 0;
    private boolean consecutive = false;
    private List<Integer> mPositions = null;
    private Object mPayload = null;
    private FlexibleAdapter mAdapter;
    private OnActionListener mUndoListener;
    private Snackbar mSnackbar;

    public UndoHelper(FlexibleAdapter adapter, OnActionListener undoListener) {
        this.mAdapter = adapter;
        this.mAdapter.addListener((Object)this);
        this.mUndoListener = undoListener;
    }

    public UndoHelper withPayload(Object payload) {
        if (payload != null) {
            Log.d((String)"With payload", (Object[])new Object[0]);
        }
        this.mPayload = payload;
        return this;
    }

    public UndoHelper withAction(int action) {
        this.mAction = action;
        return this;
    }

    public UndoHelper withActionTextColor(@ColorInt int color) {
        Log.d((String)"With customActionTextColor", (Object[])new Object[0]);
        this.mActionTextColor = color;
        return this;
    }

    public UndoHelper withConsecutive(boolean consecutive) {
        Log.d((String)"With consecutive=%s", (Object[])new Object[]{consecutive});
        this.consecutive = consecutive;
        return this;
    }

    public Snackbar start(List<Integer> positions, @NonNull View mainView, @StringRes int messageStringResId, @StringRes int actionStringResId, @IntRange(from=-1L) int duration) {
        Context context = mainView.getContext();
        return this.start(positions, mainView, context.getString(messageStringResId), context.getString(actionStringResId), duration);
    }

    public Snackbar start(List<Integer> positions, @NonNull View mainView, CharSequence message, CharSequence actionText, @IntRange(from=-1L) int duration) {
        Log.d((String)"With %s", (Object[])new Object[]{this.mAction == 0 ? "ACTION_REMOVE" : "ACTION_UPDATE"});
        this.mPositions = positions;
        if (!this.mAdapter.isPermanentDelete()) {
            this.mSnackbar = Snackbar.make((View)mainView, (CharSequence)message, (int)(duration > 0 ? duration + 400 : duration)).setAction(actionText, new View.OnClickListener(){

                public void onClick(View view) {
                    if (UndoHelper.this.mUndoListener != null) {
                        Log.v((String)"onActionCanceled event=1", (Object[])new Object[0]);
                        UndoHelper.this.mUndoListener.onActionCanceled(UndoHelper.this.mAction, UndoHelper.this.mAdapter.getUndoPositions());
                        UndoHelper.this.mAdapter.emptyBin();
                    }
                }
            });
            if (this.mActionTextColor != 0) {
                this.mSnackbar.setActionTextColor(this.mActionTextColor);
            }
        } else {
            this.mSnackbar = Snackbar.make((View)mainView, (CharSequence)message, (int)duration);
        }
        this.mSnackbar.addCallback((BaseTransientBottomBar.BaseCallback)this);
        this.mSnackbar.show();
        this.performAction();
        return this.mSnackbar;
    }

    private void performAction() {
        if (this.consecutive && this.mAdapter.isRestoreInTime()) {
            this.onDeleteConfirmed(4);
        }
        switch (this.mAction) {
            case 0: {
                this.mAdapter.removeItems(this.mPositions, this.mPayload);
                break;
            }
            case 1: {
                this.mAdapter.saveUndoPositions(this.mPositions);
            }
        }
        if (this.mAdapter.isPermanentDelete() && this.mUndoListener != null) {
            this.mUndoListener.onActionConfirmed(this.mAction, 3);
        }
    }

    public void onDeleteConfirmed(int event) {
        if (this.mUndoListener != null) {
            Log.v((String)"onActionConfirmed event=%s", (Object[])new Object[]{event});
            this.mUndoListener.onActionConfirmed(this.mAction, event);
        }
        this.mAdapter.emptyBin();
        if (this.mSnackbar.isShown() && this.mAction == 0 && !this.mAdapter.isRestoreInTime()) {
            this.mSnackbar.dismiss();
        }
    }

    public void onDismissed(Snackbar snackbar, int event) {
        if (this.mAdapter == null || this.mAction == 0 && !this.mAdapter.isRestoreInTime()) {
            return;
        }
        switch (event) {
            case 0: 
            case 2: 
            case 3: {
                this.onDeleteConfirmed(event);
                break;
            }
        }
        this.onDestroy();
        Log.v((String)"Snackbar dismissed with event=%s", (Object[])new Object[]{event});
    }

    public void onShown(Snackbar snackbar) {
    }

    private void onDestroy() {
        if (this.mAdapter != null) {
            this.mAdapter.removeListener((Object)this);
        }
        this.mAdapter = null;
        this.mSnackbar = null;
        this.mPositions = null;
        this.mPayload = null;
        this.mUndoListener = null;
    }

    public static interface OnActionListener {
        public void onActionCanceled(int var1, List<Integer> var2);

        public void onActionConfirmed(int var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
        public static final int REMOVE = 0;
        public static final int UPDATE = 1;
    }
}

