/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import java.util.List;

public class AnimatorHelper {
    public static void alphaAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float alphaFrom) {
        view.setAlpha(0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{alphaFrom, 1.0f}));
    }

    public static void slideInFromLeftAnimator(@NonNull List<Animator> animators, @NonNull View view, RecyclerView recyclerView, @FloatRange(from=0.0, to=1.0) float percent) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{(float)(-recyclerView.getLayoutManager().getWidth()) * percent, 0.0f}));
    }

    public static void slideInFromRightAnimator(@NonNull List<Animator> animators, @NonNull View view, RecyclerView recyclerView, @FloatRange(from=0.0, to=1.0) float percent) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{(float)recyclerView.getLayoutManager().getWidth() * percent, 0.0f}));
    }

    public static void slideInFromTopAnimator(@NonNull List<Animator> animators, @NonNull View view, RecyclerView recyclerView) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{-recyclerView.getMeasuredHeight() >> 1, 0.0f}));
    }

    public static void slideInFromBottomAnimator(@NonNull List<Animator> animators, @NonNull View view, RecyclerView recyclerView) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{recyclerView.getMeasuredHeight() >> 1, 0.0f}));
    }

    public static void scaleAnimator(@NonNull List<Animator> animators, @NonNull View view, @FloatRange(from=0.0, to=1.0) float scaleFrom) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{scaleFrom, 1.0f}));
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{scaleFrom, 1.0f}));
    }

    public static void flipAnimator(@NonNull List<Animator> animators, @NonNull View view) {
        AnimatorHelper.alphaAnimator(animators, view, 0.0f);
        animators.add((Animator)ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.0f, 1.0f}));
    }

    public static void setDuration(@NonNull List<Animator> animators, @IntRange(from=0L) long duration) {
        if (animators.size() > 0) {
            Animator animator = animators.get(animators.size() - 1);
            animator.setDuration(duration);
        }
    }
}

