/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.helpers;

import android.support.annotation.CallSuper;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.utils.Log;
import java.util.List;

public class ActionModeHelper
implements ActionMode.Callback {
    private int defaultMode = 0;
    @MenuRes
    private int mCabMenu;
    private boolean disableSwipe;
    private boolean disableDrag;
    private boolean longPressDragDisabledByHelper;
    private boolean handleDragDisabledByHelper;
    private boolean swipeDisabledByHelper;
    private FlexibleAdapter mAdapter;
    private ActionMode.Callback mCallback;
    protected ActionMode mActionMode;

    public ActionModeHelper(@NonNull FlexibleAdapter adapter, @MenuRes int cabMenu) {
        this.mAdapter = adapter;
        this.mCabMenu = cabMenu;
    }

    public ActionModeHelper(@NonNull FlexibleAdapter adapter, @MenuRes int cabMenu, @Nullable ActionMode.Callback callback) {
        this(adapter, cabMenu);
        this.mCallback = callback;
    }

    public final ActionModeHelper withDefaultMode(int defaultMode) {
        if (defaultMode == 0 || defaultMode == 1) {
            this.defaultMode = defaultMode;
        }
        return this;
    }

    public final ActionModeHelper disableDragOnActionMode(boolean disableDrag) {
        this.disableDrag = disableDrag;
        return this;
    }

    public final ActionModeHelper disableSwipeOnActionMode(boolean disableSwipe) {
        this.disableSwipe = disableSwipe;
        return this;
    }

    public ActionMode getActionMode() {
        return this.mActionMode;
    }

    public int getActivatedPosition() {
        List selectedPositions = this.mAdapter.getSelectedPositions();
        if (this.mAdapter.getMode() == 1 && selectedPositions.size() == 1) {
            return (Integer)selectedPositions.get(0);
        }
        return -1;
    }

    public boolean onClick(int position) {
        if (position != -1) {
            this.toggleSelection(position);
            return true;
        }
        return false;
    }

    @NonNull
    public ActionMode onLongClick(AppCompatActivity activity, int position) {
        if (this.mActionMode == null) {
            this.mActionMode = activity.startSupportActionMode((ActionMode.Callback)this);
        }
        this.toggleSelection(position);
        return this.mActionMode;
    }

    public void toggleSelection(int position) {
        if (position >= 0 && (this.mAdapter.getMode() == 1 && !this.mAdapter.isSelected(position) || this.mAdapter.getMode() == 2)) {
            this.mAdapter.toggleSelection(position);
        }
        if (this.mActionMode == null) {
            return;
        }
        int count = this.mAdapter.getSelectedItemCount();
        if (count == 0) {
            this.mActionMode.finish();
        } else {
            this.updateContextTitle(count);
        }
    }

    public void updateContextTitle(int count) {
        if (this.mActionMode != null) {
            this.mActionMode.setTitle((CharSequence)String.valueOf(count));
        }
    }

    public void restoreSelection(AppCompatActivity activity) {
        if (this.defaultMode == 0 && this.mAdapter.getSelectedItemCount() > 0 || this.defaultMode == 1 && this.mAdapter.getSelectedItemCount() > 1) {
            this.onLongClick(activity, -1);
        }
    }

    @CallSuper
    public boolean onCreateActionMode(ActionMode actionMode, Menu menu) {
        actionMode.getMenuInflater().inflate(this.mCabMenu, menu);
        Log.d((String)"ActionMode is active!", (Object[])new Object[0]);
        this.mAdapter.setMode(2);
        this.disableSwipeDragCapabilities();
        return this.mCallback == null || this.mCallback.onCreateActionMode(actionMode, menu);
    }

    @CallSuper
    public boolean onPrepareActionMode(ActionMode actionMode, Menu menu) {
        return this.mCallback != null && this.mCallback.onPrepareActionMode(actionMode, menu);
    }

    @CallSuper
    public boolean onActionItemClicked(ActionMode actionMode, MenuItem item) {
        boolean consumed = false;
        if (this.mCallback != null) {
            consumed = this.mCallback.onActionItemClicked(actionMode, item);
        }
        if (!consumed) {
            actionMode.finish();
        }
        return consumed;
    }

    @CallSuper
    public void onDestroyActionMode(ActionMode actionMode) {
        Log.d((String)"ActionMode is about to be destroyed!", (Object[])new Object[0]);
        this.mAdapter.setMode(this.defaultMode);
        this.mAdapter.clearSelection();
        this.mActionMode = null;
        this.enableSwipeDragCapabilities();
        if (this.mCallback != null) {
            this.mCallback.onDestroyActionMode(actionMode);
        }
    }

    public boolean destroyActionModeIfCan() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            return true;
        }
        return false;
    }

    private void enableSwipeDragCapabilities() {
        if (this.longPressDragDisabledByHelper) {
            this.longPressDragDisabledByHelper = false;
            this.mAdapter.setLongPressDragEnabled(true);
        }
        if (this.handleDragDisabledByHelper) {
            this.handleDragDisabledByHelper = false;
            this.mAdapter.setHandleDragEnabled(true);
        }
        if (this.swipeDisabledByHelper) {
            this.swipeDisabledByHelper = false;
            this.mAdapter.setSwipeEnabled(true);
        }
    }

    private void disableSwipeDragCapabilities() {
        if (this.disableDrag && this.mAdapter.isLongPressDragEnabled()) {
            this.longPressDragDisabledByHelper = true;
            this.mAdapter.setLongPressDragEnabled(false);
        }
        if (this.disableDrag && this.mAdapter.isHandleDragEnabled()) {
            this.handleDragDisabledByHelper = true;
            this.mAdapter.setHandleDragEnabled(false);
        }
        if (this.disableSwipe && this.mAdapter.isSwipeEnabled()) {
            this.swipeDisabledByHelper = true;
            this.mAdapter.setSwipeEnabled(false);
        }
    }
}

