/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.common;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import eu.davidea.flexibleadapter.utils.Log;
import eu.davidea.viewholders.AnimatedViewHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FlexibleItemAnimator
extends SimpleItemAnimator {
    private ArrayList<RecyclerView.ViewHolder> mPendingRemovals = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    private ArrayList<ChangeInfo> mPendingChanges = new ArrayList();
    private ArrayList<ArrayList<RecyclerView.ViewHolder>> mAdditionsList = new ArrayList();
    private ArrayList<ArrayList<MoveInfo>> mMovesList = new ArrayList();
    private ArrayList<ArrayList<ChangeInfo>> mChangesList = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mChangeAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mRemoveAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mAddAnimations = new ArrayList();
    protected Interpolator mInterpolator = new LinearInterpolator();
    private TimeInterpolator mDefaultInterpolator;

    public FlexibleItemAnimator() {
        this.setSupportsChangeAnimations(true);
    }

    public void setInterpolator(Interpolator mInterpolator) {
        this.mInterpolator = mInterpolator;
    }

    public final void runPendingAnimations() {
        boolean additionsPending;
        boolean removalsPending = !this.mPendingRemovals.isEmpty();
        boolean movesPending = !this.mPendingMoves.isEmpty();
        boolean changesPending = !this.mPendingChanges.isEmpty();
        boolean bl = additionsPending = !this.mPendingAdditions.isEmpty();
        if (!(removalsPending || movesPending || additionsPending || changesPending)) {
            return;
        }
        this.runRemoveAnimation();
        this.runMoveAnimation(removalsPending, movesPending);
        this.runChangeAnimation(removalsPending, changesPending);
        this.runAddAnimation(removalsPending, changesPending, movesPending, additionsPending);
    }

    private void runRemoveAnimation() {
        Collections.sort(this.mPendingRemovals, new Comparator<RecyclerView.ViewHolder>(){

            @Override
            public int compare(RecyclerView.ViewHolder vh1, RecyclerView.ViewHolder vh2) {
                return (int)(vh2.getItemId() - vh1.getItemId());
            }
        });
        Runnable remover = new Runnable(){

            @Override
            public void run() {
                int index = 0;
                for (RecyclerView.ViewHolder holder : FlexibleItemAnimator.this.mPendingRemovals) {
                    FlexibleItemAnimator.this.doAnimateRemove(holder, index++);
                }
                FlexibleItemAnimator.this.mPendingRemovals.clear();
            }
        };
        remover.run();
    }

    private void runMoveAnimation(boolean removalsPending, boolean movesPending) {
        if (movesPending) {
            final ArrayList<MoveInfo> moves = new ArrayList<MoveInfo>();
            moves.addAll(this.mPendingMoves);
            this.mMovesList.add(moves);
            this.mPendingMoves.clear();
            Runnable mover = new Runnable(){

                @Override
                public void run() {
                    for (MoveInfo moveInfo : moves) {
                        FlexibleItemAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY);
                    }
                    moves.clear();
                    FlexibleItemAnimator.this.mMovesList.remove(moves);
                }
            };
            if (removalsPending) {
                View view = ((MoveInfo)moves.get((int)0)).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)mover, (long)this.getRemoveDuration());
            } else {
                mover.run();
            }
        }
    }

    private void runChangeAnimation(boolean removalsPending, boolean changesPending) {
        if (changesPending) {
            final ArrayList<ChangeInfo> changes = new ArrayList<ChangeInfo>();
            changes.addAll(this.mPendingChanges);
            this.mChangesList.add(changes);
            this.mPendingChanges.clear();
            Runnable changer = new Runnable(){

                @Override
                public void run() {
                    for (ChangeInfo change : changes) {
                        FlexibleItemAnimator.this.animateChangeImpl(change);
                    }
                    changes.clear();
                    FlexibleItemAnimator.this.mChangesList.remove(changes);
                }
            };
            if (removalsPending) {
                RecyclerView.ViewHolder holder = ((ChangeInfo)changes.get((int)0)).oldHolder;
                ViewCompat.postOnAnimationDelayed((View)holder.itemView, (Runnable)changer, (long)this.getRemoveDuration());
            } else {
                changer.run();
            }
        }
    }

    private void runAddAnimation(boolean removalsPending, boolean changesPending, boolean movesPending, boolean additionsPending) {
        if (additionsPending) {
            final ArrayList<RecyclerView.ViewHolder> additions = new ArrayList<RecyclerView.ViewHolder>();
            Collections.sort(this.mPendingAdditions, new Comparator<RecyclerView.ViewHolder>(){

                @Override
                public int compare(RecyclerView.ViewHolder vh1, RecyclerView.ViewHolder vh2) {
                    return vh1.getLayoutPosition() - vh2.getLayoutPosition();
                }
            });
            additions.addAll(this.mPendingAdditions);
            this.mAdditionsList.add(additions);
            this.mPendingAdditions.clear();
            Runnable adder = new Runnable(){

                @Override
                public void run() {
                    int index = 0;
                    for (RecyclerView.ViewHolder holder : additions) {
                        FlexibleItemAnimator.this.doAnimateAdd(holder, index++);
                    }
                    additions.clear();
                    FlexibleItemAnimator.this.mAdditionsList.remove(additions);
                }
            };
            if (removalsPending || movesPending || changesPending) {
                long removeDuration = removalsPending ? this.getRemoveDuration() : 0L;
                long moveDuration = movesPending ? this.getMoveDuration() : 0L;
                long changeDuration = changesPending ? this.getChangeDuration() : 0L;
                long totalDelay = removeDuration + Math.max(moveDuration, changeDuration);
                View view = ((RecyclerView.ViewHolder)additions.get((int)0)).itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)adder, (long)totalDelay);
            } else {
                adder.run();
            }
        }
    }

    protected boolean preAnimateRemoveImpl(RecyclerView.ViewHolder holder) {
        return true;
    }

    protected void animateRemoveImpl(RecyclerView.ViewHolder holder, int index) {
    }

    private boolean preAnimateRemove(RecyclerView.ViewHolder holder) {
        FlexibleItemAnimator.clear(holder.itemView);
        boolean consumed = false;
        if (holder instanceof AnimatedViewHolder) {
            consumed = ((AnimatedViewHolder)holder).preAnimateRemoveImpl();
        }
        return consumed || this.preAnimateRemoveImpl(holder);
    }

    private void doAnimateRemove(RecyclerView.ViewHolder holder, int index) {
        Log.v((String)"AnimateRemove on itemId %s", (Object[])new Object[]{holder.getItemId()});
        boolean consumed = false;
        if (holder instanceof AnimatedViewHolder) {
            consumed = ((AnimatedViewHolder)holder).animateRemoveImpl((ViewPropertyAnimatorListener)new DefaultRemoveVpaListener(holder), this.getRemoveDuration(), index);
        }
        if (!consumed) {
            this.animateRemoveImpl(holder, index);
        }
        this.mRemoveAnimations.add(holder);
    }

    public final boolean animateRemove(RecyclerView.ViewHolder holder) {
        this.endAnimation(holder);
        return this.preAnimateRemove(holder) && this.mPendingRemovals.add(holder);
    }

    protected boolean preAnimateAddImpl(RecyclerView.ViewHolder holder) {
        return true;
    }

    protected void animateAddImpl(RecyclerView.ViewHolder holder, int index) {
    }

    private boolean preAnimateAdd(RecyclerView.ViewHolder holder) {
        FlexibleItemAnimator.clear(holder.itemView);
        boolean consumed = false;
        if (holder instanceof AnimatedViewHolder) {
            consumed = ((AnimatedViewHolder)holder).preAnimateAddImpl();
        }
        return consumed || this.preAnimateAddImpl(holder);
    }

    private void doAnimateAdd(RecyclerView.ViewHolder holder, int index) {
        Log.v((String)"AnimateAdd on itemId=%s position=%s", (Object[])new Object[]{holder.getItemId(), holder.getLayoutPosition()});
        boolean consumed = false;
        if (holder instanceof AnimatedViewHolder) {
            consumed = ((AnimatedViewHolder)holder).animateAddImpl((ViewPropertyAnimatorListener)new DefaultAddVpaListener(holder), this.getAddDuration(), index);
        }
        if (!consumed) {
            this.animateAddImpl(holder, index);
        }
        this.mAddAnimations.add(holder);
    }

    public final boolean animateAdd(RecyclerView.ViewHolder holder) {
        this.endAnimation(holder);
        return this.preAnimateAdd(holder) && this.mPendingAdditions.add(holder);
    }

    public final boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        fromX = (int)((float)fromX + holder.itemView.getTranslationX());
        fromY = (int)((float)fromY + holder.itemView.getTranslationY());
        this.resetAnimation(holder);
        int deltaX = toX - fromX;
        int deltaY = toY - fromY;
        if (deltaX == 0 && deltaY == 0) {
            this.dispatchMoveFinished(holder);
            return false;
        }
        if (deltaX != 0) {
            view.setTranslationX((float)(-deltaX));
        }
        if (deltaY != 0) {
            view.setTranslationY((float)(-deltaY));
        }
        this.mPendingMoves.add(new MoveInfo(holder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateMoveImpl(final RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        final int deltaX = toX - fromX;
        final int deltaY = toY - fromY;
        if (deltaX != 0) {
            ViewCompat.animate((View)view).translationX(0.0f);
        }
        if (deltaY != 0) {
            ViewCompat.animate((View)view).translationY(0.0f);
        }
        this.mMoveAnimations.add(holder);
        final ViewPropertyAnimatorCompat animation = ViewCompat.animate((View)view);
        animation.setDuration(this.getMoveDuration()).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

            @Override
            public void onAnimationStart(View view) {
                FlexibleItemAnimator.this.dispatchMoveStarting(holder);
            }

            @Override
            public void onAnimationCancel(View view) {
                if (deltaX != 0) {
                    view.setTranslationX(0.0f);
                }
                if (deltaY != 0) {
                    view.setTranslationY(0.0f);
                }
            }

            @Override
            public void onAnimationEnd(View view) {
                animation.setListener(null);
                FlexibleItemAnimator.this.dispatchMoveFinished(holder);
                FlexibleItemAnimator.this.mMoveAnimations.remove(holder);
                FlexibleItemAnimator.this.dispatchFinishedWhenDone();
            }
        }).start();
    }

    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
        if (oldHolder == newHolder) {
            return this.animateMove(oldHolder, fromX, fromY, toX, toY);
        }
        float prevTranslationX = oldHolder.itemView.getTranslationX();
        float prevTranslationY = oldHolder.itemView.getTranslationY();
        float prevAlpha = oldHolder.itemView.getAlpha();
        this.resetAnimation(oldHolder);
        int deltaX = (int)((float)(toX - fromX) - prevTranslationX);
        int deltaY = (int)((float)(toY - fromY) - prevTranslationY);
        oldHolder.itemView.setTranslationX(prevTranslationX);
        oldHolder.itemView.setTranslationY(prevTranslationY);
        oldHolder.itemView.setAlpha(prevAlpha);
        if (newHolder != null) {
            this.resetAnimation(newHolder);
            newHolder.itemView.setTranslationX((float)(-deltaX));
            newHolder.itemView.setTranslationY((float)(-deltaY));
            newHolder.itemView.setAlpha(0.0f);
        }
        this.mPendingChanges.add(new ChangeInfo(oldHolder, newHolder, fromX, fromY, toX, toY));
        return true;
    }

    private void animateChangeImpl(final ChangeInfo changeInfo) {
        View newView;
        RecyclerView.ViewHolder holder = changeInfo.oldHolder;
        View view = holder == null ? null : holder.itemView;
        RecyclerView.ViewHolder newHolder = changeInfo.newHolder;
        View view2 = newView = newHolder != null ? newHolder.itemView : null;
        if (view != null) {
            final ViewPropertyAnimatorCompat oldViewAnim = ViewCompat.animate((View)view).setDuration(this.getChangeDuration());
            this.mChangeAnimations.add(changeInfo.oldHolder);
            oldViewAnim.translationX((float)(changeInfo.toX - changeInfo.fromX));
            oldViewAnim.translationY((float)(changeInfo.toY - changeInfo.fromY));
            oldViewAnim.alpha(0.0f).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

                @Override
                public void onAnimationStart(View view) {
                    FlexibleItemAnimator.this.dispatchChangeStarting(changeInfo.oldHolder, true);
                }

                @Override
                public void onAnimationEnd(View view) {
                    oldViewAnim.setListener(null);
                    view.setAlpha(1.0f);
                    view.setTranslationX(0.0f);
                    view.setTranslationY(0.0f);
                    FlexibleItemAnimator.this.dispatchChangeFinished(changeInfo.oldHolder, true);
                    FlexibleItemAnimator.this.mChangeAnimations.remove(changeInfo.oldHolder);
                    FlexibleItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
        if (newView != null) {
            final ViewPropertyAnimatorCompat newViewAnimation = ViewCompat.animate((View)newView);
            this.mChangeAnimations.add(changeInfo.newHolder);
            newViewAnimation.translationX(0.0f).translationY(0.0f).setDuration(this.getChangeDuration()).alpha(1.0f).setListener((ViewPropertyAnimatorListener)new VpaListenerAdapter(){

                @Override
                public void onAnimationStart(View view) {
                    FlexibleItemAnimator.this.dispatchChangeStarting(changeInfo.newHolder, false);
                }

                @Override
                public void onAnimationEnd(View view) {
                    newViewAnimation.setListener(null);
                    newView.setAlpha(1.0f);
                    newView.setTranslationX(0.0f);
                    newView.setTranslationY(0.0f);
                    FlexibleItemAnimator.this.dispatchChangeFinished(changeInfo.newHolder, false);
                    FlexibleItemAnimator.this.mChangeAnimations.remove(changeInfo.newHolder);
                    FlexibleItemAnimator.this.dispatchFinishedWhenDone();
                }
            }).start();
        }
    }

    private void endChangeAnimation(List<ChangeInfo> infoList, RecyclerView.ViewHolder item) {
        for (int i = infoList.size() - 1; i >= 0; --i) {
            ChangeInfo changeInfo = infoList.get(i);
            if (!this.endChangeAnimationIfNecessary(changeInfo, item) || changeInfo.oldHolder != null || changeInfo.newHolder != null) continue;
            infoList.remove(changeInfo);
        }
    }

    private void endChangeAnimationIfNecessary(ChangeInfo changeInfo) {
        if (changeInfo.oldHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.oldHolder);
        }
        if (changeInfo.newHolder != null) {
            this.endChangeAnimationIfNecessary(changeInfo, changeInfo.newHolder);
        }
    }

    private boolean endChangeAnimationIfNecessary(ChangeInfo changeInfo, RecyclerView.ViewHolder item) {
        boolean oldItem = false;
        if (changeInfo.newHolder == item) {
            changeInfo.newHolder = null;
        } else if (changeInfo.oldHolder == item) {
            changeInfo.oldHolder = null;
            oldItem = true;
        } else {
            return false;
        }
        item.itemView.setAlpha(1.0f);
        item.itemView.setTranslationX(0.0f);
        item.itemView.setTranslationY(0.0f);
        this.dispatchChangeFinished(item, oldItem);
        return true;
    }

    public void endAnimation(RecyclerView.ViewHolder item) {
        int i;
        View view = item.itemView;
        ViewCompat.animate((View)view).cancel();
        for (i = this.mPendingMoves.size() - 1; i >= 0; --i) {
            MoveInfo moveInfo = this.mPendingMoves.get(i);
            if (moveInfo.holder != item) continue;
            view.setTranslationY(0.0f);
            view.setTranslationX(0.0f);
            this.dispatchMoveFinished(item);
            this.mPendingMoves.remove(i);
        }
        this.endChangeAnimation(this.mPendingChanges, item);
        if (this.mPendingRemovals.remove(item)) {
            FlexibleItemAnimator.clear(item.itemView);
            this.dispatchRemoveFinished(item);
        }
        if (this.mPendingAdditions.remove(item)) {
            FlexibleItemAnimator.clear(item.itemView);
            this.dispatchAddFinished(item);
        }
        for (i = this.mChangesList.size() - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            this.endChangeAnimation(changes, item);
            if (!changes.isEmpty()) continue;
            this.mChangesList.remove(i);
        }
        block2: for (i = this.mMovesList.size() - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            for (int j = moves.size() - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                if (moveInfo.holder != item) continue;
                view.setTranslationY(0.0f);
                view.setTranslationX(0.0f);
                this.dispatchMoveFinished(item);
                moves.remove(j);
                if (!moves.isEmpty()) continue block2;
                this.mMovesList.remove(i);
                continue block2;
            }
        }
        for (i = this.mAdditionsList.size() - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            if (!additions.remove(item)) continue;
            FlexibleItemAnimator.clear(item.itemView);
            this.dispatchAddFinished(item);
            if (!additions.isEmpty()) continue;
            this.mAdditionsList.remove(i);
        }
        this.dispatchFinishedWhenDone();
    }

    private void resetAnimation(RecyclerView.ViewHolder holder) {
        if (this.mDefaultInterpolator == null) {
            this.mDefaultInterpolator = new ValueAnimator().getInterpolator();
        }
        holder.itemView.animate().setInterpolator(this.mDefaultInterpolator);
        this.endAnimation(holder);
    }

    public boolean isRunning() {
        return !this.mPendingAdditions.isEmpty() || !this.mPendingChanges.isEmpty() || !this.mPendingMoves.isEmpty() || !this.mPendingRemovals.isEmpty() || !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mChangeAnimations.isEmpty() || !this.mMovesList.isEmpty() || !this.mAdditionsList.isEmpty() || !this.mChangesList.isEmpty();
    }

    private void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    public void endAnimations() {
        int j;
        int i;
        MoveInfo item;
        int i2;
        int count = this.mPendingMoves.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingMoves.get(i2);
            View view = item.holder.itemView;
            view.setTranslationY(0.0f);
            view.setTranslationX(0.0f);
            this.dispatchMoveFinished(item.holder);
            this.mPendingMoves.remove(i2);
        }
        count = this.mPendingRemovals.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingRemovals.get(i2);
            this.dispatchRemoveFinished((RecyclerView.ViewHolder)item);
            this.mPendingRemovals.remove(i2);
        }
        count = this.mPendingAdditions.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            item = this.mPendingAdditions.get(i2);
            FlexibleItemAnimator.clear(((RecyclerView.ViewHolder)item).itemView);
            this.dispatchAddFinished((RecyclerView.ViewHolder)item);
            this.mPendingAdditions.remove(i2);
        }
        count = this.mPendingChanges.size();
        for (i2 = count - 1; i2 >= 0; --i2) {
            this.endChangeAnimationIfNecessary(this.mPendingChanges.get(i2));
        }
        this.mPendingChanges.clear();
        if (!this.isRunning()) {
            return;
        }
        int listCount = this.mMovesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<MoveInfo> moves = this.mMovesList.get(i);
            count = moves.size();
            for (j = count - 1; j >= 0; --j) {
                MoveInfo moveInfo = moves.get(j);
                RecyclerView.ViewHolder item2 = moveInfo.holder;
                View view = item2.itemView;
                view.setTranslationY(0.0f);
                view.setTranslationX(0.0f);
                this.dispatchMoveFinished(moveInfo.holder);
                moves.remove(j);
                if (!moves.isEmpty()) continue;
                this.mMovesList.remove(moves);
            }
        }
        listCount = this.mAdditionsList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<RecyclerView.ViewHolder> additions = this.mAdditionsList.get(i);
            count = additions.size();
            for (j = count - 1; j >= 0; --j) {
                RecyclerView.ViewHolder item3 = additions.get(j);
                View view = item3.itemView;
                view.setAlpha(1.0f);
                this.dispatchAddFinished(item3);
                if (j < additions.size()) {
                    additions.remove(j);
                }
                if (!additions.isEmpty()) continue;
                this.mAdditionsList.remove(additions);
            }
        }
        listCount = this.mChangesList.size();
        for (i = listCount - 1; i >= 0; --i) {
            ArrayList<ChangeInfo> changes = this.mChangesList.get(i);
            count = changes.size();
            for (j = count - 1; j >= 0; --j) {
                this.endChangeAnimationIfNecessary(changes.get(j));
                if (!changes.isEmpty()) continue;
                this.mChangesList.remove(changes);
            }
        }
        this.cancelAll(this.mRemoveAnimations);
        this.cancelAll(this.mMoveAnimations);
        this.cancelAll(this.mAddAnimations);
        this.cancelAll(this.mChangeAnimations);
        this.dispatchAnimationsFinished();
    }

    private void cancelAll(List<RecyclerView.ViewHolder> viewHolders) {
        for (int i = viewHolders.size() - 1; i >= 0; --i) {
            ViewCompat.animate((View)viewHolders.get((int)i).itemView).cancel();
        }
    }

    private static void clear(View v) {
        v.setAlpha(1.0f);
        v.setScaleY(1.0f);
        v.setScaleX(1.0f);
        v.setTranslationY(0.0f);
        v.setTranslationX(0.0f);
        v.setRotation(0.0f);
        v.setRotationY(0.0f);
        v.setRotationX(0.0f);
        v.setPivotY((float)(v.getMeasuredHeight() / 2));
        v.setPivotX((float)(v.getMeasuredWidth() / 2));
        v.animate().setInterpolator(null).setStartDelay(0L);
    }

    public boolean canReuseUpdatedViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull List<Object> payloads) {
        return !payloads.isEmpty() || super.canReuseUpdatedViewHolder(viewHolder, payloads);
    }

    protected class DefaultRemoveVpaListener
    extends VpaListenerAdapter {
        RecyclerView.ViewHolder mViewHolder;

        public DefaultRemoveVpaListener(RecyclerView.ViewHolder holder) {
            this.mViewHolder = holder;
        }

        @Override
        public void onAnimationStart(View view) {
            FlexibleItemAnimator.this.dispatchRemoveStarting(this.mViewHolder);
        }

        @Override
        public void onAnimationCancel(View view) {
            FlexibleItemAnimator.clear(view);
        }

        @Override
        public void onAnimationEnd(View view) {
            FlexibleItemAnimator.clear(view);
            FlexibleItemAnimator.this.dispatchRemoveFinished(this.mViewHolder);
            FlexibleItemAnimator.this.mRemoveAnimations.remove(this.mViewHolder);
            FlexibleItemAnimator.this.dispatchFinishedWhenDone();
        }
    }

    protected class DefaultAddVpaListener
    extends VpaListenerAdapter {
        RecyclerView.ViewHolder mViewHolder;

        public DefaultAddVpaListener(RecyclerView.ViewHolder holder) {
            this.mViewHolder = holder;
        }

        @Override
        public void onAnimationStart(View view) {
            FlexibleItemAnimator.this.dispatchAddStarting(this.mViewHolder);
        }

        @Override
        public void onAnimationCancel(View view) {
            FlexibleItemAnimator.clear(view);
        }

        @Override
        public void onAnimationEnd(View view) {
            FlexibleItemAnimator.clear(view);
            FlexibleItemAnimator.this.dispatchAddFinished(this.mViewHolder);
            FlexibleItemAnimator.this.mAddAnimations.remove(this.mViewHolder);
            FlexibleItemAnimator.this.dispatchFinishedWhenDone();
        }
    }

    private static class VpaListenerAdapter
    implements ViewPropertyAnimatorListener {
        private VpaListenerAdapter() {
        }

        public void onAnimationStart(View view) {
        }

        public void onAnimationEnd(View view) {
        }

        public void onAnimationCancel(View view) {
        }
    }

    private static class ChangeInfo {
        RecyclerView.ViewHolder oldHolder;
        RecyclerView.ViewHolder newHolder;
        int fromX;
        int fromY;
        int toX;
        int toY;

        private ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder) {
            this.oldHolder = oldHolder;
            this.newHolder = newHolder;
        }

        private ChangeInfo(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
            this(oldHolder, newHolder);
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }

        public String toString() {
            return "ChangeInfo{oldHolder=" + this.oldHolder + ", newHolder=" + this.newHolder + ", fromX=" + this.fromX + ", fromY=" + this.fromY + ", toX=" + this.toX + ", toY=" + this.toY + '}';
        }
    }

    private static class MoveInfo {
        public RecyclerView.ViewHolder holder;
        int fromX;
        int fromY;
        int toX;
        int toY;

        private MoveInfo(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
            this.holder = holder;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }
}

