/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.livedata;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import java.util.List;

public abstract class FlexibleViewModel<Source, AdapterItem, Identifier>
extends ViewModel {
    protected LiveData<List<AdapterItem>> liveItems;
    protected MutableLiveData<Identifier> identifier = new MutableLiveData();

    public FlexibleViewModel() {
        this.liveItems = Transformations.switchMap(this.identifier, (Function)new Function<Identifier, LiveData<List<AdapterItem>>>(){

            public LiveData<List<AdapterItem>> apply(Identifier input) {
                return Transformations.map(FlexibleViewModel.this.getSource(input), (Function)new Function<Source, List<AdapterItem>>(){

                    public List<AdapterItem> apply(Source source) {
                        if (FlexibleViewModel.this.isSourceValid(source)) {
                            return FlexibleViewModel.this.map(source);
                        }
                        return (List)FlexibleViewModel.this.liveItems.getValue();
                    }
                });
            }
        });
    }

    @NonNull
    public LiveData<List<AdapterItem>> getLiveItems() {
        return this.liveItems;
    }

    public void loadSource(@NonNull Identifier identifier) {
        if (!identifier.equals(this.identifier.getValue())) {
            this.identifier.setValue(identifier);
        }
    }

    @NonNull
    protected abstract LiveData<Source> getSource(@NonNull Identifier var1);

    protected abstract boolean isSourceValid(@Nullable Source var1);

    @MainThread
    protected abstract List<AdapterItem> map(@NonNull Source var1);
}

