/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.livedata;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FlexibleItemProvider<Model, AdapterItem> {
    private final Factory<Model, AdapterItem> mFactory;

    private FlexibleItemProvider(Factory<Model, AdapterItem> factory) {
        this.mFactory = factory;
    }

    @MainThread
    public static <Model, Flexible> FlexibleItemProvider<Model, Flexible> with(@NonNull Factory<Model, Flexible> factory) {
        return new FlexibleItemProvider<Model, Flexible>(factory);
    }

    @NonNull
    @MainThread
    public List<AdapterItem> from(List<Model> source) {
        ArrayList<AdapterItem> items = new ArrayList<AdapterItem>();
        if (this.isSourceValid(source)) {
            for (Model model : source) {
                AdapterItem item = this.mFactory.create(model);
                if (item == null) continue;
                items.add(item);
            }
        }
        return items;
    }

    @NonNull
    @MainThread
    public List<AdapterItem> from(List<Model> source, Comparator<AdapterItem> comparator) {
        List<AdapterItem> items = this.from(source);
        if (comparator != null) {
            Collections.sort(items, comparator);
        }
        return items;
    }

    private boolean isSourceValid(List<?> source) {
        return source != null && !source.isEmpty();
    }

    public static interface Factory<Model, Flexible> {
        @Nullable
        public Flexible create(Model var1);
    }
}

