/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.livedata;

import androidx.annotation.NonNull;

public class FlexibleFactory {
    private FlexibleFactory() {
    }

    public static <T> T create(@NonNull Class<T> itemClass, Object ... constructorParams) {
        if (itemClass == null) {
            throw new IllegalArgumentException("Unknown model class " + itemClass);
        }
        try {
            if (constructorParams == null || constructorParams.length == 0) {
                return itemClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class[] classes = new Class[constructorParams.length];
            for (int i = 0; i < constructorParams.length; ++i) {
                classes[i] = constructorParams[i].getClass();
            }
            return itemClass.getConstructor(classes).newInstance(constructorParams);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage() + " " + itemClass.getCanonicalName() + ".<init>() has mismatching Constructor param");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

