/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.databinding;

import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.databinding.ObservableList;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.items.IFlexible;
import java.lang.ref.WeakReference;
import java.util.List;

public class BindingFlexibleAdapter<T extends IFlexible>
extends FlexibleAdapter<T> {
    private final WeakReferenceOnListChangedCallback<T> callback = new WeakReferenceOnListChangedCallback(this);

    public BindingFlexibleAdapter() {
        this(null);
    }

    public BindingFlexibleAdapter(@Nullable Object listeners) {
        this(listeners, false);
    }

    public BindingFlexibleAdapter(@Nullable Object listeners, boolean stableIds) {
        super(null, listeners, stableIds);
    }

    public void updateDataSet(List<T> items, boolean animate) {
        if (items instanceof ObservableList) {
            ((ObservableList)items).addOnListChangedCallback(this.callback);
        }
        super.updateDataSet(items, animate);
    }

    private static class WeakReferenceOnListChangedCallback<T extends IFlexible>
    extends ObservableList.OnListChangedCallback<ObservableList<T>> {
        final WeakReference<BindingFlexibleAdapter<T>> adapterRef;

        WeakReferenceOnListChangedCallback(BindingFlexibleAdapter<T> adapter) {
            this.adapterRef = new WeakReference<BindingFlexibleAdapter<BindingFlexibleAdapter<T>>>(adapter);
        }

        public void onChanged(ObservableList sender) {
            BindingFlexibleAdapter adapter = (BindingFlexibleAdapter)((Object)this.adapterRef.get());
            if (adapter == null) {
                return;
            }
            WeakReferenceOnListChangedCallback.ensureChangeOnMainThread();
            adapter.notifyDataSetChanged();
        }

        public void onItemRangeChanged(ObservableList sender, int positionStart, int itemCount) {
            BindingFlexibleAdapter adapter = (BindingFlexibleAdapter)((Object)this.adapterRef.get());
            if (adapter == null) {
                return;
            }
            WeakReferenceOnListChangedCallback.ensureChangeOnMainThread();
            adapter.notifyItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeInserted(ObservableList sender, int positionStart, int itemCount) {
            BindingFlexibleAdapter adapter = (BindingFlexibleAdapter)((Object)this.adapterRef.get());
            if (adapter == null) {
                return;
            }
            WeakReferenceOnListChangedCallback.ensureChangeOnMainThread();
            adapter.notifyItemRangeInserted(positionStart, itemCount);
        }

        public void onItemRangeMoved(ObservableList sender, int fromPosition, int toPosition, int itemCount) {
            BindingFlexibleAdapter adapter = (BindingFlexibleAdapter)((Object)this.adapterRef.get());
            if (adapter == null) {
                return;
            }
            WeakReferenceOnListChangedCallback.ensureChangeOnMainThread();
            for (int i = 0; i < itemCount; ++i) {
                adapter.notifyItemMoved(fromPosition + i, toPosition + i);
            }
        }

        public void onItemRangeRemoved(ObservableList sender, int positionStart, int itemCount) {
            BindingFlexibleAdapter adapter = (BindingFlexibleAdapter)((Object)this.adapterRef.get());
            if (adapter == null) {
                return;
            }
            WeakReferenceOnListChangedCallback.ensureChangeOnMainThread();
            adapter.notifyItemRangeRemoved(positionStart, itemCount);
        }

        private static void ensureChangeOnMainThread() {
            if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
                throw new IllegalStateException("You can only modify the ObservableList on the main thread.");
            }
        }
    }
}

