/*
 * Decompiled with CFR 0.152.
 */
package es.sdos.customlogger.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import es.sdos.customlogger.R;
import es.sdos.customlogger.log.CustomLog;
import es.sdos.customlogger.notification.NotificationType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Les/sdos/customlogger/notification/Notifications;", "", "()V", "PRIMARY_CHANNEL_ID", "", "canShowBackgroundNotifications", "", "canShowNotification", "getCanShowNotification", "()Z", "buildNotification", "Landroid/app/Notification;", "context", "Landroid/content/Context;", "builder", "Landroid/support/v4/app/NotificationCompat$Builder;", "type", "Les/sdos/customlogger/notification/NotificationType;", "showNotification", "", "contentTitle", "", "contentText", "pendingIntent", "Landroid/app/PendingIntent;", "notificationId", "", "customlogger_release"})
public final class Notifications {
    private static final String PRIMARY_CHANNEL_ID = "primary_notification_channel";
    private static final boolean canShowBackgroundNotifications;
    public static final Notifications INSTANCE;

    public final boolean getCanShowNotification() {
        return canShowBackgroundNotifications || CustomLog.Companion.getApplicationVisible();
    }

    public final void showNotification(@NotNull Context context, @NotNull CharSequence contentTitle, @NotNull CharSequence contentText, @Nullable PendingIntent pendingIntent, int notificationId, @NotNull NotificationType type) {
        NotificationCompat.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)contentTitle, (String)"contentTitle");
        Intrinsics.checkParameterIsNotNull((Object)contentText, (String)"contentText");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        if (!this.getCanShowNotification()) {
            return;
        }
        NotificationCompat.Builder builder2 = builder = new NotificationCompat.Builder(context, PRIMARY_CHANNEL_ID).setContentText(contentText).setContentTitle(contentTitle).setAutoCancel(true).setContentIntent(pendingIntent);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        Notification notification = this.buildNotification(context, builder2, type);
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        notificationManager.notify(notificationId, notification);
    }

    @NotNull
    public final Notification buildNotification(@NotNull Context context, @NotNull NotificationCompat.Builder builder, @NotNull NotificationType type) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        builder.setSmallIcon(R.drawable.ic_notification).setWhen(System.currentTimeMillis());
        if (Build.VERSION.SDK_INT >= 26) {
            Object object = context.getSystemService("notification");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
            }
            NotificationManager notificationManager = (NotificationManager)object;
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(type.name());
            if (notificationChannel == null) {
                String channelName = context.getString(type.getNameResId());
                notificationChannel = new NotificationChannel(type.name(), (CharSequence)channelName, type.getImportance());
                notificationManager.createNotificationChannel(notificationChannel);
            }
            builder.setChannelId(type.name());
        }
        Notification notification = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)notification, (String)"builder.build()");
        return notification;
    }

    private Notifications() {
    }

    static {
        boolean bl;
        Notifications notifications;
        INSTANCE = notifications = new Notifications();
        if (Build.VERSION.SDK_INT >= 26) {
            PackageManager packageManager = CustomLog.Companion.getApplication().getPackageManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)packageManager, (String)"CustomLog.application.packageManager");
            bl = !packageManager.isInstantApp();
        } else {
            bl = true;
        }
        canShowBackgroundNotifications = bl;
    }
}

