/*
 * Decompiled with CFR 0.152.
 */
package es.sdos.customlogger.log;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import es.sdos.customlogger.R;
import es.sdos.customlogger.common.LogConstantsKt;
import es.sdos.customlogger.common.LogExtensionsKt;
import es.sdos.customlogger.log.CustomLog;
import es.sdos.customlogger.log.LogType;
import es.sdos.customlogger.notification.NotificationType;
import es.sdos.customlogger.notification.Notifications;
import es.sdos.customlogger.util.CustomTimingLogger;
import es.sdos.customlogger.util.RequestStoragePermissionActivity;
import es.sdos.customlogger.util.VisibilityTrackerKt;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\u0004J\u001f\u0010\u000b\u001a\u00020\u0006\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\fH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J'\u0010\u0014\u001a\u00020\u0004\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001J1\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001a\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\u00020\u001d\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u001eJ/\u0010\u001c\u001a\u00020\u001d\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\f2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060 H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0004H\u0002\u00a8\u0006%"}, d2={"Les/sdos/customlogger/log/CustomLog;", "", "()V", "addSplitToTiming", "", "label", "", "createDirectoryIfNotExist", "directory", "Ljava/io/File;", "endTiming", "getHeaderLogByType", "T", "Les/sdos/customlogger/log/LogType;", "type", "(Les/sdos/customlogger/log/LogType;)Ljava/lang/String;", "getNullStringFromNull", "value", "startTiming", "tag", "writeData", "message", "(Les/sdos/customlogger/log/LogType;Ljava/lang/String;)V", "objectToBeLogged", "separator", "values", "", "(Ljava/lang/String;Les/sdos/customlogger/log/LogType;[Ljava/lang/Object;)V", "writeInfoIntoLogFile", "", "(Les/sdos/customlogger/log/LogType;Ljava/lang/String;)Z", "messageList", "", "(Les/sdos/customlogger/log/LogType;Ljava/util/List;)Z", "writePendingData", "Builder", "Companion", "customlogger_release"})
public final class CustomLog {
    @NotNull
    public static volatile Application application;
    private static volatile boolean applicationVisible;
    @NotNull
    private static volatile CustomLog instance;
    private static volatile boolean permissionNotificationDisplayed;
    private static CustomTimingLogger timingLogger;
    private static Thread.UncaughtExceptionHandler customExceptionHandler;
    private static long timeToWriteIntoLog;
    private static String mainContainerFolderName;
    private static String logFilesFolder;
    private static String fileName;
    private static int daysToCleanLog;
    private static Handler handler;
    private static LinkedHashMap<LogType, List<String>> typeWithInfoMap;
    public static final Companion Companion;

    public final void startTiming(@NotNull String tag, @NotNull String label) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            CustomTimingLogger customTimingLogger = timingLogger;
            if (customTimingLogger == null) break block0;
            customTimingLogger.reset(tag, label);
        }
    }

    public final void addSplitToTiming(@NotNull String label) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
            CustomTimingLogger customTimingLogger = timingLogger;
            if (customTimingLogger == null) break block0;
            customTimingLogger.addSplit(label);
        }
    }

    public final void endTiming() {
        CustomTimingLogger customTimingLogger = timingLogger;
        this.writeData((LogType)LogType.TIMING.INSTANCE, customTimingLogger != null ? customTimingLogger.dumpToLog() : null);
    }

    public final void writeData(@NotNull LogType type, @Nullable Object objectToBeLogged) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.writeData(type, String.valueOf(objectToBeLogged));
    }

    public final void writeData(@NotNull String separator, @NotNull LogType type, Object ... values) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        Object[] $receiver = objectArray = values;
        $receiver.toString();
        Object[] strings = objectArray;
        this.writeData(type, ArraysKt.joinToString$default((Object[])strings, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null));
    }

    public static /* synthetic */ void writeData$default(CustomLog customLog, String string2, LogType logType, Object[] objectArray, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = " - ";
        }
        customLog.writeData(string2, logType, objectArray);
    }

    public final <T extends LogType> void writeData(@NotNull T type, @Nullable String message) {
        List<String> list;
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        handler.removeCallbacksAndMessages(null);
        if (typeWithInfoMap.get(type) != null) {
            List<String> list2 = typeWithInfoMap.get(type);
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeWithInfoMap[type]!!");
            list = list2;
        } else {
            list = new ArrayList();
        }
        List<String> messageListByType = list;
        messageListByType.add(message);
        Map map = typeWithInfoMap;
        List<String> list3 = messageListByType;
        map.put(type, list3);
        handler.postDelayed(new Runnable(this, type){
            final /* synthetic */ CustomLog this$0;
            final /* synthetic */ LogType $type;

            public final void run() {
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
                    final /* synthetic */ writeData.1 this$0;

                    public final void uncaughtException(Thread t, Throwable e) {
                        block0: {
                            CustomLog.access$writeInfoIntoLogFile(this.this$0.this$0, this.this$0.$type, e.getMessage());
                            CustomLog.access$writePendingData(this.this$0.this$0);
                            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = CustomLog.access$getCustomExceptionHandler$cp();
                            if (uncaughtExceptionHandler == null) break block0;
                            uncaughtExceptionHandler.uncaughtException(t, e);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                CustomLog.access$writePendingData(this.this$0);
                Thread.setDefaultUncaughtExceptionHandler(CustomLog.access$getCustomExceptionHandler$cp());
            }
            {
                this.this$0 = customLog;
                this.$type = logType;
            }
        }, timeToWriteIntoLog);
    }

    private final void writePendingData() {
        try {
            Map $receiver$iv;
            Map map = $receiver$iv = (Map)typeWithInfoMap;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                this.writeInfoIntoLogFile((LogType)it.getKey(), (List)it.getValue());
            }
            typeWithInfoMap.clear();
        }
        catch (Exception e) {
            Log.e((String)CustomLog.class.getSimpleName(), (String)e.getMessage());
        }
    }

    private final <T extends LogType> boolean writeInfoIntoLogFile(T type, List<String> messageList) {
        boolean res = false;
        try {
            Iterable $receiver$iv = messageList;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                this.writeInfoIntoLogFile(type, it);
                Log.d((String)CustomLog.class.getSimpleName(), (String)this.getNullStringFromNull(it));
            }
            res = true;
        }
        catch (Exception e) {
            Log.e((String)CustomLog.class.getSimpleName(), (String)e.getMessage());
        }
        return res;
    }

    private final <T extends LogType> boolean writeInfoIntoLogFile(T type, String message) {
        boolean res = false;
        try {
            Date now = new Date();
            String appDirectoryPath = Environment.getExternalStorageDirectory().toString() + mainContainerFolderName;
            File appDirectory = new File(appDirectoryPath);
            File logDirectory = new File(appDirectoryPath + logFilesFolder);
            File logFile = new File(logDirectory, LogConstantsKt.getDATE_FORMAT_TO_NAMING_LOG_FILE().format(now) + fileName);
            this.createDirectoryIfNotExist(appDirectory);
            this.createDirectoryIfNotExist(logDirectory);
            FileWriter fileWriter = new FileWriter(logFile, true);
            String headerLog = this.getHeaderLogByType(type);
            CharSequence charSequence = headerLog;
            if (!(charSequence.length() == 0)) {
                Writer writer = fileWriter.append(headerLog);
                Intrinsics.checkExpressionValueIsNotNull((Object)writer, (String)"fileWriter.append(headerLog)");
                LogExtensionsKt.appendLineSeparator(writer, false);
            }
            LogExtensionsKt.appendLineSeparator(LogExtensionsKt.wrapperMessageWithDate(fileWriter, message, LogConstantsKt.getDATE_FORMAT_TO_TIME_INTO_LOG_FILE()), true);
            fileWriter.close();
            res = true;
            Log.d((String)CustomLog.class.getSimpleName(), (String)this.getNullStringFromNull(message));
        }
        catch (Exception e) {
            Log.e((String)CustomLog.class.getSimpleName(), (String)e.getMessage());
        }
        return res;
    }

    private final <T extends LogType> String getHeaderLogByType(T type) {
        return "/***** " + type.getName() + " *****/";
    }

    private final void createDirectoryIfNotExist(File directory) {
        if (!directory.exists()) {
            directory.mkdir();
        }
    }

    private final String getNullStringFromNull(Object value) {
        Object object = value;
        if (object == null || (object = object.toString()) == null) {
            object = "null";
        }
        return object;
    }

    static {
        Companion = new Companion(null);
        instance = new CustomLog();
        timeToWriteIntoLog = LogConstantsKt.getDEFAULT_TIME_TO_WRITE_INTO_LOG();
        mainContainerFolderName = LogConstantsKt.getDEFAULT_MAIN_CONTAINER_FOLDER_NAME();
        logFilesFolder = LogConstantsKt.getDEFAULT_LOG_FILES_FOLDER();
        fileName = LogConstantsKt.getDEFAULT_FILE_NAME();
        daysToCleanLog = LogConstantsKt.getDEFAULT_DAYS_TO_CLEAN_LOG();
        handler = new Handler();
        typeWithInfoMap = new LinkedHashMap();
    }

    public static final /* synthetic */ boolean access$writeInfoIntoLogFile(CustomLog $this, @NotNull LogType type, @Nullable String message) {
        return $this.writeInfoIntoLogFile(type, message);
    }

    public static final /* synthetic */ void access$writePendingData(CustomLog $this) {
        $this.writePendingData();
    }

    @Nullable
    public static final /* synthetic */ Thread.UncaughtExceptionHandler access$getCustomExceptionHandler$cp() {
        return customExceptionHandler;
    }

    @NotNull
    public static final /* synthetic */ Application access$getApplication$cp() {
        Application application = CustomLog.application;
        if (application == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"application");
        }
        return application;
    }

    @Nullable
    public static final /* synthetic */ CustomTimingLogger access$getTimingLogger$cp() {
        return timingLogger;
    }

    @NotNull
    public static final /* synthetic */ String access$getFileName$cp() {
        return fileName;
    }

    public static final /* synthetic */ long access$getTimeToWriteIntoLog$cp() {
        return timeToWriteIntoLog;
    }

    @NotNull
    public static final CustomLog getInstance() {
        Companion companion = Companion;
        return instance;
    }

    private static final void setInstance(CustomLog customLog) {
        Companion companion = Companion;
        instance = customLog;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\r\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000f\u0010\u000bR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0010@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Les/sdos/customlogger/log/CustomLog$Builder;", "", "()V", "value", "", "daysToCleanLog", "setDaysToCleanLog", "(I)V", "", "fileName", "setFileName", "(Ljava/lang/String;)V", "logFilesFolder", "setLogFilesFolder", "mainContainerFolderName", "setMainContainerFolderName", "", "timeToWriteIntoLog", "setTimeToWriteIntoLog", "(J)V", "build", "Les/sdos/customlogger/log/CustomLog;", "application", "Landroid/app/Application;", "withDaysToCleanLog", "withFileName", "withLogFilesFolder", "withMainContainerFolderName", "withTimeToWriteIntoLog", "customlogger_release"})
    public static final class Builder {
        private long timeToWriteIntoLog = LogConstantsKt.getDEFAULT_TIME_TO_WRITE_INTO_LOG();
        private String mainContainerFolderName = LogConstantsKt.getDEFAULT_MAIN_CONTAINER_FOLDER_NAME();
        private String logFilesFolder = LogConstantsKt.getDEFAULT_LOG_FILES_FOLDER();
        private String fileName = LogConstantsKt.getDEFAULT_FILE_NAME();
        private int daysToCleanLog = LogConstantsKt.getDEFAULT_DAYS_TO_CLEAN_LOG();

        private final void setTimeToWriteIntoLog(long value) {
            this.timeToWriteIntoLog = value <= 0L ? LogConstantsKt.getDEFAULT_TIME_TO_WRITE_INTO_LOG() : value;
        }

        private final void setMainContainerFolderName(String value) {
            this.mainContainerFolderName = Companion.formatFolder(value, LogConstantsKt.getDEFAULT_MAIN_CONTAINER_FOLDER_NAME());
        }

        private final void setLogFilesFolder(String value) {
            this.logFilesFolder = Companion.formatFolder(value, LogConstantsKt.getDEFAULT_MAIN_CONTAINER_FOLDER_NAME());
        }

        private final void setFileName(String value) {
            this.fileName = Companion.formatFileName(value, LogConstantsKt.getDEFAULT_FILE_NAME());
        }

        private final void setDaysToCleanLog(int value) {
            this.daysToCleanLog = value <= 0 ? LogConstantsKt.getDEFAULT_DAYS_TO_CLEAN_LOG() : value;
        }

        @NotNull
        public final Builder withMainContainerFolderName(@NotNull String mainContainerFolderName) {
            Intrinsics.checkParameterIsNotNull((Object)mainContainerFolderName, (String)"mainContainerFolderName");
            this.setMainContainerFolderName(mainContainerFolderName);
            return this;
        }

        @NotNull
        public final Builder withLogFilesFolder(@NotNull String logFilesFolder) {
            Intrinsics.checkParameterIsNotNull((Object)logFilesFolder, (String)"logFilesFolder");
            this.setLogFilesFolder(logFilesFolder);
            return this;
        }

        @NotNull
        public final Builder withFileName(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            this.setFileName(fileName);
            return this;
        }

        @NotNull
        public final Builder withDaysToCleanLog(int daysToCleanLog) {
            this.setDaysToCleanLog(daysToCleanLog);
            return this;
        }

        @NotNull
        public final Builder withTimeToWriteIntoLog(long timeToWriteIntoLog) {
            this.setTimeToWriteIntoLog(timeToWriteIntoLog);
            return this;
        }

        @NotNull
        public final CustomLog build(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            return Companion.init(application, this.mainContainerFolderName, this.logFilesFolder, this.fileName, this.daysToCleanLog, this.timeToWriteIntoLog);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010+\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150.H\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u0015H\u0002J\u001a\u00101\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u00010\u00152\u0006\u00103\u001a\u00020\u0015H\u0002J\u001a\u00104\u001a\u00020\u00152\b\u00102\u001a\u0004\u0018\u00010\u00152\u0006\u00103\u001a\u00020\u0015H\u0002JB\u00105\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\u00152\b\b\u0002\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\"\u001a\u00020#H\u0002J\b\u00106\u001a\u00020,H\u0002J\u0010\u00107\u001a\u00020,2\u0006\u00108\u001a\u000209H\u0002J0\u0010:\u001a\u00020,2\b\b\u0002\u0010 \u001a\u00020\u00152\b\b\u0002\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\"\u001a\u00020#H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00188\u0006@BX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010&\u001a.\u0012\u0004\u0012\u00020(\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150)0'j\u0016\u0012\u0004\u0012\u00020(\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150)`*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Les/sdos/customlogger/log/CustomLog$Companion;", "", "()V", "application", "Landroid/app/Application;", "getApplication", "()Landroid/app/Application;", "setApplication", "(Landroid/app/Application;)V", "<set-?>", "", "applicationVisible", "getApplicationVisible", "()Z", "setApplicationVisible", "(Z)V", "customExceptionHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "daysToCleanLog", "", "fileName", "", "handler", "Landroid/os/Handler;", "Les/sdos/customlogger/log/CustomLog;", "instance", "instance$annotations", "getInstance", "()Les/sdos/customlogger/log/CustomLog;", "setInstance", "(Les/sdos/customlogger/log/CustomLog;)V", "logFilesFolder", "mainContainerFolderName", "permissionNotificationDisplayed", "timeToWriteIntoLog", "", "timingLogger", "Les/sdos/customlogger/util/CustomTimingLogger;", "typeWithInfoMap", "Ljava/util/LinkedHashMap;", "Les/sdos/customlogger/log/LogType;", "", "Lkotlin/collections/LinkedHashMap;", "deleteLogFileIfIsNeeded", "", "filteredFiles", "Ljava/util/ArrayList;", "deleteNotNeededFiles", "nameOfFile", "formatFileName", "name", "default", "formatFolder", "init", "needResetLog", "requestWritePermissionNotification", "context", "Landroid/content/Context;", "setUpLocationParams", "customlogger_release"})
    public static final class Companion {
        @NotNull
        public final Application getApplication() {
            return CustomLog.access$getApplication$cp();
        }

        public final void setApplication(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"<set-?>");
            CustomLog.application = application;
        }

        public final boolean getApplicationVisible() {
            return applicationVisible;
        }

        private final void setApplicationVisible(boolean bl) {
            applicationVisible = bl;
        }

        @JvmStatic
        public static /* synthetic */ void instance$annotations() {
        }

        @NotNull
        public final CustomLog getInstance() {
            return instance;
        }

        private final void setInstance(CustomLog customLog) {
            instance = customLog;
        }

        private final CustomLog init(Application application, String mainContainerFolderName, String logFilesFolder, String fileName, int daysToCleanLog, long timeToWriteIntoLog) {
            customExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            timingLogger = new CustomTimingLogger(null, null);
            daysToCleanLog = daysToCleanLog;
            this.setUpLocationParams(mainContainerFolderName, logFilesFolder, fileName, timeToWriteIntoLog);
            if (!LogExtensionsKt.hasExternalStoragePermission((Context)application)) {
                Companion.setApplication(application);
                VisibilityTrackerKt.registerVisibilityListener(Companion.getApplication(), (Function1<? super Boolean, Unit>)((Function1)init.1.INSTANCE));
                Log.e((String)CustomLog.class.getSimpleName(), (String)"Storage permission not granted");
                Context context = application.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
                this.requestWritePermissionNotification(context);
            } else {
                this.needResetLog();
            }
            return new CustomLog();
        }

        static /* synthetic */ CustomLog init$default(Companion companion, Application application, String string, String string2, String string3, int n, long l, int n2, Object object) {
            if ((n2 & 2) != 0) {
                string = LogConstantsKt.getDEFAULT_MAIN_CONTAINER_FOLDER_NAME();
            }
            if ((n2 & 4) != 0) {
                string2 = LogConstantsKt.getDEFAULT_LOG_FILES_FOLDER();
            }
            if ((n2 & 8) != 0) {
                string3 = LogConstantsKt.getDEFAULT_FILE_NAME();
            }
            if ((n2 & 0x10) != 0) {
                n = LogConstantsKt.getDEFAULT_DAYS_TO_CLEAN_LOG();
            }
            if ((n2 & 0x20) != 0) {
                l = LogConstantsKt.getDEFAULT_TIME_TO_WRITE_INTO_LOG();
            }
            return companion.init(application, string, string2, string3, n, l);
        }

        private final void needResetLog() {
            StringBuilder stringBuilder = new StringBuilder();
            File file = Environment.getExternalStorageDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
            String pathToFile = stringBuilder.append(file.getPath()).append(mainContainerFolderName).append(logFilesFolder).toString();
            File file2 = new File(pathToFile);
            if (file2.list() == null) {
                return;
            }
            String[] stringArray = file2.list();
            ArrayList filesNameList = new ArrayList(Arrays.asList(Arrays.copyOf(stringArray, stringArray.length)));
            CollectionsKt.sort((List)filesNameList);
            ArrayList<String> filteredFiles = new ArrayList<String>();
            Iterator iterator = filesNameList.iterator();
            while (iterator.hasNext()) {
                String fileName;
                String string = fileName = (String)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)fileName, (boolean)false, (int)2, null)) continue;
                filteredFiles.add(fileName);
            }
            this.deleteLogFileIfIsNeeded(daysToCleanLog, filteredFiles);
        }

        /*
         * WARNING - void declaration
         */
        private final void deleteLogFileIfIsNeeded(int daysToCleanLog, ArrayList<String> filteredFiles) {
            if (!filteredFiles.isEmpty()) {
                int n = 0;
                int n2 = ((Collection)filteredFiles).size();
                while (n < n2) {
                    void i;
                    Intrinsics.checkExpressionValueIsNotNull((Object)filteredFiles.get((int)i), (String)"filteredFiles[i]");
                    try {
                        Calendar currentDate;
                        String candidateFileToDelete;
                        String string = candidateFileToDelete;
                        int n3 = 2;
                        int n4 = 4;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n3, n4);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        int day = Integer.parseInt(string3);
                        String string4 = candidateFileToDelete;
                        n4 = 0;
                        int n5 = 2;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.substring(n4, n5);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        int month = Integer.parseInt(string6);
                        Calendar oldFileCalendar = Calendar.getInstance();
                        oldFileCalendar.set(2, month - 1);
                        oldFileCalendar.set(5, day);
                        Calendar calendar = currentDate = Calendar.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"currentDate");
                        long l = calendar.getTimeInMillis();
                        Calendar calendar2 = oldFileCalendar;
                        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"oldFileCalendar");
                        long different = l - calendar2.getTimeInMillis();
                        long secondsInMilli = 1000L;
                        long minutesInMilli = secondsInMilli * (long)60;
                        long hoursInMilli = minutesInMilli * (long)60;
                        long daysInMilli = hoursInMilli * (long)24;
                        long numOfDays = Math.abs(different / daysInMilli);
                        long l2 = daysToCleanLog;
                        if (1L <= l2 && numOfDays - 1L >= l2) {
                            this.deleteNotNeededFiles(candidateFileToDelete);
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)CustomLog.class.getSimpleName(), (String)e.getMessage());
                    }
                    ++i;
                }
            }
        }

        private final void deleteNotNeededFiles(String nameOfFile) {
            StringBuilder stringBuilder = new StringBuilder();
            File file = Environment.getExternalStorageDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
            String pathToFile = stringBuilder.append(file.getPath()).append(mainContainerFolderName).append(logFilesFolder).append(File.separator).append(nameOfFile).toString();
            File file2 = new File(pathToFile);
            if (file2.exists()) {
                file2.delete();
            }
        }

        private final void setUpLocationParams(String mainContainerFolderName, String logFilesFolder, String fileName, long timeToWriteIntoLog) {
            mainContainerFolderName = mainContainerFolderName;
            logFilesFolder = logFilesFolder;
            fileName = fileName;
            timeToWriteIntoLog = timeToWriteIntoLog;
        }

        static /* synthetic */ void setUpLocationParams$default(Companion companion, String string, String string2, String string3, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = LogConstantsKt.getDEFAULT_MAIN_CONTAINER_FOLDER_NAME();
            }
            if ((n & 2) != 0) {
                string2 = LogConstantsKt.getDEFAULT_LOG_FILES_FOLDER();
            }
            if ((n & 4) != 0) {
                string3 = LogConstantsKt.getDEFAULT_FILE_NAME();
            }
            if ((n & 8) != 0) {
                l = LogConstantsKt.getDEFAULT_TIME_TO_WRITE_INTO_LOG();
            }
            companion.setUpLocationParams(string, string2, string3, l);
        }

        private final String formatFolder(String name, String string) {
            return TextUtils.isEmpty((CharSequence)name) ? string : '/' + name;
        }

        private final String formatFileName(String name, String string) {
            return TextUtils.isEmpty((CharSequence)name) ? string : '_' + name + ".tra";
        }

        private final void requestWritePermissionNotification(Context context) {
            if (permissionNotificationDisplayed) {
                return;
            }
            permissionNotificationDisplayed = true;
            PendingIntent pendingIntent = RequestStoragePermissionActivity.Companion.createPendingIntent(context);
            String contentTitle = context.getString(R.string.customlog__permission_notification_title);
            String packageName = context.getPackageName();
            String contentText = context.getString(R.string.customlog__permission_notification_text, new Object[]{packageName});
            String string2 = contentTitle;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"contentTitle");
            CharSequence charSequence = string2;
            String string3 = contentText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"contentText");
            Notifications.INSTANCE.showNotification(context, charSequence, string3, pendingIntent, R.id.customlog__notification_write_permission, NotificationType.CUSTOMLOG_LOW);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ CustomLog access$getInstance$p(Companion $this) {
            return $this.getInstance();
        }

        public static final /* synthetic */ void access$setInstance$p(Companion $this, @NotNull CustomLog customLog) {
            $this.setInstance(customLog);
        }

        public static final /* synthetic */ boolean access$getApplicationVisible$p(Companion $this) {
            return $this.getApplicationVisible();
        }

        public static final /* synthetic */ void access$setApplicationVisible$p(Companion $this, boolean bl) {
            $this.setApplicationVisible(bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

