/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xadestri.client;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.SigningLTSException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.SecureXmlBuilder;
import es.gob.afirma.core.misc.http.UrlHttpManager;
import es.gob.afirma.core.misc.http.UrlHttpManagerFactory;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AOTriphaseException;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.signers.OptionalDataInterface;
import es.gob.afirma.core.signers.TriphaseData;
import es.gob.afirma.core.signers.TriphaseDataSigner;
import es.gob.afirma.core.signers.TriphaseUtil;
import es.gob.afirma.core.util.tree.AOTreeModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AOXAdESTriPhaseSigner
implements AOSigner,
OptionalDataInterface {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String DSIGNNS = "http://www.w3.org/2000/09/xmldsig#";
    protected static final String XML_SIGNATURE_PREFIX = "ds";
    public static final String SIGNATURE_TAG = "Signature";
    protected static final String SIGNATURE_NODE_NAME = "ds:Signature";
    private static final String PROPERTY_NAME_SIGN_SERVER_URL = "serverUrl";
    private static final String PROPERTY_VALIDATE_PKCS1 = "validatePkcs1";
    private static final String OPERATION_PRESIGN = "pre";
    private static final String OPERATION_POSTSIGN = "post";
    private static final String CRYPTO_OPERATION_SIGN = "sign";
    private static final String CRYPTO_OPERATION_COSIGN = "cosign";
    private static final String CRYPTO_OPERATION_COUNTERSIGN = "countersign";
    private static final String PARAMETER_NAME_OPERATION = "op";
    private static final String PARAMETER_NAME_CRYPTO_OPERATION = "cop";
    private static final String HTTP_CGI = "?";
    private static final String HTTP_EQUALS = "=";
    private static final String HTTP_AND = "&";
    private static final String PARAMETER_NAME_DOCID = "doc";
    private static final String PARAMETER_NAME_ALGORITHM = "algo";
    private static final String PARAMETER_NAME_FORMAT = "format";
    private static final String PARAMETER_NAME_CERT = "cert";
    private static final String PARAMETER_NAME_EXTRA_PARAM = "params";
    private static final String PARAMETER_NAME_SESSION_DATA = "session";
    private static final String ERROR_PREFIX = "ERR-";
    private static final String CONFIG_NEEDED_ERROR_PREFIX = "ERR-21:";
    private static final String SUCCESS = "OK";
    private static final String COUNTERSIGN_TARGET_KEY = "target";
    public static final String COUNTERSIGN_TARGET_LEAFS = "leafs";
    public static final String COUNTERSIGN_TARGET_TREE = "tree";
    private final String signFormat;
    private static final String EXTRAPARAM_FORMAT = "format";
    private static final String USE_MANIFEST = "useManifest";

    protected AOXAdESTriPhaseSigner(String string) {
        this.signFormat = string;
    }

    public AOXAdESTriPhaseSigner() {
        this("XAdES");
    }

    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOXAdESTriPhaseSigner.triPhaseOperation(this.signFormat, CRYPTO_OPERATION_SIGN, byArray, string, privateKey, certificateArray, properties);
    }

    public final byte[] getData(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return AOXAdESTriPhaseSigner.triPhaseOperation(this.signFormat, CRYPTO_OPERATION_COSIGN, byArray2, string, privateKey, certificateArray, properties);
    }

    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        return this.cosign(null, byArray, string, privateKey, certificateArray, properties);
    }

    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        if (counterSignTarget == null) {
            throw new IllegalArgumentException("No se han indicado los nodos objetivo de la contrafirma");
        }
        if (counterSignTarget != CounterSignTarget.TREE && counterSignTarget != CounterSignTarget.LEAFS) {
            throw new IllegalArgumentException("El objetivo indicado para la contrafirma no esta soportado: " + counterSignTarget);
        }
        Properties properties2 = properties != null ? properties : new Properties();
        properties2.setProperty(COUNTERSIGN_TARGET_KEY, counterSignTarget.toString());
        return AOXAdESTriPhaseSigner.triPhaseOperation(this.signFormat, CRYPTO_OPERATION_COUNTERSIGN, byArray, string, privateKey, certificateArray, properties2);
    }

    public final AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    public boolean isSign(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        try {
            Element element = SecureXmlBuilder.getSecureDocumentBuilder().parse(new ByteArrayInputStream(byArray)).getDocumentElement();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (element.getNodeName().equals(SIGNATURE_NODE_NAME)) {
                arrayList.add(element);
            }
            NodeList nodeList = element.getElementsByTagNameNS(DSIGNNS, SIGNATURE_TAG);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            if (arrayList.size() == 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null) {
            LOGGER.warning("Se han introducido datos nulos para su comprobacion");
            return false;
        }
        return true;
    }

    public String getSignedName(String string, String string2) {
        return string + (string2 != null ? string2 : "") + ".xsig";
    }

    public AOSignInfo getSignInfo(byte[] byArray) {
        throw new UnsupportedOperationException("No se soporta en firma trifasica");
    }

    protected static byte[] triPhaseOperation(String string, String string2, byte[] byArray, String string3, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray2;
        CharSequence charSequence;
        byte[] byArray3;
        String string4;
        CharSequence charSequence2;
        String string5;
        URL uRL;
        if (properties == null) {
            throw new IllegalArgumentException("Se necesitan parametros adicionales");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Es necesario proporcionar la clave privada de firma");
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Es necesario proporcionar el certificado de firma");
        }
        if (byArray == null && AOXAdESTriPhaseSigner.isDataMandatory(string2, properties)) {
            throw new IllegalArgumentException("No se ha proporcionado el identificador de documento a firmar");
        }
        try {
            uRL = new URL(properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("No se ha proporcionado una URL valida para el servidor de firma: " + properties.getProperty(PROPERTY_NAME_SIGN_SERVER_URL), exception);
        }
        Properties properties2 = (Properties)properties.clone();
        properties2.remove(PROPERTY_VALIDATE_PKCS1);
        properties2.remove(PROPERTY_NAME_SIGN_SERVER_URL);
        String string6 = byArray != null ? Base64.encode((byte[])byArray, (boolean)true) : null;
        UrlHttpManager urlHttpManager = UrlHttpManagerFactory.getInstalledManager();
        try {
            string5 = TriphaseUtil.prepareCertChainParam((Certificate[])certificateArray, (Properties)properties2);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AOException("Error decodificando la cadena de certificados: " + certificateEncodingException, (Throwable)certificateEncodingException);
        }
        try {
            charSequence2 = new StringBuffer();
            ((StringBuffer)charSequence2).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_PRESIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append("format").append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string3).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(string5);
            if (string6 != null) {
                ((StringBuffer)charSequence2).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string6);
            }
            if (properties2.size() > 0) {
                ((StringBuffer)charSequence2).append(HTTP_AND).append(PARAMETER_NAME_EXTRA_PARAM).append(HTTP_EQUALS).append(AOUtil.properties2Base64((Properties)properties2));
            }
            string4 = ((StringBuffer)charSequence2).toString();
            LOGGER.info("Se llamara por POST a la siguiente URL:\n" + string4);
            byArray3 = urlHttpManager.readUrl(string4, UrlHttpMethod.POST);
            ((StringBuffer)charSequence2).setLength(0);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de prefirma al servidor: " + iOException, (Throwable)iOException);
        }
        if (byArray3.length > 8) {
            charSequence2 = new String(Arrays.copyOf(byArray3, 8), StandardCharsets.UTF_8);
            if (((String)charSequence2).startsWith(ERROR_PREFIX)) {
                string4 = new String(byArray3, StandardCharsets.UTF_8);
                LOGGER.warning("Error durante la prefirma: " + string4);
                throw AOXAdESTriPhaseSigner.buildInternalException(string4, properties);
            }
        } else {
            charSequence2 = new String(byArray3, StandardCharsets.UTF_8);
            LOGGER.warning("No se han obtenido datos de la prefirma: " + (String)charSequence2);
            throw new AOException("No se han obtenido datos de la prefirma");
        }
        try {
            charSequence2 = TriphaseData.parser((byte[])Base64.decode((byte[])byArray3, (int)0, (int)byArray3.length, (boolean)true));
        }
        catch (Exception exception) {
            LOGGER.severe("Error al analizar la prefirma enviada por el servidor: " + exception);
            throw new AOException("Error al analizar la prefirma enviada por el servidor: " + exception, (Throwable)exception);
        }
        string4 = Base64.encode((byte[])TriphaseDataSigner.doSign((AOPkcs1Signer)new AOPkcs1Signer(), (String)string3, (PrivateKey)privateKey, (Certificate[])certificateArray, (TriphaseData)charSequence2, (Properties)properties).toString().getBytes(), (boolean)true);
        try {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(uRL).append(HTTP_CGI).append(PARAMETER_NAME_OPERATION).append(HTTP_EQUALS).append(OPERATION_POSTSIGN).append(HTTP_AND).append(PARAMETER_NAME_CRYPTO_OPERATION).append(HTTP_EQUALS).append(string2).append(HTTP_AND).append("format").append(HTTP_EQUALS).append(string).append(HTTP_AND).append(PARAMETER_NAME_ALGORITHM).append(HTTP_EQUALS).append(string3).append(HTTP_AND).append(PARAMETER_NAME_CERT).append(HTTP_EQUALS).append(string5).append(HTTP_AND).append(PARAMETER_NAME_SESSION_DATA).append(HTTP_EQUALS).append(string4);
            if (string6 != null) {
                ((StringBuffer)charSequence).append(HTTP_AND).append(PARAMETER_NAME_DOCID).append(HTTP_EQUALS).append(string6);
            }
            if (properties2.size() > 0) {
                ((StringBuffer)charSequence).append(HTTP_AND).append(PARAMETER_NAME_EXTRA_PARAM).append(HTTP_EQUALS).append(AOUtil.properties2Base64((Properties)properties2));
            }
            byArray2 = urlHttpManager.readUrl(((StringBuffer)charSequence).toString(), UrlHttpMethod.POST);
        }
        catch (IOException iOException) {
            throw new AOException("Error en la llamada de postfirma al servidor: " + iOException, (Throwable)iOException);
        }
        if (byArray2.length > 8 && ((String)(charSequence = new String(Arrays.copyOf(byArray2, 8), StandardCharsets.UTF_8))).startsWith(CONFIG_NEEDED_ERROR_PREFIX)) {
            String string7 = new String(byArray2, StandardCharsets.UTF_8);
            LOGGER.warning("Error durante la postfirma: " + string7);
            throw AOXAdESTriPhaseSigner.buildInternalException(string7, properties);
        }
        charSequence = new String(byArray2).trim();
        if (!((String)charSequence).startsWith(SUCCESS)) {
            throw new AOException("La firma trifasica no ha finalizado correctamente: " + new String(byArray2));
        }
        try {
            return Base64.decode((String)((String)charSequence).substring("OK NEWID=".length()), (boolean)true);
        }
        catch (IOException iOException) {
            LOGGER.warning("El resultado de NEWID del servidor no estaba en Base64: " + iOException);
            throw new AOException("El resultado devuelto por el servidor no es correcto: " + iOException, (Throwable)iOException);
        }
    }

    private static AOException buildInternalException(String string, Properties properties) {
        String string2;
        int n;
        AOException aOException = null;
        int n2 = string.indexOf(":");
        if (string.startsWith(CONFIG_NEEDED_ERROR_PREFIX)) {
            n = string.indexOf(":", n2 + 1);
            string2 = string.substring(n2 + 1, n);
            String string3 = string.substring(n + 1);
            if ("signingLts".equals(string2)) {
                aOException = new SigningLTSException(string3);
            } else if ("signingLtsPossible".equals(string2)) {
                aOException = new SigningLTSException(string3, true);
            }
        }
        if (aOException == null) {
            n = string.indexOf(":", n2 + 1);
            if (n > 0) {
                string2 = string.substring(n + 1).trim();
                aOException = AOTriphaseException.parseException((String)string2);
            } else {
                aOException = new AOException(string);
            }
        }
        return aOException;
    }

    public boolean needData(String string, Properties properties) {
        return AOXAdESTriPhaseSigner.isDataMandatory(string, properties);
    }

    private static boolean isDataMandatory(String string, Properties properties) {
        return !CRYPTO_OPERATION_SIGN.equalsIgnoreCase(string) || properties == null || !"XAdES Externally Detached".equals(properties.getProperty("format")) && !Boolean.parseBoolean(properties.getProperty(USE_MANIFEST));
    }
}

