/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.cms.CmsUtil;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1UTCTime;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERPrintableString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.TBSCertificate;

final class GenSignedData {
    private ASN1Set signedAttr2;

    GenSignedData() {
    }

    byte[] generateSignedData(P7ContentSignerParameters p7ContentSignerParameters, boolean bl, boolean bl2, String string, PrivateKey privateKey, Certificate[] aSN1EncodableVector, Map<String, byte[]> map, Map<String, byte[]> map2, byte[] byArray) throws NoSuchAlgorithmException, CertificateException, IOException, AOException {
        AlgorithmIdentifier algorithmIdentifier;
        ASN1EncodableVector aSN1EncodableVector22;
        ArrayList<org.spongycastle.asn1.x509.Certificate> arrayList;
        if (p7ContentSignerParameters == null) {
            throw new IllegalArgumentException("Los parametros no pueden ser nulos");
        }
        ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
        String string2 = p7ContentSignerParameters.getSignatureAlgorithm();
        String string3 = AOSignConstants.getDigestAlgorithmName((String)string2);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId((String)AOAlgorithmID.getOID((String)string3));
        aSN1EncodableVector3.add((ASN1Encodable)algorithmIdentifier2);
        byte[] byArray2 = p7ContentSignerParameters.getContent();
        ContentInfo contentInfo = CmsUtil.getContentInfo(byArray2, bl, string);
        ASN1Set aSN1Set = null;
        if (((Certificate[])aSN1EncodableVector).length != 0) {
            arrayList = new ArrayList<org.spongycastle.asn1.x509.Certificate>();
            for (ASN1EncodableVector aSN1EncodableVector22 : aSN1EncodableVector) {
                arrayList.add(org.spongycastle.asn1.x509.Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])aSN1EncodableVector22.getEncoded())));
            }
            aSN1Set = SigUtils.createBerSetFromList(arrayList);
        }
        arrayList = null;
        ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
        TBSCertificate tBSCertificate = TBSCertificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])((X509Certificate)aSN1EncodableVector[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance((Object)tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        aSN1EncodableVector22 = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set2 = this.generateSignedInfo(string3, byArray2, string, bl2, map, byArray);
        ASN1Set aSN1Set3 = GenSignedData.generateUnsignedInfo(map2);
        try {
            algorithmIdentifier = SigUtils.makeAlgId((String)(string2.contains("withRSA") ? AOAlgorithmID.getOID((String)"RSA") : AOAlgorithmID.getOID((String)string2)));
        }
        catch (Exception exception) {
            throw new IOException("Error de codificacion: " + exception, exception);
        }
        ASN1OctetString aSN1OctetString = this.firma(string2, privateKey);
        aSN1EncodableVector4.add((ASN1Encodable)new SignerInfo((SignerIdentifier)aSN1EncodableVector22, algorithmIdentifier2, aSN1Set2, algorithmIdentifier, aSN1OctetString, aSN1Set3));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)new SignedData((ASN1Set)new DERSet(aSN1EncodableVector3), contentInfo, aSN1Set, arrayList, (ASN1Set)new DERSet(aSN1EncodableVector4))).getEncoded("DER");
    }

    private ASN1Set generateSignedInfo(String string, byte[] byArray, String string2, boolean bl, Map<String, byte[]> map, byte[] byArray2) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier(string2))));
        if (bl) {
            aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new ASN1UTCTime(new Date()))));
        }
        byte[] byArray3 = byArray2 == null || byArray2.length < 1 ? MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName((String)string)).digest(byArray) : byArray2;
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString((byte[])byArray3.clone()))));
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add((ASN1Encodable)new Attribute(new ASN1ObjectIdentifier(entry.getKey()), (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet((AttributeTable)new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet((AttributeTable)new AttributeTable(aSN1EncodableVector));
    }

    private static ASN1Set generateUnsignedInfo(Map<String, byte[]> map) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add((ASN1Encodable)new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(new String(entry.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet((AttributeTable)new AttributeTable(aSN1EncodableVector));
    }

    private ASN1OctetString firma(String string, PrivateKey privateKey) throws AOException {
        byte[] byArray;
        Signature signature;
        try {
            signature = Signature.getInstance(string);
        }
        catch (Exception exception) {
            throw new AOException("Error obteniendo la clase de firma para el algoritmo " + string, (Throwable)exception);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (Exception exception) {
            throw new AOException("Error al inicializar la firma con la clave privada", (Throwable)exception);
        }
        try {
            signature.update(this.signedAttr2.getEncoded("DER"));
        }
        catch (Exception exception) {
            throw new AOException("Error al configurar la informacion de firma o al obtener los atributos a firmar", (Throwable)exception);
        }
        try {
            byArray = signature.sign();
        }
        catch (Exception exception) {
            throw new AOException("Error durante el proceso de firma", (Throwable)exception);
        }
        return new DEROctetString(byArray);
    }
}

