/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.cms.CmsUtil;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.ContainsNoDataException;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.ASN1UTCTime;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERPrintableString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x500.style.RFC4519Style;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.TBSCertificate;

final class CoSigner {
    private ASN1Set signedAttr2;

    CoSigner() {
    }

    byte[] coSigner(P7ContentSignerParameters p7ContentSignerParameters, byte[] byArray, boolean bl, String string, PrivateKey privateKey, Certificate[] certificateArray, Map<String, byte[]> map, Map<String, byte[]> map2, byte[] byArray2) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString aSN1OctetString;
        Certificate certificate2;
        Object object;
        ASN1Sequence aSN1Sequence;
        try (Object object2 = new ASN1InputStream(byArray);){
            aSN1Sequence = (ASN1Sequence)object2.readObject();
        }
        object2 = aSN1Sequence.getObjects();
        object2.nextElement();
        var12_11 = (ASN1TaggedObject)object2.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)var12_11.getObject();
        SignedData signedData = SignedData.getInstance((Object)aSN1Sequence2);
        byte[] byArray3 = p7ContentSignerParameters.getContent();
        ContentInfo contentInfo = CmsUtil.getContentInfo(byArray3, bl, string);
        ASN1Set aSN1Set = null;
        ASN1Set aSN1Set2 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Set2.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        }
        if (certificateArray.length != 0) {
            object = new ArrayList();
            for (Certificate certificate2 : certificateArray) {
                object.add(org.spongycastle.asn1.x509.Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])certificate2.getEncoded())));
            }
            aSN1Set = SigUtils.fillRestCerts((List)object, (ASN1EncodableVector)aSN1EncodableVector);
        }
        object = p7ContentSignerParameters.getSignatureAlgorithm();
        String string2 = AOSignConstants.getDigestAlgorithmName((String)object);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId((String)AOAlgorithmID.getOID((String)string2));
        TBSCertificate tBSCertificate = TBSCertificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])((X509Certificate)certificateArray[0]).getTBSCertificate()));
        certificate2 = new IssuerAndSerialNumber(X500Name.getInstance((Object)tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier((IssuerAndSerialNumber)certificate2);
        ASN1Set aSN1Set3 = null;
        aSN1Set3 = byArray2 == null ? this.generateSignerInfo(string2, byArray3 != null ? byArray3 : p7ContentSignerParameters.getContent(), string, map) : this.generateSignerInfoFromHash((X509Certificate)certificateArray[0], byArray2, string, map);
        ASN1Set aSN1Set4 = CoSigner.generateUnsignerInfo(map2);
        AlgorithmIdentifier algorithmIdentifier2 = SigUtils.makeAlgId((String)(((String)object).contains("withRSA") ? AOAlgorithmID.getOID((String)"RSA") : AOAlgorithmID.getOID((String)object)));
        ASN1Set aSN1Set5 = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int aSN1OctetString2 = 0; aSN1OctetString2 < aSN1Set5.size(); ++aSN1OctetString2) {
            SignerInfo exception = SignerInfo.getInstance((Object)aSN1Set5.getObjectAt(aSN1OctetString2));
            aSN1EncodableVector2.add((ASN1Encodable)exception);
        }
        try {
            aSN1OctetString = CmsUtil.firma((String)object, privateKey, this.signedAttr2);
        }
        catch (Exception exception) {
            throw new IOException("Error al generar la firma: " + exception, exception);
        }
        aSN1EncodableVector2.add((ASN1Encodable)new SignerInfo(signerIdentifier, algorithmIdentifier, aSN1Set3, algorithmIdentifier2, aSN1OctetString, aSN1Set4));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)new SignedData(signedData.getDigestAlgorithms(), contentInfo, aSN1Set, null, (ASN1Set)new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    byte[] coSigner(String string, X509Certificate[] algorithmIdentifier, byte[] byArray, String string2, PrivateKey privateKey, Map<String, byte[]> map, Map<String, byte[]> map2, byte[] byArray2) throws IOException, NoSuchAlgorithmException, CertificateException, ContainsNoDataException {
        ASN1OctetString aSN1OctetString;
        AlgorithmIdentifier algorithmIdentifier22;
        Object object;
        ASN1Sequence aSN1Sequence;
        byte[] byArray3 = byArray2 != null ? (byte[])byArray2.clone() : null;
        try (Object object2 = new ASN1InputStream(byArray);){
            aSN1Sequence = (ASN1Sequence)object2.readObject();
        }
        object2 = aSN1Sequence.getObjects();
        object2.nextElement();
        var12_11 = (ASN1TaggedObject)object2.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)var12_11.getObject();
        SignedData signedData = SignedData.getInstance((Object)aSN1Sequence2);
        ContentInfo contentInfo = signedData.getEncapContentInfo();
        DEROctetString dEROctetString = (DEROctetString)contentInfo.getContent();
        byte[] byArray4 = null;
        if (dEROctetString != null) {
            byArray4 = AOUtil.getDataFromInputStream((InputStream)dEROctetString.getOctetStream());
        }
        ASN1Set aSN1Set = null;
        ASN1Set aSN1Set2 = signedData.getCertificates();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Set2.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        }
        if (((X509Certificate[])algorithmIdentifier).length != 0) {
            object = new ArrayList();
            for (AlgorithmIdentifier algorithmIdentifier22 : algorithmIdentifier) {
                object.add(org.spongycastle.asn1.x509.Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])algorithmIdentifier22.getEncoded())));
            }
            aSN1Set = SigUtils.fillRestCerts((List)object, (ASN1EncodableVector)aSN1EncodableVector);
        }
        object = AOSignConstants.getDigestAlgorithmName((String)string);
        AlgorithmIdentifier algorithmIdentifier3 = SigUtils.makeAlgId((String)AOAlgorithmID.getOID((String)object));
        TBSCertificate tBSCertificate = TBSCertificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])algorithmIdentifier[0].getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance((Object)tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        algorithmIdentifier22 = new SignerIdentifier(issuerAndSerialNumber);
        ASN1Set aSN1Set3 = null;
        ASN1Set aSN1Set4 = CoSigner.generateUnsignerInfo(map2);
        AlgorithmIdentifier algorithmIdentifier4 = SigUtils.makeAlgId((String)(string.contains("withRSA") ? AOAlgorithmID.getOID((String)"RSA") : AOAlgorithmID.getOID((String)string)));
        ASN1Set aSN1Set5 = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set5.size(); ++i) {
            SignerInfo signerInfo = SignerInfo.getInstance((Object)aSN1Set5.getObjectAt(i));
            AlgorithmIdentifier algorithmIdentifier5 = signerInfo.getDigestAlgorithm();
            if (algorithmIdentifier5.getAlgorithm().toString().equals(AOAlgorithmID.getOID((String)object))) {
                ASN1Set aSN1Set6 = signerInfo.getAuthenticatedAttributes();
                for (int j = 0; j < aSN1Set6.size(); ++j) {
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Set6.getObjectAt(j);
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence3.getObjectAt(0);
                    if (!CMSAttributes.messageDigest.getId().toString().equals(aSN1ObjectIdentifier.toString())) continue;
                    DERSet dERSet = (DERSet)aSN1Sequence3.getObjectAt(1);
                    DEROctetString dEROctetString2 = (DEROctetString)dERSet.getObjectAt(0);
                    byArray3 = dEROctetString2.getOctets();
                }
            }
            aSN1EncodableVector2.add((ASN1Encodable)signerInfo);
        }
        if (byArray4 != null) {
            aSN1Set3 = this.generateSignerInfo((String)object, byArray4, string2, map);
        } else if (byArray3 != null) {
            aSN1Set3 = this.generateSignerInfoFromHash((X509Certificate)algorithmIdentifier[0], byArray3, string2, map);
        } else {
            throw new ContainsNoDataException("No se puede crear la cofirma ya que no se han encontrado ni los datos firmados ni una huella digital compatible con el algoritmo de firma");
        }
        try {
            aSN1OctetString = CmsUtil.firma(string, privateKey, this.signedAttr2);
        }
        catch (Exception exception) {
            throw new IOException("Error al generar la firma: " + exception, exception);
        }
        aSN1EncodableVector2.add((ASN1Encodable)new SignerInfo((SignerIdentifier)algorithmIdentifier22, algorithmIdentifier3, aSN1Set3, algorithmIdentifier4, aSN1OctetString, aSN1Set4));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)new SignedData(signedData.getDigestAlgorithms(), contentInfo, aSN1Set, null, (ASN1Set)new DERSet(aSN1EncodableVector2))).getEncoded("DER");
    }

    private ASN1Set generateSignerInfo(String string, byte[] byArray, String string2, Map<String, byte[]> map) throws NoSuchAlgorithmException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier(string2))));
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new ASN1UTCTime(new Date()))));
        byte[] byArray2 = MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName((String)string)).digest(byArray);
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString((byte[])byArray2.clone()))));
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add((ASN1Encodable)new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet((AttributeTable)new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet((AttributeTable)new AttributeTable(aSN1EncodableVector));
    }

    private ASN1Set generateSignerInfoFromHash(X509Certificate x509Certificate, byte[] byArray, String string, Map<String, byte[]> map) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier(string))));
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new ASN1UTCTime(new Date()))));
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(byArray))));
        aSN1EncodableVector.add((ASN1Encodable)new Attribute(RFC4519Style.serialNumber, (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(x509Certificate.getSerialNumber().toString()))));
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add((ASN1Encodable)new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(new String(entry.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet((AttributeTable)new AttributeTable(aSN1EncodableVector));
        return SigUtils.getAttributeSet((AttributeTable)new AttributeTable(aSN1EncodableVector));
    }

    private static ASN1Set generateUnsignerInfo(Map<String, byte[]> map) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (map.size() != 0) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                aSN1EncodableVector.add((ASN1Encodable)new Attribute(new ASN1ObjectIdentifier(entry.getKey().toString()), (ASN1Set)new DERSet((ASN1Encodable)new DERPrintableString(new String(entry.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet((AttributeTable)new AttributeTable(aSN1EncodableVector));
    }
}

