/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.batch.client;

import es.gob.afirma.core.misc.protocol.ParameterException;
import es.gob.afirma.core.signers.TriphaseData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TriphaseDataParser {
    static final String DEFAULT_URL_ENCODING = StandardCharsets.UTF_8.name();

    public static TriphaseData parseFromJSON(byte[] byArray) {
        JSONObject jSONObject = new JSONObject(new JSONTokener((InputStream)new ByteArrayInputStream(byArray)));
        return TriphaseDataParser.parseFromJSON(jSONObject);
    }

    public static TriphaseData parseFromJSON(JSONObject jSONObject) {
        JSONArray jSONArray = null;
        if (jSONObject.has("signs")) {
            jSONArray = jSONObject.getJSONArray("signs");
        }
        String string = null;
        if (jSONObject.has("format")) {
            string = jSONObject.getString("format");
        }
        ArrayList<TriphaseData.TriSign> arrayList = new ArrayList<TriphaseData.TriSign>();
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                JSONArray jSONArray2 = jSONObject2.getJSONArray("signinfo");
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    String string2 = jSONArray2.getJSONObject(j).getString("id");
                    JSONObject jSONObject3 = jSONArray2.getJSONObject(j).getJSONObject("params");
                    arrayList.add(new TriphaseData.TriSign(TriphaseDataParser.parseParamsJSON(jSONObject3), string2));
                }
            }
        } else {
            JSONArray jSONArray3 = jSONObject.getJSONArray("signinfo");
            for (int i = 0; i < jSONArray3.length(); ++i) {
                String string3 = jSONArray3.getJSONObject(i).getString("id");
                JSONObject jSONObject4 = jSONArray3.getJSONObject(i).getJSONObject("params");
                arrayList.add(new TriphaseData.TriSign(TriphaseDataParser.parseParamsJSON(jSONObject4), string3));
            }
        }
        return new TriphaseData(arrayList, string);
    }

    private static Map<String, String> parseParamsJSON(JSONObject jSONObject) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        Map map = jSONObject.toMap();
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            concurrentHashMap.put(string, string2);
        }
        return concurrentHashMap;
    }

    public static String triphaseDataToJsonString(TriphaseData triphaseData) {
        JSONObject jSONObject;
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = triphaseData.getTriSigns().iterator();
        while (iterator.hasNext()) {
            jSONObject = new JSONObject();
            TriphaseData.TriSign triSign = (TriphaseData.TriSign)iterator.next();
            if (triSign.getId() != null) {
                jSONObject.put("id", (Object)triSign.getId());
            }
            JSONObject jSONObject2 = new JSONObject();
            for (String string : triSign.getDict().keySet()) {
                jSONObject2.put(string, (Object)triSign.getProperty(string));
            }
            jSONObject.put("params", (Object)jSONObject2);
            jSONArray.put((Object)jSONObject);
        }
        jSONObject = new JSONObject();
        if (triphaseData.getFormat() != null) {
            jSONObject.put("format", (Object)triphaseData.getFormat());
        }
        jSONObject.put("signinfo", (Object)jSONArray);
        return jSONObject.toString();
    }

    public static Map<String, String> parseParamsListJson(byte[] byArray) throws ParameterException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JSONObject jSONObject = new JSONObject(new JSONTokener((InputStream)new ByteArrayInputStream(byArray)));
        JSONArray jSONArray = jSONObject.getJSONArray("params");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (!jSONObject2.has("k") || !jSONObject2.has("v")) {
                throw new ParameterException("El JSON no tiene la forma esperada");
            }
            String string = jSONObject2.getString("k");
            String string2 = jSONObject2.getString("v");
            try {
                hashMap.put(string, URLDecoder.decode(string2, DEFAULT_URL_ENCODING));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getLogger("es.gob.afirma").warning("Codificacion no soportada para la URL (" + DEFAULT_URL_ENCODING + "): " + unsupportedEncodingException);
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }
}

