/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.batch.client;

import es.gob.afirma.core.signers.TriphaseData;
import es.gob.afirma.signers.batch.client.BatchDataResult;
import es.gob.afirma.signers.batch.client.PresignBatch;
import es.gob.afirma.signers.batch.client.TriphaseDataParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONPreSignBatchParser {
    private static final String JSELEM_TD = "td";
    private static final String JSELEM_RESULTS = "results";
    private static final String JSELEM_ID = "id";
    private static final String JSELEM_RESULT = "result";
    private static final String JSELEM_DESCRIPTION = "description";

    public static PresignBatch parseFromJSON(byte[] byArray) throws JSONException {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(new JSONTokener((InputStream)new ByteArrayInputStream(byArray)));
        }
        catch (JSONException jSONException) {
            throw new JSONException("El JSON de prefirma del lote no esta formado correctamente", (Throwable)jSONException);
        }
        TriphaseData triphaseData = null;
        if (jSONObject.has(JSELEM_TD)) {
            triphaseData = TriphaseDataParser.parseFromJSON(jSONObject.getJSONObject(JSELEM_TD));
        }
        List<BatchDataResult> list = null;
        if (jSONObject.has(JSELEM_RESULTS)) {
            list = JSONPreSignBatchParser.parseBatchDataResults(jSONObject.getJSONArray(JSELEM_RESULTS));
        }
        return new PresignBatch(triphaseData, list);
    }

    private static List<BatchDataResult> parseBatchDataResults(JSONArray jSONArray) {
        if (jSONArray.isEmpty()) {
            return null;
        }
        ArrayList<BatchDataResult> arrayList = new ArrayList<BatchDataResult>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            BatchDataResult.Result result;
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (!jSONObject.has(JSELEM_ID) || !jSONObject.has(JSELEM_RESULT)) {
                throw new JSONException("Se obtuvo un resultado parcial sin identificador o resultado");
            }
            try {
                result = BatchDataResult.Result.valueOf(jSONObject.getString(JSELEM_RESULT));
            }
            catch (Exception exception) {
                throw new JSONException("Estado de firma trifasica desconocido", (Throwable)exception);
            }
            String string = jSONObject.getString(JSELEM_ID);
            String string2 = null;
            if (jSONObject.has(JSELEM_DESCRIPTION)) {
                string2 = jSONObject.getString(JSELEM_DESCRIPTION);
            }
            arrayList.add(new BatchDataResult(string, result, string2));
        }
        return arrayList;
    }
}

