/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.batch.client;

import es.gob.afirma.signers.batch.client.BatchDataResult;
import es.gob.afirma.signers.batch.client.BatchInfo;
import es.gob.afirma.signers.batch.client.JSONBatchInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONBatchInfoParser {
    private static final String JSELEMENT_SIGNS = "signs";
    private static final String JSELEMENT_ID = "id";
    private static final String JSELEMENT_RESULT = "result";
    private static final String JSELEMENT_DESCRIPTION = "description";

    static BatchInfo parse(byte[] byArray) throws JSONException {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(new JSONTokener((InputStream)new ByteArrayInputStream(byArray)));
        }
        catch (JSONException jSONException) {
            throw new JSONException("El JSON del lote de firmas no esta formado correctamente", (Throwable)jSONException);
        }
        return new JSONBatchInfo(jSONObject);
    }

    static JSONObject buildEmptyResult() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(JSELEMENT_SIGNS, (Object)new JSONArray());
        return jSONObject;
    }

    static JSONObject buildResult(List<BatchDataResult> list) {
        JSONArray jSONArray = new JSONArray();
        for (BatchDataResult batchDataResult : list) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(JSELEMENT_ID, (Object)batchDataResult.getId());
            jSONObject.put(JSELEMENT_RESULT, (Object)batchDataResult.getResult().name());
            if (batchDataResult.getDescription() != null) {
                jSONObject.put(JSELEMENT_DESCRIPTION, (Object)batchDataResult.getDescription());
            }
            jSONArray.put((Object)jSONObject);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(JSELEMENT_SIGNS, (Object)jSONArray);
        return jSONObject;
    }
}

