/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.webprotege.maven;

import com.thoughtworks.qdox.JavaProjectBuilder;
import edu.stanford.webprotege.maven.AnnotatedPortletClass;
import edu.stanford.webprotege.maven.AnnotatedPortletClassExtractor;
import edu.stanford.webprotege.maven.AnnotatedPortletModuleClassExtractor;
import edu.stanford.webprotege.maven.MavenSourceWriter;
import edu.stanford.webprotege.maven.PortletModuleDescriptor;
import edu.stanford.webprotege.maven.PortletTypeDescriptor;
import edu.stanford.webprotege.maven.PortletTypeDescriptorBuilder;
import edu.stanford.webprotege.maven.WebProtegeCodeGeneratorVelocityImpl;
import edu.stanford.webprotege.maven.WebProtegeMavenPluginBuildProperties;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generatePortletFactory", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class WebProtegeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            for (Object compileSourceRoot : new ArrayList(this.project.getCompileSourceRoots())) {
                String sourceRoot = (String)compileSourceRoot;
                this.processCompileSourceRoot(sourceRoot);
            }
            WebProtegeMavenPluginBuildProperties props = WebProtegeMavenPluginBuildProperties.get(this.project, this.getLog());
            props.setTimestamp(System.currentTimeMillis());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    private void processCompileSourceRoot(String sourceRoot) throws IOException {
        try {
            JavaProjectBuilder builder = this.getProjectBuilder(sourceRoot);
            AnnotatedPortletClassExtractor extractor = new AnnotatedPortletClassExtractor(builder);
            Set<AnnotatedPortletClass> portletClasses = extractor.findAnnotatedPortletClasses();
            long lastBuildTimestamp = WebProtegeMavenPluginBuildProperties.get(this.project, this.getLog()).getTimestamp();
            HashSet modifiedDescriptors = new HashSet();
            Set<PortletTypeDescriptor> descriptors = portletClasses.stream().peek(d -> {
                if (this.isModifiedSinceLastBuild(lastBuildTimestamp, (AnnotatedPortletClass)d)) {
                    modifiedDescriptors.add(d);
                }
            }).map(c -> new PortletTypeDescriptorBuilder(c.getJavaClass(), c.getJavaAnnotation()).build()).collect(Collectors.toSet());
            this.logPortletDescriptors(descriptors);
            if (modifiedDescriptors.isEmpty()) {
                return;
            }
            AnnotatedPortletModuleClassExtractor moduleClassExtractor = new AnnotatedPortletModuleClassExtractor(builder);
            Set<PortletModuleDescriptor> moduleDescriptors = moduleClassExtractor.findAnnotatedProjectModulePlugins();
            WebProtegeCodeGeneratorVelocityImpl gen = new WebProtegeCodeGeneratorVelocityImpl(descriptors, moduleDescriptors, new MavenSourceWriter(this.project, this.getLog()));
            gen.generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private boolean isModifiedSinceLastBuild(long lastBuildTimestamp, AnnotatedPortletClass d) {
        try {
            boolean modified;
            URL sourceUrl = d.getJavaClass().getSource().getURL();
            File file = new File(sourceUrl.toURI());
            boolean bl = modified = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toInstant().getEpochSecond() > lastBuildTimestamp;
            if (!modified) {
                this.getLog().info((CharSequence)("[WebProtege Mojo] " + d + " has not been modified since last build"));
            }
            return modified;
        }
        catch (IOException | URISyntaxException e) {
            this.getLog().info((CharSequence)("[WebProtege Mojo] Could not get source file: " + e.getMessage()));
            return true;
        }
    }

    private JavaProjectBuilder getProjectBuilder(String sourceRoot) {
        JavaProjectBuilder builder = new JavaProjectBuilder();
        builder.setErrorHandler(e -> this.getLog().info((CharSequence)("[WebProtegeMojo] Couldn't parse file: " + e)));
        builder.addSourceTree(new File(sourceRoot));
        return builder;
    }

    private void logPortletDescriptors(Set<PortletTypeDescriptor> descriptors) {
        this.getLog().info((CharSequence)"[WebProtegeMojo]  Portlets:");
        for (PortletTypeDescriptor d : descriptors) {
            this.getLog().info((CharSequence)("[WebProtegeMojo]        " + d));
        }
    }
}

