/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.webprotege.maven;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class WebProtegeMavenPluginBuildProperties {
    private static final String BUILD_TIMESTAMP = "build.timestamp";
    private final Path buildDirectoryPath;
    private final Log log;

    private WebProtegeMavenPluginBuildProperties(Path buildDirectoryPath, Log log) {
        this.buildDirectoryPath = (Path)Preconditions.checkNotNull((Object)buildDirectoryPath);
        this.log = (Log)Preconditions.checkNotNull((Object)log);
    }

    protected static WebProtegeMavenPluginBuildProperties get(Path buildDirectoryPath, Log log) {
        return new WebProtegeMavenPluginBuildProperties(buildDirectoryPath, log);
    }

    public static WebProtegeMavenPluginBuildProperties get(MavenProject mavenProject, Log log) {
        String outputDir = mavenProject.getBuild().getDirectory();
        Path outputPath = Paths.get(outputDir, new String[0]);
        return WebProtegeMavenPluginBuildProperties.get(outputPath, log);
    }

    public long getTimestamp() {
        Path buildPropertiesPath = this.getBuildPropertiesPath();
        if (Files.exists(buildPropertiesPath, new LinkOption[0])) {
            long l;
            BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(buildPropertiesPath, new OpenOption[0]));
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                String buildTimestamp = properties.getProperty(BUILD_TIMESTAMP, "0");
                long timestamp = Long.parseLong(buildTimestamp);
                this.log.info((CharSequence)("Last build timestamp: " + timestamp));
                l = timestamp;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | NumberFormatException ex) {
                    this.log.error((Throwable)ex);
                    return 0L;
                }
            }
            inputStream.close();
            return l;
        }
        return 0L;
    }

    public void setTimestamp(long timestamp) {
        Path buildPropertiesPath = this.getBuildPropertiesPath();
        try {
            Files.createDirectories(buildPropertiesPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
            return;
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(buildPropertiesPath, new OpenOption[0]));){
            Properties properties = new Properties();
            properties.put(BUILD_TIMESTAMP, Long.toString(timestamp));
            properties.store(outputStream, "Generated by the webprotege-maven-plugin.  Do not edit.");
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }

    private Path getBuildPropertiesPath() {
        return this.buildDirectoryPath.resolve("webprotege-maven-plugin").resolve("build.properties");
    }
}

