/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.webprotege.maven;

import com.google.common.base.Preconditions;
import edu.stanford.webprotege.maven.PortletModuleDescriptor;
import edu.stanford.webprotege.maven.PortletTypeDescriptor;
import edu.stanford.webprotege.maven.SourceWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class WebProtegeCodeGeneratorVelocityImpl {
    private static final String PACKAGE_NAME = "edu.stanford.bmir.protege.web.client.portlet";
    private static final String DESCRIPTORS = "descriptors";
    private static final String MODULE_DESCRIPTORS = "moduleDescriptors";
    private static final String IMPORTED_PACKAGES = "importedPackages";
    private static final String CLASSPATH_RESOURCE_LOADER_CLASS = "classpath.resource.loader.class";
    private Set<PortletTypeDescriptor> descriptors;
    private Set<PortletModuleDescriptor> moduleDescriptors;
    private SourceWriter sourceWriter;

    public WebProtegeCodeGeneratorVelocityImpl(Set<PortletTypeDescriptor> descriptors, Set<PortletModuleDescriptor> moduleDescriptors, SourceWriter sourceWriter) {
        this.descriptors = new TreeSet<PortletTypeDescriptor>((Collection)Preconditions.checkNotNull(descriptors));
        this.moduleDescriptors = new HashSet<PortletModuleDescriptor>((Collection)Preconditions.checkNotNull(moduleDescriptors));
        this.sourceWriter = (SourceWriter)Preconditions.checkNotNull((Object)sourceWriter);
    }

    private Set<String> getImportedPackages() {
        return this.descriptors.stream().map(PortletTypeDescriptor::getPackageName).collect(Collectors.toSet());
    }

    public void generate() throws IOException {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath");
        engine.setProperty(CLASSPATH_RESOURCE_LOADER_CLASS, (Object)ClasspathResourceLoader.class.getName());
        engine.init();
        VelocityContext context = new VelocityContext();
        context.put(DESCRIPTORS, this.descriptors);
        context.put(MODULE_DESCRIPTORS, this.moduleDescriptors);
        context.put(IMPORTED_PACKAGES, this.getImportedPackages());
        context.put("date", (Object)new Date().toString());
        this.generateSource("PortletFactoryGenerated", PACKAGE_NAME, engine, context);
        this.generateSource("PortletModulesGenerated", PACKAGE_NAME, engine, context);
    }

    private void generateSource(String className, String packageName, VelocityEngine engine, VelocityContext context) throws IOException {
        Template template = engine.getTemplate(className + ".java.vm");
        this.writeSource(packageName, className, context, template);
    }

    private void writeSource(String packageName, String className, VelocityContext context, Template template) throws IOException {
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        String source = writer.toString();
        this.sourceWriter.writeSource(packageName, className, source);
    }
}

