/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.webprotege.maven;

import com.google.common.base.Preconditions;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import edu.stanford.webprotege.maven.PortletTypeDescriptor;

public class PortletTypeDescriptorBuilder {
    public static final String ID_PROPERTY_NAME = "id";
    public static final String TITLE_PROPERTY_NAME = "title";
    public static final String TOOLTIP_PROPERTY_NAME = "tooltip";
    private final JavaClass cls;
    private final JavaAnnotation anno;

    public PortletTypeDescriptorBuilder(JavaClass cls, JavaAnnotation anno) {
        this.cls = (JavaClass)Preconditions.checkNotNull((Object)cls);
        this.anno = (JavaAnnotation)Preconditions.checkNotNull((Object)anno);
    }

    public PortletTypeDescriptor build() {
        AnnotationValue id = this.anno.getProperty(ID_PROPERTY_NAME);
        AnnotationValue title = this.anno.getProperty(TITLE_PROPERTY_NAME);
        AnnotationValue tooltip = this.anno.getProperty(TOOLTIP_PROPERTY_NAME);
        return new PortletTypeDescriptor(this.cls.getCanonicalName(), this.cls.getName(), this.cls.getPackageName(), PortletTypeDescriptorBuilder.annotationValueToString(id), PortletTypeDescriptorBuilder.annotationValueToString(title), PortletTypeDescriptorBuilder.annotationValueToString(tooltip));
    }

    private static String annotationValueToString(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return "";
        }
        if (annotationValue.getParameterValue() instanceof String) {
            String parameterValue = (String)annotationValue.getParameterValue();
            return parameterValue.substring(1, parameterValue.length() - 1);
        }
        return annotationValue.getParameterValue().toString();
    }
}

