/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.webprotege.maven;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringEscapeUtils;

public class PortletTypeDescriptor
implements Comparable<PortletTypeDescriptor> {
    private final String packageName;
    private final String canonicalClassName;
    private final String simpleName;
    private final String id;
    private final String title;
    private final String tooltip;

    public PortletTypeDescriptor(String canonicalClassName, String simpleName, String packageName, String id, String title, String tooltip) {
        this.canonicalClassName = (String)Preconditions.checkNotNull((Object)canonicalClassName);
        this.simpleName = (String)Preconditions.checkNotNull((Object)simpleName);
        this.id = (String)Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((!id.startsWith("\"") && !id.endsWith("\"") ? 1 : 0) != 0);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        Preconditions.checkArgument((!title.startsWith("\"") && !title.endsWith("\"") ? 1 : 0) != 0);
        this.packageName = (String)Preconditions.checkNotNull((Object)packageName);
        this.tooltip = (String)Preconditions.checkNotNull((Object)tooltip);
        Preconditions.checkArgument((!tooltip.startsWith("\"") && !tooltip.endsWith("\"") ? 1 : 0) != 0);
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getCanonicalClassName() {
        return this.canonicalClassName;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getEscapedTitle() {
        return StringEscapeUtils.escapeJava((String)this.title);
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getEscapedTooltip() {
        return StringEscapeUtils.escapeJava((String)this.tooltip);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.canonicalClassName, this.id, this.title});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PortletTypeDescriptor)) {
            return false;
        }
        PortletTypeDescriptor other = (PortletTypeDescriptor)obj;
        return this.canonicalClassName.equals(other.canonicalClassName) && this.simpleName.equals(other.simpleName) && this.packageName.equals(other.packageName) && this.id.equals(other.id) && this.title.equals(other.title) && this.tooltip.equals(other.tooltip);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PortletTypeDescriptor").addValue((Object)this.id).addValue((Object)this.title).addValue((Object)this.canonicalClassName).addValue((Object)this.packageName).addValue((Object)this.simpleName).toString();
    }

    @Override
    public int compareTo(PortletTypeDescriptor o) {
        return this.canonicalClassName.compareTo(o.canonicalClassName);
    }
}

