/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.webprotege.maven;

import com.google.common.base.Charsets;
import edu.stanford.webprotege.maven.SourceWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class MavenSourceWriter
implements SourceWriter {
    private static final String TARGET_DIR_NAME = "target";
    private static final String GENERATED_SOURCES_DIR_NAME = "generated-sources";
    private final MavenProject mavenProject;
    private final Log log;

    public MavenSourceWriter(MavenProject mavenProject, Log log) {
        this.mavenProject = mavenProject;
        this.log = log;
    }

    @Override
    public void writeSource(String packageName, String simpleClassName, String source) throws IOException {
        String packagePathName = packageName.replace(".", "/");
        Path outputDirectory = this.getOutputDirectory();
        Path packagePath = outputDirectory.resolve(packagePathName);
        Files.createDirectories(packagePath, new FileAttribute[0]);
        Path classFilePath = packagePath.resolve(simpleClassName + ".java");
        try (OutputStream os = Files.newOutputStream(classFilePath, new OpenOption[0]);){
            os.write(source.getBytes(Charsets.UTF_8));
        }
        String extraSourceRoot = outputDirectory.toAbsolutePath().toString();
        if (!this.mavenProject.getCompileSourceRoots().contains(extraSourceRoot)) {
            this.log.info((CharSequence)("[WebProtegeMojo] Adding source root for generated sources: " + extraSourceRoot));
            this.mavenProject.addCompileSourceRoot(extraSourceRoot);
        }
    }

    private Path getOutputDirectory() {
        File file = this.mavenProject.getBasedir();
        return Paths.get(file.getAbsolutePath(), TARGET_DIR_NAME, GENERATED_SOURCES_DIR_NAME, "webprotege");
    }
}

