/*
 * Decompiled with CFR 0.152.
 */
package dk.nota.lyt.libvlc.media;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.util.Locale;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.MediaPlayer;
import org.videolan.libvlc.util.Extensions;

public class MediaWrapper
implements Parcelable {
    public static final String TAG = MediaWrapper.class.getCanonicalName();
    public static final int TYPE_ALL = -1;
    public static final int TYPE_VIDEO = 0;
    public static final int TYPE_AUDIO = 1;
    public static final int TYPE_GROUP = 2;
    public static final int TYPE_DIR = 3;
    public static final int TYPE_SUBTITLE = 4;
    public static final int TYPE_PLAYLIST = 5;
    public static final int MEDIA_VIDEO = 1;
    public static final int MEDIA_NO_HWACCEL = 2;
    public static final int MEDIA_PAUSED = 4;
    public static final int MEDIA_FORCE_AUDIO = 8;
    protected String mTitle;
    protected String mDisplayTitle;
    private String mArtist;
    private String mGenre;
    private String mCopyright;
    private String mAlbum;
    private int mTrackNumber;
    private int mDiscNumber;
    private String mAlbumArtist;
    private String mDescription;
    private String mRating;
    private String mDate;
    private String mSettings;
    private String mNowPlaying;
    private String mPublisher;
    private String mEncodedBy;
    private String mTrackID;
    private String mArtworkURL;
    private final Uri mUri;
    private String mFilename;
    private long mTime = 0L;
    private int mAudioTrack = -2;
    private int mSpuTrack = -2;
    private long mLength = 0L;
    private int mType;
    private int mWidth = 0;
    private int mHeight = 0;
    private Bitmap mPicture;
    private boolean mIsPictureParsed;
    private int mFlags = 0;
    private long mLastModified = 0L;
    public static final Parcelable.Creator<MediaWrapper> CREATOR = new Parcelable.Creator<MediaWrapper>(){

        public MediaWrapper createFromParcel(Parcel in) {
            return new MediaWrapper(in);
        }

        public MediaWrapper[] newArray(int size) {
            return new MediaWrapper[size];
        }
    };

    public MediaWrapper(Uri uri) {
        if (uri == null) {
            throw new NullPointerException("uri was null");
        }
        this.mUri = uri;
        this.init(null);
    }

    public MediaWrapper(Media media) {
        if (media == null) {
            throw new NullPointerException("media was null");
        }
        this.mUri = media.getUri();
        this.init(media);
    }

    public boolean equals(Object obj) {
        return this.mUri == ((MediaWrapper)obj).getUri();
    }

    private void init(Media media) {
        this.mType = -1;
        if (media != null) {
            if (media.isParsed()) {
                this.mLength = media.getDuration();
                for (int i = 0; i < media.getTrackCount(); ++i) {
                    Media.Track track = media.getTrack(i);
                    if (track == null) continue;
                    if (track.type == 1) {
                        Media.VideoTrack videoTrack = (Media.VideoTrack)track;
                        this.mType = 0;
                        this.mWidth = videoTrack.width;
                        this.mHeight = videoTrack.height;
                        continue;
                    }
                    if (this.mType != -1 || track.type != 0) continue;
                    this.mType = 1;
                }
            }
            this.updateMeta(media);
            if (this.mType == -1 && media.getType() == 2) {
                this.mType = 3;
            }
        }
        this.defineType();
    }

    public void defineType() {
        int dotIndex;
        if (this.mType != -1) {
            return;
        }
        String fileExt = null;
        int n = dotIndex = this.mTitle != null ? this.mTitle.lastIndexOf(".") : -1;
        if (dotIndex != -1) {
            fileExt = this.mTitle.substring(dotIndex).toLowerCase(Locale.ENGLISH);
        } else {
            int index = this.mUri.toString().indexOf(63);
            String location = index == -1 ? this.mUri.toString() : this.mUri.toString().substring(0, index);
            dotIndex = location.lastIndexOf(".");
            if (dotIndex != -1) {
                fileExt = location.substring(dotIndex).toLowerCase(Locale.ENGLISH);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)fileExt)) {
            if (Extensions.VIDEO.contains(fileExt)) {
                this.mType = 0;
            } else if (Extensions.AUDIO.contains(fileExt)) {
                this.mType = 1;
            } else if (Extensions.SUBTITLES.contains(fileExt)) {
                this.mType = 4;
            } else if (Extensions.PLAYLIST.contains(fileExt)) {
                this.mType = 5;
            }
        }
    }

    private void init(long time, long length, int type, Bitmap picture, String title, String artist, String genre, String album, String albumArtist, int width, int height, String artworkURL, int audio, int spu, int trackNumber, int discNumber, long lastModified) {
        this.mFilename = null;
        this.mTime = time;
        this.mAudioTrack = audio;
        this.mSpuTrack = spu;
        this.mLength = length;
        this.mType = type;
        this.mPicture = picture;
        this.mWidth = width;
        this.mHeight = height;
        this.mTitle = title;
        this.mArtist = artist;
        this.mGenre = genre;
        this.mAlbum = album;
        this.mAlbumArtist = albumArtist;
        this.mArtworkURL = artworkURL;
        this.mTrackNumber = trackNumber;
        this.mDiscNumber = discNumber;
        this.mLastModified = lastModified;
    }

    public MediaWrapper(Uri uri, long time, long length, int type, Bitmap picture, String title, String artist, String genre, String album, String albumArtist, int width, int height, String artworkURL, int audio, int spu, int trackNumber, int discNumber, long lastModified) {
        this.mUri = uri;
        this.init(time, length, type, picture, title, artist, genre, album, albumArtist, width, height, artworkURL, audio, spu, trackNumber, discNumber, lastModified);
    }

    public String getLocation() {
        return this.mUri.toString();
    }

    public Uri getUri() {
        return this.mUri;
    }

    private static String getMetaId(Media media, int id, boolean trim) {
        String meta = media.getMeta(id);
        return meta != null ? (trim ? meta.trim() : meta) : null;
    }

    private String getUpdatedMetaId(Media media, int id, String current, boolean trim) {
        String parsedValue = MediaWrapper.getMetaId(media, id, trim);
        if (parsedValue != null && !parsedValue.equals(current)) {
            return parsedValue;
        }
        return current;
    }

    public void updateMeta(Media media) {
        String discNumber;
        this.mTitle = this.getUpdatedMetaId(media, 0, this.mTitle, true);
        this.mArtist = this.getUpdatedMetaId(media, 1, this.mArtist, true);
        this.mAlbum = this.getUpdatedMetaId(media, 4, this.mAlbum, true);
        this.mGenre = this.getUpdatedMetaId(media, 2, this.mGenre, true);
        this.mAlbumArtist = this.getUpdatedMetaId(media, 23, this.mAlbumArtist, true);
        this.mArtworkURL = this.getUpdatedMetaId(media, 15, this.mArtworkURL, false);
        this.mNowPlaying = MediaWrapper.getMetaId(media, 12, false);
        String trackNumber = MediaWrapper.getMetaId(media, 5, false);
        if (!TextUtils.isEmpty((CharSequence)trackNumber)) {
            try {
                this.mTrackNumber = Integer.parseInt(trackNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(discNumber = MediaWrapper.getMetaId(media, 24, false)))) {
            try {
                this.mDiscNumber = Integer.parseInt(discNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Log.d((String)TAG, (String)("Title " + this.mTitle));
        Log.d((String)TAG, (String)("Artist " + this.mArtist));
        Log.d((String)TAG, (String)("Genre " + this.mGenre));
        Log.d((String)TAG, (String)("Album " + this.mAlbum));
        Log.d((String)TAG, (String)("ArtworkUrl " + this.mArtworkURL));
    }

    public void updateMeta(MediaPlayer mediaPlayer) {
        Media media = mediaPlayer.getMedia();
        if (media == null) {
            return;
        }
        this.updateMeta(media);
        media.release();
    }

    public String getFileName() {
        if (this.mFilename == null) {
            this.mFilename = this.mUri.getLastPathSegment();
        }
        return this.mFilename;
    }

    public long getTime() {
        return this.mTime;
    }

    public void setTime(long time) {
        this.mTime = time;
    }

    public int getAudioTrack() {
        return this.mAudioTrack;
    }

    public void setAudioTrack(int track) {
        this.mAudioTrack = track;
    }

    public int getSpuTrack() {
        return this.mSpuTrack;
    }

    public void setSpuTrack(int track) {
        this.mSpuTrack = track;
    }

    public long getLength() {
        return this.mLength;
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public Bitmap getPicture() {
        return this.mPicture;
    }

    public void setPicture(Bitmap p) {
        this.mPicture = p;
    }

    public boolean isPictureParsed() {
        return this.mIsPictureParsed;
    }

    public void setPictureParsed(boolean isParsed) {
        this.mIsPictureParsed = isParsed;
    }

    public void setDisplayTitle(String title) {
        this.mDisplayTitle = title;
    }

    public void setArtist(String artist) {
        this.mArtist = artist;
    }

    public void setAlbum(String album) {
        this.mAlbum = album;
    }

    public String getTitle() {
        if (!TextUtils.isEmpty((CharSequence)this.mDisplayTitle)) {
            return this.mDisplayTitle;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            return this.mTitle;
        }
        String fileName = this.getFileName();
        if (fileName == null) {
            return "";
        }
        int end = fileName.lastIndexOf(".");
        if (end <= 0) {
            return fileName;
        }
        return fileName.substring(0, end);
    }

    public String getReferenceArtist() {
        return this.mAlbumArtist == null ? this.mArtist : this.mAlbumArtist;
    }

    public String getArtist() {
        return this.mArtist;
    }

    public Boolean isArtistUnknown() {
        return this.mArtist == null;
    }

    public String getGenre() {
        if (this.mGenre == null) {
            return null;
        }
        if (this.mGenre.length() > 1) {
            return Character.toUpperCase(this.mGenre.charAt(0)) + this.mGenre.substring(1).toLowerCase(Locale.getDefault());
        }
        return this.mGenre;
    }

    public String getCopyright() {
        return this.mCopyright;
    }

    public String getAlbum() {
        return this.mAlbum;
    }

    public String getAlbumArtist() {
        return this.mAlbumArtist;
    }

    public Boolean isAlbumUnknown() {
        return this.mAlbum == null;
    }

    public int getTrackNumber() {
        return this.mTrackNumber;
    }

    public int getDiscNumber() {
        return this.mDiscNumber;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getRating() {
        return this.mRating;
    }

    public String getDate() {
        return this.mDate;
    }

    public String getSettings() {
        return this.mSettings;
    }

    public String getNowPlaying() {
        return this.mNowPlaying;
    }

    public String getPublisher() {
        return this.mPublisher;
    }

    public String getEncodedBy() {
        return this.mEncodedBy;
    }

    public String getTrackID() {
        return this.mTrackID;
    }

    public String getArtworkURL() {
        return this.mArtworkURL;
    }

    public void setArtworkURL(String url) {
        this.mArtworkURL = url;
    }

    public long getLastModified() {
        return this.mLastModified;
    }

    public void setLastModified(long mLastModified) {
        this.mLastModified = mLastModified;
    }

    public void addFlags(int flags) {
        this.mFlags |= flags;
    }

    public void setFlags(int flags) {
        this.mFlags = flags;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean hasFlag(int flag) {
        return (this.mFlags & flag) != 0;
    }

    public void removeFlags(int flags) {
        this.mFlags &= ~flags;
    }

    public int describeContents() {
        return 0;
    }

    public MediaWrapper(Parcel in) {
        this.mUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.init(in.readLong(), in.readLong(), in.readInt(), (Bitmap)in.readParcelable(Bitmap.class.getClassLoader()), in.readString(), in.readString(), in.readString(), in.readString(), in.readString(), in.readInt(), in.readInt(), in.readString(), in.readInt(), in.readInt(), in.readInt(), in.readInt(), in.readLong());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mUri, flags);
        dest.writeLong(this.getTime());
        dest.writeLong(this.getLength());
        dest.writeInt(this.getType());
        dest.writeParcelable((Parcelable)this.getPicture(), flags);
        dest.writeString(this.getTitle());
        dest.writeString(this.getArtist());
        dest.writeString(this.getGenre());
        dest.writeString(this.getAlbum());
        dest.writeString(this.getAlbumArtist());
        dest.writeInt(this.getWidth());
        dest.writeInt(this.getHeight());
        dest.writeString(this.getArtworkURL());
        dest.writeInt(this.getAudioTrack());
        dest.writeInt(this.getSpuTrack());
        dest.writeInt(this.getTrackNumber());
        dest.writeInt(this.getDiscNumber());
        dest.writeLong(this.getLastModified());
    }
}

