/*
 * Decompiled with CFR 0.152.
 */
package dk.nota.lyt.libvlc;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Process;
import android.util.Log;
import dk.nota.lyt.libvlc.media.MediaWrapper;
import dk.nota.lyt.libvlc.media.MediaWrapperList;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.util.AndroidUtil;
import org.videolan.libvlc.util.VLCUtil;

public class Utils {
    private static final String TAG = Utils.class.getCanonicalName();
    private static LibVLC sLibVLC;

    public static synchronized LibVLC GetLibVLC(Context ctx, ArrayList<String> vlcOptions) throws IllegalStateException {
        if (sLibVLC == null) {
            Log.i((String)TAG, (String)"=== Creating LibVLC instance with options ===");
            for (String option : vlcOptions) {
                Log.i((String)TAG, (String)("Option: " + option));
            }
            if (!VLCUtil.hasCompatibleCPU((Context)ctx)) {
                StringBuilder abiList = new StringBuilder();
                for (String arch : VLCUtil.getABIList()) {
                    abiList.append(" " + arch);
                }
                throw new IllegalStateException("LibVLC found no compatible device CPU. ABIs available:" + abiList);
            }
            sLibVLC = new LibVLC(vlcOptions);
            LibVLC.setOnNativeCrashListener((LibVLC.OnNativeCrashListener)new LibVLC.OnNativeCrashListener(){

                public void onNativeCrash() {
                    Log.e((String)TAG, (String)("Native crash in LibVLC on PID " + Process.myPid()));
                }
            });
        }
        return sLibVLC;
    }

    public static synchronized boolean testCompatibleCPU(Context context) {
        return sLibVLC != null || VLCUtil.hasCompatibleCPU((Context)context);
    }

    public static String getMediaArtist(MediaWrapper media) {
        String artist = media.getArtist();
        return artist != null ? artist : "Unknown Artist";
    }

    public static String getMediaReferenceArtist(MediaWrapper media) {
        String artist = media.getReferenceArtist();
        return artist != null ? artist : "Unknown Artist";
    }

    public static String getMediaAlbumArtist(MediaWrapper media) {
        String albumArtist = media.getAlbumArtist();
        return albumArtist != null ? albumArtist : "Unknown Artist";
    }

    public static String getMediaAlbum(MediaWrapper media) {
        String album = media.getAlbum();
        return album != null ? album : "Unknown Album";
    }

    public static String getMediaGenre(MediaWrapper media) {
        String genre = media.getGenre();
        return genre != null ? genre : "Unknown Genre";
    }

    public static String getMediaSubtitle(MediaWrapper media) {
        if (media.getType() == 1) {
            return media.getNowPlaying() != null ? media.getNowPlaying() : Utils.getMediaArtist(media) + " - " + Utils.getMediaAlbum(media);
        }
        return "";
    }

    public static String getMediaTitle(MediaWrapper mediaWrapper) {
        String title = mediaWrapper.getTitle();
        if (title == null) {
            title = Utils.getFileNameFromPath(mediaWrapper.getLocation());
        }
        return title;
    }

    public static String getFileNameFromPath(String path) {
        if (path == null) {
            return "";
        }
        int index = path.lastIndexOf(47);
        if (index > -1) {
            return path.substring(index + 1);
        }
        return path;
    }

    public static String getPathFromURI(Uri uri) {
        return null;
    }

    public static Uri LocationToUri(String location) {
        return AndroidUtil.LocationToUri((String)location);
    }

    public static String getHashFromStrings(ArrayList<String> inputStrings) {
        Log.i((String)TAG, (String)("Get hash for: " + Arrays.toString(inputStrings.toArray())));
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            for (String s : inputStrings) {
                md.update(s.getBytes());
            }
            return String.format("%032X", new BigInteger(1, md.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            return Arrays.toString(inputStrings.toArray());
        }
    }

    public static String getHashFromMediaList(MediaWrapperList list) {
        ArrayList<String> mrlList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            mrlList.add(list.getMRL(i));
        }
        return Utils.getHashFromStrings(mrlList);
    }

    public static boolean hasInternetConnection(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected();
    }
}

