/*
 * Decompiled with CFR 0.152.
 */
package dk.nota.lyt.libvlc;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.support.v7.app.NotificationCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import dk.nota.lyt.libvlc.CountDownTimer;
import dk.nota.lyt.libvlc.DefaultOptions;
import dk.nota.lyt.libvlc.PlaybackEventHandler;
import dk.nota.lyt.libvlc.R;
import dk.nota.lyt.libvlc.RemoteControlEventReceiver;
import dk.nota.lyt.libvlc.Utils;
import dk.nota.lyt.libvlc.media.MediaEvent;
import dk.nota.lyt.libvlc.media.MediaPlayerEvent;
import dk.nota.lyt.libvlc.media.MediaWrapper;
import dk.nota.lyt.libvlc.media.MediaWrapperList;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.videolan.libvlc.IVLCVout;
import org.videolan.libvlc.LibVLC;
import org.videolan.libvlc.Media;
import org.videolan.libvlc.MediaList;
import org.videolan.libvlc.MediaPlayer;
import org.videolan.libvlc.util.AndroidUtil;

public class PlaybackService
extends Service {
    private static final String TAG = PlaybackService.class.getCanonicalName();
    private static final int SHOW_PROGRESS = 0;
    private static final int SHOW_TOAST = 1;
    public static final String ACTION_REMOTE_GENERIC = PlaybackService.class.getPackage().getName() + ".remote.";
    public static final String ACTION_REMOTE_BACKWARD = ACTION_REMOTE_GENERIC + "Backward";
    public static final String ACTION_REMOTE_PLAY = ACTION_REMOTE_GENERIC + "Play";
    public static final String ACTION_REMOTE_PLAYPAUSE = ACTION_REMOTE_GENERIC + "PlayPause";
    public static final String ACTION_REMOTE_PAUSE = ACTION_REMOTE_GENERIC + "Pause";
    public static final String ACTION_REMOTE_STOP = ACTION_REMOTE_GENERIC + "Stop";
    public static final String ACTION_REMOTE_FORWARD = ACTION_REMOTE_GENERIC + "Forward";
    private SharedPreferences mSettings;
    private final IBinder mBinder = new LocalBinder();
    private MediaWrapperList mMediaList = new MediaWrapperList();
    private MediaPlayer mMediaPlayer;
    private Activity mNotificationActivity;
    private String mNotificationAction;
    private String mMediaListIdentifier;
    private final ArrayList<PlaybackEventHandler> mPlaybackEventHandlers = new ArrayList();
    private boolean mDetectHeadset = true;
    private PowerManager.WakeLock mWakeLock;
    private final AtomicBoolean mExpanding = new AtomicBoolean(false);
    private Stack<Integer> mPrevious;
    private int mCurrentIndex;
    private int mPrevIndex;
    private int mNextIndex;
    MediaSessionCompat mMediaSession;
    protected MediaSessionCallback mSessionCallback;
    private static final long PLAYBACK_ACTIONS = 55L;
    public static final int TYPE_AUDIO = 0;
    public static final int REPEAT_NONE = 0;
    public static final int REPEAT_ONE = 1;
    public static final int REPEAT_ALL = 2;
    private int mRepeating = 0;
    private boolean mShuffling = false;
    private Random mRandom = null;
    private long mSavedTime = 0L;
    private boolean mHasAudioFocus = false;
    private boolean mParsed = false;
    private boolean mSeekable = false;
    private boolean mPausable = false;
    private CountDownTimer mSleepTimer;
    private int mSleepTimerVolumeFadeDurationMillis = 5000;
    private RemoteControlEventReceiver mRemoteControlClientReceiver = null;
    private ComponentName mRemoteControlClientReceiverComponent;
    private final AudioManager.OnAudioFocusChangeListener mAudioFocusListener = AndroidUtil.isFroyoOrLater() ? this.createOnAudioFocusChangeListener() : null;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){
        private boolean wasPlaying = false;

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int state = intent.getIntExtra("state", 0);
            if (PlaybackService.this.mMediaPlayer == null) {
                Log.w((String)TAG, (String)"Intent received, but VLC is not loaded, skipping.");
                return;
            }
            TelephonyManager telManager = (TelephonyManager)PlaybackService.this.getApplicationContext().getSystemService("phone");
            if (telManager != null && telManager.getCallState() != 0) {
                return;
            }
            if (action.startsWith(ACTION_REMOTE_GENERIC) && !PlaybackService.this.mMediaPlayer.isPlaying() && !PlaybackService.this.hasCurrentMedia()) {
                context.startActivity(PlaybackService.this.getPackageManager().getLaunchIntentForPackage(PlaybackService.this.getPackageName()));
            }
            if (action.equalsIgnoreCase(ACTION_REMOTE_PLAYPAUSE)) {
                if (!PlaybackService.this.hasCurrentMedia()) {
                    return;
                }
                if (PlaybackService.this.mMediaPlayer.isPlaying()) {
                    PlaybackService.this.pause();
                } else {
                    PlaybackService.this.play();
                }
            } else if (action.equalsIgnoreCase(ACTION_REMOTE_PLAY)) {
                if (!PlaybackService.this.mMediaPlayer.isPlaying() && PlaybackService.this.hasCurrentMedia()) {
                    PlaybackService.this.play();
                }
            } else if (action.equalsIgnoreCase(ACTION_REMOTE_PAUSE)) {
                if (PlaybackService.this.hasCurrentMedia()) {
                    PlaybackService.this.pause();
                }
            } else if (action.equalsIgnoreCase(ACTION_REMOTE_BACKWARD)) {
                PlaybackService.this.previous();
            } else if (action.equalsIgnoreCase(ACTION_REMOTE_STOP)) {
                PlaybackService.this.stopService();
            } else if (action.equalsIgnoreCase(ACTION_REMOTE_FORWARD)) {
                PlaybackService.this.next();
            } else if (PlaybackService.this.mDetectHeadset) {
                if (action.equalsIgnoreCase("android.media.AUDIO_BECOMING_NOISY")) {
                    Log.d((String)TAG, (String)"Headset Removed.");
                    this.wasPlaying = PlaybackService.this.isPlaying();
                    if (this.wasPlaying && PlaybackService.this.hasCurrentMedia()) {
                        PlaybackService.this.pause();
                    }
                } else if (action.equalsIgnoreCase("android.intent.action.HEADSET_PLUG") && state != 0) {
                    Log.d((String)TAG, (String)"Headset Inserted.");
                    if (this.wasPlaying && PlaybackService.this.hasCurrentMedia()) {
                        PlaybackService.this.play();
                    }
                }
            }
        }
    };
    private final Media.EventListener mMediaListener = new Media.EventListener(){

        public void onEvent(Media.Event event) {
            boolean update = true;
            switch (event.type) {
                case 0: {
                    if (PlaybackService.this.mParsed && PlaybackService.this.updateCurrentMeta(event.getMetaId())) {
                        PlaybackService.this.executeUpdate();
                    }
                    Log.d((String)TAG, (String)("Media.Event.MetaChanged: " + event.getMetaId()));
                    break;
                }
                case 3: {
                    Log.d((String)TAG, (String)"Media.Event.ParsedChanged");
                    PlaybackService.this.updateCurrentMeta(-1);
                    PlaybackService.this.mParsed = true;
                    break;
                }
                default: {
                    update = false;
                }
            }
            if (update) {
                for (PlaybackEventHandler handler : PlaybackService.this.mPlaybackEventHandlers) {
                    try {
                        handler.onMediaEvent(new MediaEvent(event));
                    }
                    catch (Exception ex) {
                        Log.d((String)TAG, (String)("Error notifying PlaybackEventHandlers.onMediaEvent: " + ex.getMessage()));
                    }
                }
                if (PlaybackService.this.mParsed) {
                    PlaybackService.this.showNotification();
                }
            }
        }
    };
    private final MediaPlayer.EventListener mMediaPlayerListener = new MediaPlayer.EventListener(){

        private void notifyPlaybackEventHandlers(MediaPlayer.Event event) {
            for (PlaybackEventHandler handler : PlaybackService.this.mPlaybackEventHandlers) {
                try {
                    handler.onMediaPlayerEvent(new MediaPlayerEvent(event));
                }
                catch (Exception ex) {
                    Log.d((String)TAG, (String)("Error notifying PlaybackEventHandler.onMediaPlayerEvent: " + ex.getMessage()));
                }
            }
        }

        public void onEvent(MediaPlayer.Event event) {
            switch (event.type) {
                case 260: {
                    Log.d((String)TAG, (String)"MediaPlayer.Event.Playing");
                    PlaybackService.this.executeUpdate();
                    PlaybackService.this.publishState(event.type);
                    PlaybackService.this.executeUpdateProgress();
                    PlaybackService.this.mHandler.sendEmptyMessage(0);
                    PlaybackService.this.changeAudioFocus(true);
                    if (!PlaybackService.this.mWakeLock.isHeld()) {
                        PlaybackService.this.mWakeLock.acquire();
                    }
                    PlaybackService.this.showNotification();
                    break;
                }
                case 261: {
                    Log.d((String)TAG, (String)"MediaPlayer.Event.Paused");
                    PlaybackService.this.executeUpdate();
                    PlaybackService.this.publishState(event.type);
                    PlaybackService.this.executeUpdateProgress();
                    PlaybackService.this.showNotification();
                    if (!PlaybackService.this.mWakeLock.isHeld()) break;
                    PlaybackService.this.mWakeLock.release();
                    break;
                }
                case 262: {
                    Log.d((String)TAG, (String)"MediaPlayer.Event.Stopped");
                    PlaybackService.this.executeUpdate();
                    PlaybackService.this.publishState(event.type);
                    PlaybackService.this.executeUpdateProgress();
                    if (PlaybackService.this.mWakeLock.isHeld()) {
                        PlaybackService.this.mWakeLock.release();
                    }
                    PlaybackService.this.changeAudioFocus(false);
                    break;
                }
                case 265: {
                    Log.d((String)TAG, (String)"MediaPlayer.Event.EndReached");
                    PlaybackService.this.executeUpdateProgress();
                    PlaybackService.this.determinePrevAndNextIndices(true);
                    if (PlaybackService.this.mWakeLock.isHeld()) {
                        PlaybackService.this.mWakeLock.release();
                    }
                    PlaybackService.this.changeAudioFocus(false);
                    this.notifyPlaybackEventHandlers(event);
                    PlaybackService.this.next();
                    return;
                }
                case 266: {
                    Log.d((String)TAG, (String)"MediaPlayer.Event.EncounteredError");
                    PlaybackService.this.executeUpdate();
                    PlaybackService.this.executeUpdateProgress();
                    if (PlaybackService.this.mPausable) {
                        PlaybackService.this.pause();
                    } else {
                        PlaybackService.this.stopPlayback();
                    }
                    if (!PlaybackService.this.mWakeLock.isHeld()) break;
                    PlaybackService.this.mWakeLock.release();
                    break;
                }
                case 267: {
                    break;
                }
                case 268: {
                    break;
                }
                case 274: {
                    break;
                }
                case 276: {
                    PlaybackService.this.updateMetadata();
                    break;
                }
                case 277: {
                    break;
                }
                case 270: {
                    PlaybackService.this.mPausable = event.getPausable();
                    break;
                }
                case 269: {
                    PlaybackService.this.mSeekable = event.getSeekable();
                }
            }
            this.notifyPlaybackEventHandlers(event);
        }
    };
    private final MediaWrapperList.EventListener mListEventListener = new MediaWrapperList.EventListener(){

        @Override
        public void onItemAdded(int index, String mrl) {
            Log.d((String)TAG, (String)"CustomMediaListItemAdded");
            if (PlaybackService.this.mCurrentIndex >= index && !PlaybackService.this.mExpanding.get()) {
                PlaybackService.this.mCurrentIndex++;
            }
            PlaybackService.this.determinePrevAndNextIndices();
            PlaybackService.this.executeUpdate();
        }

        @Override
        public void onItemRemoved(int index, String mrl) {
            Log.d((String)TAG, (String)"CustomMediaListItemDeleted");
            if (PlaybackService.this.mCurrentIndex == index && !PlaybackService.this.mExpanding.get()) {
                PlaybackService.this.mCurrentIndex--;
                PlaybackService.this.determinePrevAndNextIndices();
                if (PlaybackService.this.mNextIndex != -1) {
                    PlaybackService.this.next();
                } else if (PlaybackService.this.mCurrentIndex != -1) {
                    PlaybackService.this.playIndex(PlaybackService.this.mCurrentIndex, 0);
                } else {
                    PlaybackService.this.stopService();
                }
            }
            if (PlaybackService.this.mCurrentIndex > index && !PlaybackService.this.mExpanding.get()) {
                PlaybackService.this.mCurrentIndex--;
            }
            PlaybackService.this.determinePrevAndNextIndices();
            PlaybackService.this.executeUpdate();
        }

        @Override
        public void onItemMoved(int indexBefore, int indexAfter, String mrl) {
            Log.d((String)TAG, (String)"CustomMediaListItemMoved");
            if (PlaybackService.this.mCurrentIndex == indexBefore) {
                PlaybackService.this.mCurrentIndex = indexAfter;
                if (indexAfter > indexBefore) {
                    PlaybackService.this.mCurrentIndex--;
                }
            } else if (indexBefore > PlaybackService.this.mCurrentIndex && indexAfter <= PlaybackService.this.mCurrentIndex) {
                PlaybackService.this.mCurrentIndex++;
            } else if (indexBefore < PlaybackService.this.mCurrentIndex && indexAfter > PlaybackService.this.mCurrentIndex) {
                PlaybackService.this.mCurrentIndex--;
            }
            PlaybackService.this.mPrevious.clear();
            PlaybackService.this.determinePrevAndNextIndices();
            PlaybackService.this.executeUpdate();
        }
    };
    private final Handler mHandler = new AudioServiceHandler(this);
    private static final int REQ_CODE = 123;
    private static final int NOTIFICATION_ID = 99;
    private Bitmap mDefaultArtworkBitmap;
    private Runnable mFadeOutAndPauseTask = new Runnable(){
        private int fadeTickMillis = 250;

        @Override
        public void run() {
            int previousVolume = PlaybackService.this.getVolume();
            while (PlaybackService.this.getVolume() > 0) {
                double decreaseBy = (double)this.fadeTickMillis / (double)PlaybackService.this.mSleepTimerVolumeFadeDurationMillis * 100.0;
                int newVolume = Math.max(PlaybackService.this.getVolume() - (int)decreaseBy, 0);
                Log.d((String)TAG, (String)("Fade volume: " + newVolume));
                PlaybackService.this.setVolume(newVolume);
                try {
                    Thread.sleep(this.fadeTickMillis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            PlaybackService.this.pause();
            PlaybackService.this.setVolume(previousVolume);
        }
    };

    public static PlaybackService getService(IBinder iBinder) {
        LocalBinder binder = (LocalBinder)iBinder;
        return binder.getService();
    }

    private LibVLC LibVLC() {
        ArrayList<String> defaultOptions = new ArrayList<String>();
        if (DefaultOptions.AutoReconnect) {
            defaultOptions.add("--http-reconnect");
        }
        defaultOptions.add("--network-caching=" + DefaultOptions.NetworkCaching);
        defaultOptions.add("--file-caching=" + DefaultOptions.FileCaching);
        return Utils.GetLibVLC(this.getApplicationContext(), defaultOptions);
    }

    private MediaPlayer newMediaPlayer() {
        MediaPlayer mp = new MediaPlayer(this.LibVLC());
        return mp;
    }

    public void onCreate() {
        super.onCreate();
        this.mSettings = PreferenceManager.getDefaultSharedPreferences((Context)this);
        this.mMediaPlayer = this.newMediaPlayer();
        if (!Utils.testCompatibleCPU((Context)this)) {
            this.stopSelf();
            return;
        }
        this.mDetectHeadset = this.mSettings.getBoolean("enable_headset_detection", true);
        this.mCurrentIndex = -1;
        this.mPrevIndex = -1;
        this.mNextIndex = -1;
        this.mPrevious = new Stack();
        this.mRemoteControlClientReceiverComponent = new ComponentName(this.getApplicationContext(), RemoteControlEventReceiver.class.getName());
        PowerManager pm = (PowerManager)this.getApplicationContext().getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, TAG);
        IntentFilter filter = new IntentFilter();
        filter.setPriority(Integer.MAX_VALUE);
        filter.addAction(ACTION_REMOTE_BACKWARD);
        filter.addAction(ACTION_REMOTE_PLAYPAUSE);
        filter.addAction(ACTION_REMOTE_PLAY);
        filter.addAction(ACTION_REMOTE_PAUSE);
        filter.addAction(ACTION_REMOTE_STOP);
        filter.addAction(ACTION_REMOTE_FORWARD);
        filter.addAction("android.intent.action.HEADSET_PLUG");
        filter.addAction("android.media.AUDIO_BECOMING_NOISY");
        this.registerReceiver(this.mReceiver, filter);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            return 1;
        }
        if (ACTION_REMOTE_PLAYPAUSE.equals(intent.getAction())) {
            if (this.hasCurrentMedia()) {
                return 1;
            }
            this.loadLastPlaylist(0);
        } else if (ACTION_REMOTE_PLAY.equals(intent.getAction())) {
            if (this.hasCurrentMedia()) {
                this.play();
            } else {
                this.loadLastPlaylist(0);
            }
        }
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopService();
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        if (this.mRemoteControlClientReceiver != null) {
            this.unregisterReceiver(this.mRemoteControlClientReceiver);
            this.mRemoteControlClientReceiver = null;
        }
        this.unregisterReceiver(this.mReceiver);
        this.mMediaPlayer.release();
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public boolean onUnbind(Intent intent) {
        if (!this.hasCurrentMedia()) {
            this.stopSelf();
        }
        return true;
    }

    public IVLCVout getVLCVout() {
        return this.mMediaPlayer.getVLCVout();
    }

    private AudioManager.OnAudioFocusChangeListener createOnAudioFocusChangeListener() {
        return new AudioManager.OnAudioFocusChangeListener(){
            private boolean mLossTransient = false;
            private boolean mLossTransientCanDuck = false;
            private boolean wasPlaying = false;

            public void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case -1: {
                        Log.d((String)TAG, (String)"AUDIOFOCUS_LOSS");
                        PlaybackService.this.changeAudioFocus(false);
                        PlaybackService.this.pause();
                        break;
                    }
                    case -2: {
                        Log.d((String)TAG, (String)"AUDIOFOCUS_LOSS_TRANSIENT");
                        this.mLossTransient = true;
                        this.wasPlaying = PlaybackService.this.isPlaying();
                        if (!this.wasPlaying) break;
                        PlaybackService.this.pause();
                        break;
                    }
                    case -3: {
                        Log.d((String)TAG, (String)"AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK");
                        if (!PlaybackService.this.mMediaPlayer.isPlaying()) break;
                        PlaybackService.this.mMediaPlayer.setVolume(36);
                        this.mLossTransientCanDuck = true;
                        break;
                    }
                    case 1: {
                        Log.d((String)TAG, (String)("AUDIOFOCUS_GAIN: " + this.mLossTransientCanDuck + ", " + this.mLossTransient));
                        if (this.mLossTransientCanDuck) {
                            PlaybackService.this.mMediaPlayer.setVolume(100);
                            this.mLossTransientCanDuck = false;
                            break;
                        }
                        if (!this.mLossTransient) break;
                        if (this.wasPlaying) {
                            PlaybackService.this.mMediaPlayer.play();
                        }
                        this.mLossTransient = false;
                    }
                }
            }
        };
    }

    private void changeAudioFocus(boolean acquire) {
        AudioManager am = (AudioManager)this.getSystemService("audio");
        if (am == null) {
            return;
        }
        if (acquire) {
            int result;
            if (!this.mHasAudioFocus && (result = am.requestAudioFocus(this.mAudioFocusListener, 3, 1)) == 1) {
                am.setParameters("bgm_state=true");
                this.mHasAudioFocus = true;
            }
        } else if (this.mHasAudioFocus) {
            int result = am.abandonAudioFocus(this.mAudioFocusListener);
            am.setParameters("bgm_state=false");
            this.mHasAudioFocus = false;
        }
    }

    private boolean updateCurrentMeta(int id) {
        if (id == 13) {
            return false;
        }
        MediaWrapper mw = this.getCurrentMedia();
        if (mw != null) {
            mw.updateMeta(this.mMediaPlayer);
        }
        return id != 12 || this.getCurrentMedia().getNowPlaying() != null;
    }

    private void executeUpdate() {
        for (PlaybackEventHandler handler : this.mPlaybackEventHandlers) {
            try {
                handler.update();
            }
            catch (Exception ex) {
                Log.d((String)TAG, (String)("Error notifying PlaybackEventHandler.update: " + ex.getMessage()));
            }
        }
        this.updateMetadata();
    }

    private void executeUpdateProgress() {
        for (PlaybackEventHandler handler : this.mPlaybackEventHandlers) {
            try {
                handler.updateProgress();
            }
            catch (Exception ex) {
                Log.d((String)TAG, (String)("Error notifying PlaybackEventHandler.updateProgress: " + ex.getMessage()));
            }
        }
    }

    @Nullable
    private MediaWrapper getCurrentMedia() {
        return this.mMediaList.getMedia(this.mCurrentIndex);
    }

    private boolean hasCurrentMedia() {
        return this.mCurrentIndex >= 0 && this.mCurrentIndex < this.mMediaList.size();
    }

    @TargetApi(value=21)
    private void showNotification() {
        Log.d((String)TAG, (String)"Update Notification");
        PendingIntent piStop = PendingIntent.getBroadcast((Context)this, (int)123, (Intent)new Intent(ACTION_REMOTE_STOP), (int)0x8000000);
        PendingIntent piBackward = PendingIntent.getBroadcast((Context)this, (int)123, (Intent)new Intent(ACTION_REMOTE_BACKWARD), (int)0x8000000);
        PendingIntent piPlay = PendingIntent.getBroadcast((Context)this, (int)123, (Intent)new Intent(ACTION_REMOTE_PLAYPAUSE), (int)0x8000000);
        PendingIntent piForward = PendingIntent.getBroadcast((Context)this, (int)123, (Intent)new Intent(ACTION_REMOTE_FORWARD), (int)0x8000000);
        NotificationCompat.Builder bob = new NotificationCompat.Builder((Context)this);
        bob.addAction(R.drawable.ic_skip_previous_white_24dp, this.getText(R.string.previous), piBackward);
        if (this.mMediaPlayer.isPlaying()) {
            bob.addAction(R.drawable.ic_pause_white_24dp, this.getText(R.string.pause), piPlay);
        } else {
            bob.addAction(R.drawable.ic_play_arrow_white_24dp, this.getText(R.string.play), piPlay);
        }
        bob.addAction(R.drawable.ic_skip_next_white_24dp, this.getText(R.string.next), piForward);
        boolean isPlaying = this.mMediaPlayer.isPlaying();
        long playbackPosition = this.mMediaPlayer.getTime();
        MediaWrapper currentMedia = this.getCurrentMedia();
        bob.setStyle((NotificationCompat.Style)new NotificationCompat.MediaStyle().setMediaSession(this.mMediaSession.getSessionToken()).setShowActionsInCompactView(new int[]{1}).setShowCancelButton(true).setCancelButtonIntent(piStop)).setSmallIcon(R.drawable.ic_notification).setVisibility(1).setContentTitle((CharSequence)currentMedia.getTitle()).setContentText((CharSequence)(currentMedia.getArtist() + " - " + currentMedia.getAlbum())).setTicker((CharSequence)currentMedia.getTitle()).setShowWhen(false).setDeleteIntent(piStop);
        if (this.mNotificationActivity != null) {
            Intent onClickIntent = new Intent((Context)this, this.mNotificationActivity.getClass());
            onClickIntent.setFlags(0x20000000);
            onClickIntent.setAction(this.mNotificationAction);
            onClickIntent.addCategory("android.intent.category.LAUNCHER");
            PendingIntent piOnClick = PendingIntent.getActivity((Context)this, (int)123, (Intent)onClickIntent, (int)0x8000000);
            bob.setContentIntent(piOnClick);
        }
        if (currentMedia.isPictureParsed()) {
            bob.setLargeIcon(currentMedia.getPicture());
        } else if (currentMedia.getArtworkURL() != null) {
            this.loadArtworkFromUrlAsync(currentMedia.getArtworkURL(), bob);
        } else {
            bob.setLargeIcon(this.getDefaultArtwork());
        }
        Notification notification = bob.build();
        if (!AndroidUtil.isLolliPopOrLater() || isPlaying) {
            this.startForeground(99, notification);
        } else {
            this.stopForeground(false);
            NotificationManagerCompat.from((Context)this).notify(99, notification);
        }
    }

    private Bitmap getDefaultArtwork() {
        if (this.mDefaultArtworkBitmap == null) {
            this.mDefaultArtworkBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.default_album_artwork);
        }
        return this.mDefaultArtworkBitmap;
    }

    private void loadArtworkFromUrlAsync(String artworkUrl, final NotificationCompat.Builder builder) {
        Glide.with((Context)this.getApplicationContext()).load(artworkUrl).asBitmap().fitCenter().placeholder(R.drawable.default_album_artwork).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                builder.setLargeIcon(resource);
                NotificationManagerCompat.from((Context)PlaybackService.this).notify(99, builder.build());
                PlaybackService.this.getCurrentMedia().setPicture(resource);
                PlaybackService.this.getCurrentMedia().setPictureParsed(true);
            }
        });
    }

    private void hideNotification() {
        this.hideNotification(true);
    }

    private void hideNotification(boolean stopPlayback) {
        this.stopForeground(true);
        NotificationManagerCompat.from((Context)this).cancel(99);
        if (stopPlayback) {
            this.stopSelf();
        }
    }

    public <T extends Activity> void setNotificationActivity(T notificationActivity, String action) {
        this.mNotificationActivity = notificationActivity;
        this.mNotificationAction = action;
    }

    @MainThread
    public void pause() {
        if (this.mPausable) {
            this.savePosition();
            this.mHandler.removeMessages(0);
            this.mMediaPlayer.pause();
            this.broadcastMetadata();
            this.pauseSleepTimer();
        }
    }

    @MainThread
    public void play() {
        if (!this.hasCurrentMedia() && this.mMediaList.size() > 0) {
            this.playIndex(0);
        } else if (this.hasCurrentMedia()) {
            this.mMediaPlayer.play();
            this.mHandler.sendEmptyMessage(0);
            this.updateMetadata();
            this.broadcastMetadata();
        }
        if (this.mSleepTimer != null && this.mSleepTimer.isPaused()) {
            this.mSleepTimer.resume();
        }
    }

    @MainThread
    public void stopPlayback() {
        if (this.mMediaSession != null) {
            this.mMediaSession.setActive(false);
            this.mMediaSession.release();
            this.mMediaSession = null;
        }
        if (this.mMediaPlayer == null) {
            return;
        }
        this.savePosition();
        Media media = this.mMediaPlayer.getMedia();
        if (media != null) {
            media.setEventListener(null);
            this.mMediaPlayer.setEventListener(null);
            this.mMediaPlayer.stop();
            this.mMediaPlayer.setMedia(null);
            media.release();
        }
        this.mMediaList.removeEventListener(this.mListEventListener);
        this.mCurrentIndex = -1;
        this.mPrevious.clear();
        this.mHandler.removeMessages(0);
        this.hideNotification();
        this.broadcastMetadata();
        this.executeUpdate();
        this.executeUpdateProgress();
        this.changeAudioFocus(false);
        this.cancelSleepTimer();
    }

    @MainThread
    public void stopService() {
        this.removeAllCallbacks();
        this.stopForeground(true);
        this.stopPlayback();
        this.stopSelf();
    }

    private void determinePrevAndNextIndices() {
        this.determinePrevAndNextIndices(false);
    }

    private void determinePrevAndNextIndices(boolean expand) {
        if (expand) {
            this.mExpanding.set(true);
            this.mNextIndex = this.expand();
            this.mExpanding.set(false);
        } else {
            this.mNextIndex = -1;
        }
        this.mPrevIndex = -1;
        if (this.mNextIndex == -1) {
            int size = this.mMediaList.size();
            this.mShuffling &= size > 2;
            if (this.mRepeating == 1) {
                this.mPrevIndex = this.mNextIndex = this.mCurrentIndex;
            } else if (this.mShuffling) {
                if (this.mPrevious.size() > 0) {
                    this.mPrevIndex = this.mPrevious.peek();
                }
                if (this.mPrevious.size() + 1 == size) {
                    if (this.mRepeating == 0) {
                        this.mNextIndex = -1;
                        return;
                    }
                    this.mPrevious.clear();
                    this.mRandom = new Random(System.currentTimeMillis());
                }
                if (this.mRandom == null) {
                    this.mRandom = new Random(System.currentTimeMillis());
                }
                do {
                    this.mNextIndex = this.mRandom.nextInt(size);
                } while (this.mNextIndex == this.mCurrentIndex || this.mPrevious.contains(this.mNextIndex));
            } else {
                if (this.mCurrentIndex > 0) {
                    this.mPrevIndex = this.mCurrentIndex - 1;
                }
                this.mNextIndex = this.mCurrentIndex + 1 < size ? this.mCurrentIndex + 1 : (this.mRepeating == 0 ? -1 : 0);
            }
        }
    }

    private void initMediaSession() {
        ComponentName mediaButtonEventReceiver = new ComponentName((Context)this, RemoteControlEventReceiver.class);
        this.mSessionCallback = new MediaSessionCallback();
        this.mMediaSession = new MediaSessionCompat((Context)this, "VLCWrapper", mediaButtonEventReceiver, null);
        this.mMediaSession.setFlags(3);
        this.mMediaSession.setCallback((MediaSessionCompat.Callback)this.mSessionCallback);
        try {
            this.mMediaSession.setActive(true);
        }
        catch (NullPointerException e) {
            this.mMediaSession.setActive(false);
            this.mMediaSession.setFlags(2);
            this.mMediaSession.setActive(true);
        }
    }

    public MediaSessionCompat.Token getSessionToken() {
        if (this.mMediaSession == null) {
            this.initMediaSession();
        }
        return this.mMediaSession.getSessionToken();
    }

    protected void updateMetadata() {
        String title;
        MediaWrapper media = this.getCurrentMedia();
        if (media == null) {
            return;
        }
        if (this.mMediaSession == null) {
            this.initMediaSession();
        }
        if ((title = media.getNowPlaying()) == null) {
            title = media.getTitle();
        }
        MediaMetadataCompat.Builder bob = new MediaMetadataCompat.Builder();
        bob.putString("android.media.metadata.TITLE", title).putString("android.media.metadata.GENRE", Utils.getMediaGenre(media)).putLong("android.media.metadata.TRACK_NUMBER", (long)media.getTrackNumber()).putString("android.media.metadata.ARTIST", Utils.getMediaArtist(media)).putString("android.media.metadata.ALBUM_ARTIST", Utils.getMediaReferenceArtist(media)).putString("android.media.metadata.ALBUM", Utils.getMediaAlbum(media)).putString("android.media.metadata.ART_URI", media.getArtworkURL()).putLong("android.media.metadata.DURATION", media.getLength());
        this.mMediaSession.setMetadata(bob.build());
    }

    protected void publishState(int state) {
        if (this.mMediaSession == null) {
            return;
        }
        PlaybackStateCompat.Builder bob = new PlaybackStateCompat.Builder();
        bob.setActions(55L);
        switch (state) {
            case 260: {
                bob.setState(3, (long)this.getCurrentMediaPosition(), this.getRate());
                break;
            }
            case 262: {
                bob.setState(1, (long)this.getCurrentMediaPosition(), this.getRate());
                break;
            }
            default: {
                bob.setState(2, (long)this.getCurrentMediaPosition(), this.getRate());
            }
        }
        PlaybackStateCompat pbState = bob.build();
        this.mMediaSession.setPlaybackState(pbState);
        this.mMediaSession.setActive(state != 1);
    }

    private void notifyTrackChanged() {
        this.mHandler.sendEmptyMessage(0);
        this.updateMetadata();
        this.broadcastMetadata();
    }

    private void onMediaChanged() {
        this.notifyTrackChanged();
        this.saveCurrentMedia();
        this.determinePrevAndNextIndices();
    }

    private void onMediaListChanged() {
        this.saveMediaList();
        this.determinePrevAndNextIndices();
        this.executeUpdate();
    }

    @MainThread
    public void next() {
        int size = this.mMediaList.size();
        this.mPrevious.push(this.mCurrentIndex);
        this.mCurrentIndex = this.mNextIndex;
        if (size == 0 || this.mCurrentIndex < 0 || this.mCurrentIndex >= size) {
            if (this.mCurrentIndex < 0) {
                this.saveCurrentMedia();
            }
            Log.w((String)TAG, (String)"Warning: invalid next index, aborted !");
            this.stopService();
            return;
        }
        this.playIndex(this.mCurrentIndex, 0);
        this.saveCurrentMedia();
    }

    @MainThread
    public void previous() {
        int size = this.mMediaList.size();
        if (this.hasPrevious() && this.mCurrentIndex > 0 && (!this.mMediaPlayer.isSeekable() || this.mMediaPlayer.getTime() < 5000L)) {
            this.mCurrentIndex = this.mPrevIndex;
            if (this.mPrevious.size() > 0) {
                this.mPrevious.pop();
            }
            if (size == 0 || this.mPrevIndex < 0 || this.mCurrentIndex >= size) {
                Log.w((String)TAG, (String)"Warning: invalid previous index, aborted !");
                this.stopService();
                return;
            }
        } else {
            this.setPosition(0.0f);
        }
        this.playIndex(this.mCurrentIndex, 0);
        this.saveCurrentMedia();
    }

    @MainThread
    public void shuffle() {
        if (this.mShuffling) {
            this.mPrevious.clear();
        }
        this.mShuffling = !this.mShuffling;
        this.savePosition();
        this.determinePrevAndNextIndices();
    }

    @MainThread
    public void setRepeatType(int repeatType) {
        this.mRepeating = repeatType;
        this.savePosition();
        this.determinePrevAndNextIndices();
    }

    private void broadcastMetadata() {
        MediaWrapper media = this.getCurrentMedia();
        if (media == null || media.getType() != 1) {
            return;
        }
        boolean playing = this.mMediaPlayer.isPlaying();
        Intent broadcast = new Intent("com.android.music.metachanged");
        broadcast.putExtra("track", media.getTitle());
        broadcast.putExtra("artist", media.getArtist());
        broadcast.putExtra("album", media.getAlbum());
        broadcast.putExtra("duration", media.getLength());
        broadcast.putExtra("playing", playing);
        this.sendBroadcast(broadcast);
    }

    public synchronized void loadLastPlaylist(int type) {
        long time;
        boolean audio = type == 0;
        String currentMedia = this.mSettings.getString(audio ? "current_song" : "current_media", "");
        if (currentMedia.equals("")) {
            return;
        }
        String[] locations = this.mSettings.getString(audio ? "audio_list" : "media_list", "").split(" ");
        if (locations.length == 0) {
            return;
        }
        ArrayList<String> mediaPathList = new ArrayList<String>(locations.length);
        for (int i = 0; i < locations.length; ++i) {
            mediaPathList.add(Uri.decode((String)locations[i]));
        }
        this.mShuffling = this.mSettings.getBoolean(audio ? "audio_shuffling" : "media_shuffling", false);
        this.mRepeating = this.mSettings.getInt(audio ? "audio_repeating" : "media_repeating", 0);
        int position = this.mSettings.getInt(audio ? "position_in_audio_list" : "position_in_media_list", Math.max(0, mediaPathList.indexOf(currentMedia)));
        this.mSavedTime = time = this.mSettings.getLong(audio ? "position_in_song" : "position_in_media", -1L);
        this.loadLocations(mediaPathList);
        if (time > 0L) {
            this.setTime(time);
        }
        SharedPreferences.Editor editor = this.mSettings.edit();
        editor.putInt(audio ? "position_in_audio_list" : "position_in_media_list", 0);
        editor.putLong(audio ? "position_in_song" : "position_in_media", 0L);
        editor.apply();
    }

    private synchronized void saveCurrentMedia() {
        boolean audio = true;
        for (int i = 0; i < this.mMediaList.size(); ++i) {
            if (this.mMediaList.getMedia(i).getType() != 0) continue;
            audio = false;
        }
        SharedPreferences.Editor editor = this.mSettings.edit();
        editor.putString(audio ? "current_song" : "current_media", this.mMediaList.getMRL(Math.max(this.mCurrentIndex, 0)));
        editor.apply();
    }

    private synchronized void saveMediaList() {
        if (this.getCurrentMedia() == null) {
            return;
        }
        StringBuilder locations = new StringBuilder();
        boolean audio = true;
        for (int i = 0; i < this.mMediaList.size(); ++i) {
            if (this.mMediaList.getMedia(i).getType() == 0) {
                audio = false;
            }
            locations.append(" ").append(Uri.encode((String)this.mMediaList.getMRL(i)));
        }
        SharedPreferences.Editor editor = this.mSettings.edit();
        editor.putString(audio ? "audio_list" : "media_list", locations.toString().trim());
        editor.apply();
    }

    private synchronized void savePosition() {
        if (this.getCurrentMedia() == null) {
            return;
        }
        SharedPreferences.Editor editor = this.mSettings.edit();
        boolean audio = true;
        for (int i = 0; i < this.mMediaList.size(); ++i) {
            if (this.mMediaList.getMedia(i).getType() != 0) continue;
            audio = false;
        }
        editor.putBoolean(audio ? "audio_shuffling" : "media_shuffling", this.mShuffling);
        editor.putInt(audio ? "audio_repeating" : "media_repeating", this.mRepeating);
        editor.putInt(audio ? "position_in_audio_list" : "position_in_media_list", this.mCurrentIndex);
        editor.putLong(audio ? "position_in_song" : "position_in_media", this.mMediaPlayer.getTime());
        editor.apply();
    }

    private boolean validateLocation(String location) {
        if (!location.matches("\\w+://.+")) {
            location = "file://".concat(location);
        }
        if (location.toLowerCase(Locale.ENGLISH).startsWith("file://")) {
            File f;
            try {
                f = new File(new URI(location));
            }
            catch (URISyntaxException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            if (!f.isFile()) {
                return false;
            }
        }
        return true;
    }

    @MainThread
    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    @MainThread
    public boolean isSeekable() {
        return this.mSeekable;
    }

    @MainThread
    public boolean isPausable() {
        return this.mPausable;
    }

    @MainThread
    public boolean isShuffling() {
        return this.mShuffling;
    }

    @MainThread
    public boolean canShuffle() {
        return this.getMediaListSize() > 2;
    }

    @MainThread
    public int getRepeatType() {
        return this.mRepeating;
    }

    @MainThread
    public boolean hasMedia() {
        return this.hasCurrentMedia();
    }

    @MainThread
    public boolean hasPlaylist() {
        return this.getMediaListSize() > 1;
    }

    @MainThread
    public String getAlbum() {
        if (this.hasCurrentMedia()) {
            return Utils.getMediaAlbum(this.getCurrentMedia());
        }
        return null;
    }

    @MainThread
    public String getArtist() {
        if (this.hasCurrentMedia()) {
            MediaWrapper media = this.getCurrentMedia();
            return media.getNowPlaying() != null ? media.getTitle() : Utils.getMediaArtist(media);
        }
        return null;
    }

    @MainThread
    public String getArtistPrev() {
        if (this.mPrevIndex != -1) {
            return Utils.getMediaArtist(this.mMediaList.getMedia(this.mPrevIndex));
        }
        return null;
    }

    @MainThread
    public String getArtistNext() {
        if (this.mNextIndex != -1) {
            return Utils.getMediaArtist(this.mMediaList.getMedia(this.mNextIndex));
        }
        return null;
    }

    @MainThread
    public String getTitle() {
        if (this.hasCurrentMedia()) {
            return this.getCurrentMedia().getNowPlaying() != null ? this.getCurrentMedia().getNowPlaying() : this.getCurrentMedia().getTitle();
        }
        return null;
    }

    @MainThread
    public String getTitlePrev() {
        if (this.mPrevIndex != -1) {
            return this.mMediaList.getMedia(this.mPrevIndex).getTitle();
        }
        return null;
    }

    @MainThread
    public String getTitleNext() {
        if (this.mNextIndex != -1) {
            return this.mMediaList.getMedia(this.mNextIndex).getTitle();
        }
        return null;
    }

    @MainThread
    public synchronized void addCallback(PlaybackEventHandler handler) {
        if (!this.mPlaybackEventHandlers.contains(handler)) {
            this.mPlaybackEventHandlers.add(handler);
            if (this.hasCurrentMedia() && this.isPlaying()) {
                this.mHandler.sendEmptyMessage(0);
            }
        }
    }

    @MainThread
    public synchronized void removeCallback(PlaybackEventHandler handler) {
        this.mPlaybackEventHandlers.remove(handler);
    }

    @MainThread
    public synchronized void removeAllCallbacks() {
        this.mPlaybackEventHandlers.clear();
    }

    @MainThread
    public long getTime() {
        return this.mMediaPlayer.getTime();
    }

    @MainThread
    public long getLength() {
        return this.mMediaPlayer.getLength();
    }

    @MainThread
    public void loadLocations(List<String> mediaPathList) {
        ArrayList<MediaWrapper> mediaList = new ArrayList<MediaWrapper>();
        for (int i = 0; i < mediaPathList.size(); ++i) {
            String location = mediaPathList.get(i);
            MediaWrapper mediaWrapper = null;
            if (mediaWrapper == null) {
                if (!this.validateLocation(location)) {
                    Log.w((String)TAG, (String)("Invalid media location " + location));
                    continue;
                }
                Log.v((String)TAG, (String)("Creating on-the-fly Media object for " + location));
                mediaWrapper = new MediaWrapper(Uri.parse((String)location));
            }
            mediaList.add(mediaWrapper);
        }
        this.load(mediaList);
    }

    @MainThread
    public void loadUri(Uri uri) {
        String path = uri.toString();
        if (TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"content")) {
            path = "file://" + Utils.getPathFromURI(uri);
        }
        this.loadLocation(path);
    }

    @MainThread
    public void loadLocation(String mediaPath) {
        this.loadLocations(Collections.singletonList(mediaPath));
    }

    public void load(List<MediaWrapper> mediaList, String identifier) {
        this.load(mediaList);
        this.mMediaListIdentifier = identifier;
    }

    @MainThread
    public void load(List<MediaWrapper> mediaList) {
        Log.v((String)TAG, (String)("Loading medialist of size: " + mediaList.size()));
        if (this.hasCurrentMedia()) {
            this.savePosition();
        }
        this.mMediaList.removeEventListener(this.mListEventListener);
        this.mMediaList.clear();
        this.mMediaListIdentifier = null;
        MediaWrapperList currentMediaList = this.mMediaList;
        this.mPrevious.clear();
        for (int i = 0; i < mediaList.size(); ++i) {
            currentMediaList.add(mediaList.get(i));
        }
        if (this.mMediaList.size() == 0) {
            Log.w((String)TAG, (String)"Warning: empty media list, nothing to play !");
            return;
        }
        this.mMediaList.addEventListener(this.mListEventListener);
        this.saveMediaList();
    }

    @MainThread
    public void load(MediaWrapper media) {
        ArrayList<MediaWrapper> arrayList = new ArrayList<MediaWrapper>();
        arrayList.add(media);
        this.load(arrayList);
    }

    public void playIndex(int index, int flags) {
        if (this.mMediaList.size() == 0) {
            Log.w((String)TAG, (String)"Warning: empty media list, nothing to play !");
            return;
        }
        if (index >= 0 && index < this.mMediaList.size()) {
            this.mCurrentIndex = index;
        } else {
            Log.w((String)TAG, (String)("Warning: index " + index + " out of bounds"));
            this.mCurrentIndex = 0;
        }
        String mrl = this.mMediaList.getMRL(index);
        if (mrl == null) {
            return;
        }
        MediaWrapper mw = this.mMediaList.getMedia(index);
        if (mw == null) {
            return;
        }
        this.mParsed = false;
        this.mSeekable = true;
        this.mPausable = true;
        Media media = new Media(this.LibVLC(), mw.getUri());
        media.setEventListener(this.mMediaListener);
        this.mMediaPlayer.setMedia(media);
        media.release();
        this.mMediaPlayer.setVideoTitleDisplay(-1, 0);
        this.changeAudioFocus(true);
        this.mMediaPlayer.setEventListener(this.mMediaPlayerListener);
        this.mMediaPlayer.play();
        if (this.mSavedTime != 0L) {
            this.mMediaPlayer.setTime(this.mSavedTime);
        }
        this.mSavedTime = 0L;
        this.determinePrevAndNextIndices();
    }

    @MainThread
    public void playIndex(int index) {
        this.playIndex(index, 0);
    }

    @MainThread
    public void append(List<MediaWrapper> mediaList) {
        if (!this.hasCurrentMedia()) {
            this.load(mediaList);
            return;
        }
        for (int i = 0; i < mediaList.size(); ++i) {
            MediaWrapper mediaWrapper = mediaList.get(i);
            this.mMediaList.add(mediaWrapper);
        }
        this.onMediaListChanged();
    }

    @MainThread
    public void append(MediaWrapper media) {
        ArrayList<MediaWrapper> arrayList = new ArrayList<MediaWrapper>();
        arrayList.add(media);
        this.append(arrayList);
    }

    @MainThread
    public void moveItem(int positionStart, int positionEnd) {
        this.mMediaList.move(positionStart, positionEnd);
        this.saveMediaList();
    }

    @MainThread
    public void insertItem(int position, MediaWrapper mw) {
        this.mMediaList.insert(position, mw);
        this.saveMediaList();
        this.determinePrevAndNextIndices();
    }

    @MainThread
    public void remove(int position) {
        this.mMediaList.remove(position);
        this.saveMediaList();
        this.determinePrevAndNextIndices();
    }

    @MainThread
    public void removeLocation(String location) {
        this.mMediaList.remove(location);
        this.saveMediaList();
        this.determinePrevAndNextIndices();
    }

    public int getMediaListSize() {
        return this.mMediaList.size();
    }

    @MainThread
    public List<MediaWrapper> getMedias() {
        ArrayList<MediaWrapper> ml = new ArrayList<MediaWrapper>();
        for (int i = 0; i < this.mMediaList.size(); ++i) {
            ml.add(this.mMediaList.getMedia(i));
        }
        return ml;
    }

    @MainThread
    public List<String> getMediaLocations() {
        ArrayList<String> medias = new ArrayList<String>();
        for (int i = 0; i < this.mMediaList.size(); ++i) {
            medias.add(this.mMediaList.getMRL(i));
        }
        return medias;
    }

    @MainThread
    public String getCurrentMediaLocation() {
        return this.mMediaList.getMRL(this.mCurrentIndex);
    }

    @MainThread
    public int getCurrentMediaPosition() {
        return this.mCurrentIndex;
    }

    @MainThread
    public MediaWrapper getCurrentMediaWrapper() {
        return this.getCurrentMedia();
    }

    @MainThread
    public void setTime(long time) {
        if (this.mSeekable) {
            this.mMediaPlayer.setTime(time);
        }
    }

    @MainThread
    public boolean hasNext() {
        return this.mNextIndex != -1;
    }

    @MainThread
    public boolean hasPrevious() {
        return this.mPrevIndex != -1;
    }

    @MainThread
    public void detectHeadset(boolean enable) {
        this.mDetectHeadset = enable;
    }

    @MainThread
    public float getRate() {
        return this.mMediaPlayer.getRate();
    }

    @MainThread
    public void setRate(float rate) {
        this.mMediaPlayer.setRate(rate);
        this.executeUpdateProgress();
    }

    @MainThread
    public void navigate(int where) {
        this.mMediaPlayer.navigate(where);
    }

    @MainThread
    public MediaPlayer.Chapter[] getChapters(int title) {
        return this.mMediaPlayer.getChapters(title);
    }

    @MainThread
    public MediaPlayer.Title[] getTitles() {
        return this.mMediaPlayer.getTitles();
    }

    @MainThread
    public int getChapterIdx() {
        return this.mMediaPlayer.getChapter();
    }

    @MainThread
    public void setChapterIdx(int chapter) {
        this.mMediaPlayer.setChapter(chapter);
    }

    @MainThread
    public int getTitleIdx() {
        return this.mMediaPlayer.getTitle();
    }

    @MainThread
    public void setTitleIdx(int title) {
        this.mMediaPlayer.setTitle(title);
    }

    @MainThread
    public int getVolume() {
        return this.mMediaPlayer.getVolume();
    }

    @MainThread
    public int setVolume(int volume) {
        return this.mMediaPlayer.setVolume(volume);
    }

    @MainThread
    public void setPosition(float pos) {
        if (this.mSeekable) {
            this.mMediaPlayer.setPosition(pos);
        }
    }

    @MainThread
    public int getAudioTracksCount() {
        return this.mMediaPlayer.getAudioTracksCount();
    }

    @MainThread
    public MediaPlayer.TrackDescription[] getAudioTracks() {
        return this.mMediaPlayer.getAudioTracks();
    }

    @MainThread
    public int getAudioTrack() {
        return this.mMediaPlayer.getAudioTrack();
    }

    @MainThread
    public boolean setAudioTrack(int index) {
        return this.mMediaPlayer.setAudioTrack(index);
    }

    @MainThread
    public int getVideoTracksCount() {
        return this.mMediaPlayer.getVideoTracksCount();
    }

    @MainThread
    public boolean addSubtitleTrack(String path) {
        return this.mMediaPlayer.setSubtitleFile(path);
    }

    @MainThread
    public MediaPlayer.TrackDescription[] getSpuTracks() {
        return this.mMediaPlayer.getSpuTracks();
    }

    @MainThread
    public int getSpuTrack() {
        return this.mMediaPlayer.getSpuTrack();
    }

    @MainThread
    public boolean setSpuTrack(int index) {
        return this.mMediaPlayer.setSpuTrack(index);
    }

    @MainThread
    public int getSpuTracksCount() {
        return this.mMediaPlayer.getSpuTracksCount();
    }

    @MainThread
    public boolean setAudioDelay(long delay) {
        return this.mMediaPlayer.setAudioDelay(delay);
    }

    @MainThread
    public long getAudioDelay() {
        return this.mMediaPlayer.getAudioDelay();
    }

    @MainThread
    public boolean setSpuDelay(long delay) {
        return this.mMediaPlayer.setSpuDelay(delay);
    }

    @MainThread
    public long getSpuDelay() {
        return this.mMediaPlayer.getSpuDelay();
    }

    @MainThread
    public void setEqualizer(MediaPlayer.Equalizer equalizer) {
        this.mMediaPlayer.setEqualizer(equalizer);
    }

    @MainThread
    public void setMediaListIdentifier(String identifier) {
        this.mMediaListIdentifier = identifier;
    }

    @MainThread
    public String getMediaListIdentifier() {
        if (this.mMediaList == null || this.mMediaList.size() == 0) {
            return null;
        }
        if (this.mMediaListIdentifier != null) {
            return this.mMediaListIdentifier;
        }
        return Utils.getHashFromMediaList(this.mMediaList);
    }

    @MainThread
    public long getSleepTimerRemaining() {
        if (this.mSleepTimer != null && !this.mSleepTimer.isFinishedOrCancelled()) {
            return this.mSleepTimer.getMillisLeftUntilFinished();
        }
        return 0L;
    }

    @MainThread
    public void cancelSleepTimer() {
        if (this.mSleepTimer != null && !this.mSleepTimer.isFinishedOrCancelled()) {
            Log.d((String)TAG, (String)"SleepTimer cancelled");
            this.mSleepTimer.cancel();
            this.notifyEventHandlers(512);
        }
    }

    @MainThread
    public void pauseSleepTimer() {
        if (this.mSleepTimer != null && !this.mSleepTimer.isFinishedOrCancelled()) {
            this.mSleepTimer.pause();
        }
    }

    @MainThread
    public void resumeSleepTimer() {
        if (this.mSleepTimer != null && this.mSleepTimer.isPaused()) {
            this.mSleepTimer.resume();
        }
    }

    @MainThread
    public void setSleepTimer(long milliseconds) {
        this.cancelSleepTimer();
        this.mSleepTimer = new CountDownTimer(milliseconds, 1000L){

            @Override
            public void onTick(long millisUntilFinished) {
                PlaybackService.this.notifyEventHandlers(512);
            }

            @Override
            public void onFinish() {
                Log.d((String)TAG, (String)"SleepTimer reached - Fade volume & pause");
                if (PlaybackService.this.isPlaying()) {
                    new Thread(PlaybackService.this.mFadeOutAndPauseTask).start();
                }
                PlaybackService.this.notifyEventHandlers(512);
            }
        };
        this.mSleepTimer.start();
        this.notifyEventHandlers(512);
        if (!this.isPlaying()) {
            this.pauseSleepTimer();
        }
    }

    private void notifyEventHandlers(int eventType) {
        MediaPlayerEvent evt = new MediaPlayerEvent(eventType);
        for (PlaybackEventHandler handler : this.mPlaybackEventHandlers) {
            try {
                handler.onMediaPlayerEvent(evt);
            }
            catch (Exception ex) {
                Log.d((String)TAG, (String)("Error notifying PlaybackEventHandler.onMediaPlayerEvent: " + ex.getMessage()));
            }
        }
    }

    @MainThread
    public void setSleepTimerVolumeFadeDuration(int milliseconds) {
        this.mSleepTimerVolumeFadeDurationMillis = milliseconds;
    }

    @MainThread
    public int expand() {
        int ret;
        Media media = this.mMediaPlayer.getMedia();
        if (media == null) {
            return -1;
        }
        MediaList ml = media.subItems();
        media.release();
        if (ml.getCount() > 0) {
            this.mMediaList.remove(this.mCurrentIndex);
            for (int i = ml.getCount() - 1; i >= 0; --i) {
                Media child = ml.getMediaAt(i);
                child.parse();
                this.mMediaList.insert(this.mCurrentIndex, new MediaWrapper(child));
                child.release();
            }
            ret = 0;
        } else {
            ret = -1;
        }
        ml.release();
        return ret;
    }

    public void restartMediaPlayer() {
        this.stopService();
        this.mMediaPlayer.release();
        this.mMediaPlayer = this.newMediaPlayer();
    }

    public abstract class WeakHandler<T>
    extends Handler {
        private WeakReference<T> mOwner;

        public WeakHandler(T owner) {
            this.mOwner = new WeakReference<T>(owner);
        }

        public T getOwner() {
            return this.mOwner.get();
        }
    }

    private final class MediaSessionCallback
    extends MediaSessionCompat.Callback {
        private MediaSessionCallback() {
        }

        public void onPlay() {
            PlaybackService.this.play();
        }

        public void onPause() {
            PlaybackService.this.pause();
        }

        public void onStop() {
            PlaybackService.this.stopService();
        }

        public void onSkipToNext() {
            PlaybackService.this.next();
        }

        public void onSkipToPrevious() {
            PlaybackService.this.previous();
        }

        public void onSeekTo(long pos) {
            PlaybackService.this.setTime(pos);
        }

        public void onFastForward() {
            PlaybackService.this.next();
        }

        public void onRewind() {
            PlaybackService.this.previous();
        }
    }

    private class AudioServiceHandler
    extends WeakHandler<PlaybackService> {
        public AudioServiceHandler(PlaybackService fragment) {
            super(fragment);
        }

        public void handleMessage(Message msg) {
            PlaybackService service = (PlaybackService)((Object)this.getOwner());
            if (service == null) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    if (service.mPlaybackEventHandlers.size() <= 0) break;
                    this.removeMessages(0);
                    service.executeUpdateProgress();
                    this.sendEmptyMessageDelayed(0, 1000L);
                    break;
                }
                case 1: {
                    Bundle bundle = msg.getData();
                    String text = bundle.getString("text");
                    Toast.makeText((Context)PlaybackService.this.getApplicationContext(), (CharSequence)text, (int)1).show();
                }
            }
        }
    }

    private class LocalBinder
    extends Binder {
        private LocalBinder() {
        }

        PlaybackService getService() {
            return PlaybackService.this;
        }
    }
}

