/*
 * Decompiled with CFR 0.152.
 */
package dk.nota.lyt.libvlc.media;

import android.net.Uri;
import android.support.annotation.Nullable;
import dk.nota.lyt.libvlc.media.MediaWrapper;
import java.util.ArrayList;

public class MediaWrapperList {
    private static final String TAG = MediaWrapperList.class.getCanonicalName();
    private static final int EVENT_ADDED = 0;
    private static final int EVENT_REMOVED = 1;
    private static final int EVENT_MOVED = 2;
    private ArrayList<MediaWrapper> mInternalList;
    private ArrayList<EventListener> mEventListenerList = new ArrayList();

    public MediaWrapperList() {
        this.mInternalList = new ArrayList();
    }

    public void add(MediaWrapper media) {
        this.mInternalList.add(media);
    }

    public synchronized void addEventListener(EventListener listener) {
        if (!this.mEventListenerList.contains(listener)) {
            this.mEventListenerList.add(listener);
        }
    }

    public synchronized void removeEventListener(EventListener listener) {
        this.mEventListenerList.remove(listener);
    }

    private synchronized void signalEventListeners(int event, int arg1, int arg2, String mrl) {
        for (EventListener listener : this.mEventListenerList) {
            switch (event) {
                case 0: {
                    listener.onItemAdded(arg1, mrl);
                    break;
                }
                case 1: {
                    listener.onItemRemoved(arg1, mrl);
                    break;
                }
                case 2: {
                    listener.onItemMoved(arg1, arg2, mrl);
                }
            }
        }
    }

    public void clear() {
        for (int i = 0; i < this.mInternalList.size(); ++i) {
            this.signalEventListeners(1, i, -1, this.mInternalList.get(i).getLocation());
        }
        this.mInternalList.clear();
    }

    private boolean isValid(int position) {
        return position >= 0 && position < this.mInternalList.size();
    }

    public void insert(int position, Uri uri) {
        this.insert(position, new MediaWrapper(uri));
    }

    public void insert(int position, MediaWrapper media) {
        this.mInternalList.add(position, media);
        this.signalEventListeners(0, position, -1, media.getLocation());
    }

    public void move(int startPosition, int endPosition) {
        if (!this.isValid(startPosition) || endPosition < 0 || endPosition > this.mInternalList.size()) {
            throw new IndexOutOfBoundsException("Indexes out of range");
        }
        MediaWrapper toMove = this.mInternalList.get(startPosition);
        this.mInternalList.remove(startPosition);
        if (startPosition >= endPosition) {
            this.mInternalList.add(endPosition, toMove);
        } else {
            this.mInternalList.add(endPosition - 1, toMove);
        }
        this.signalEventListeners(2, startPosition, endPosition, toMove.getLocation());
    }

    public void remove(int position) {
        if (!this.isValid(position)) {
            return;
        }
        String uri = this.mInternalList.get(position).getLocation();
        this.mInternalList.remove(position);
        this.signalEventListeners(1, position, -1, uri);
    }

    public void remove(String location) {
        for (int i = 0; i < this.mInternalList.size(); ++i) {
            String uri = this.mInternalList.get(i).getLocation();
            if (!uri.equals(location)) continue;
            this.mInternalList.remove(i);
            this.signalEventListeners(1, i, -1, uri);
            --i;
        }
    }

    public int size() {
        return this.mInternalList.size();
    }

    @Nullable
    public MediaWrapper getMedia(int position) {
        if (!this.isValid(position)) {
            return null;
        }
        return this.mInternalList.get(position);
    }

    public String getMRL(int position) {
        if (!this.isValid(position)) {
            return null;
        }
        return this.mInternalList.get(position).getLocation();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LibVLC Media List: {");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(Integer.valueOf(i).toString());
            sb.append(": ");
            sb.append(this.getMRL(i));
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static interface EventListener {
        public void onItemAdded(int var1, String var2);

        public void onItemRemoved(int var1, String var2);

        public void onItemMoved(int var1, int var2, String var3);
    }
}

