/*
 * Decompiled with CFR 0.152.
 */
package dk.nota.lyt.libvlc;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.MainThread;
import dk.nota.lyt.libvlc.ConnectionCallback;
import dk.nota.lyt.libvlc.PlaybackService;

public class PlaybackServiceClient {
    public static final String TAG = PlaybackServiceClient.class.getCanonicalName();
    private boolean mBound = false;
    private final ConnectionCallback mConnectionCallback;
    private final Context mContext;
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder iBinder) {
            if (!PlaybackServiceClient.this.mBound) {
                return;
            }
            PlaybackService service = PlaybackService.getService(iBinder);
            if (service != null) {
                PlaybackServiceClient.this.mConnectionCallback.onConnected(service);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            PlaybackServiceClient.this.mBound = false;
            PlaybackServiceClient.this.mConnectionCallback.onDisconnected();
        }
    };

    private static Intent getServiceIntent(Context context) {
        return new Intent(context, PlaybackService.class);
    }

    private static void startService(Context context) {
        context.startService(PlaybackServiceClient.getServiceIntent(context));
    }

    private static void stopService(Context context) {
        context.stopService(PlaybackServiceClient.getServiceIntent(context));
    }

    public PlaybackServiceClient(Context context, ConnectionCallback connectionCallback) {
        if (context == null || connectionCallback == null) {
            throw new IllegalArgumentException("Context and connectionCallback can't be null");
        }
        this.mContext = context;
        this.mConnectionCallback = connectionCallback;
    }

    @MainThread
    public void connect() {
        if (this.mBound) {
            throw new IllegalStateException("already connected");
        }
        PlaybackServiceClient.startService(this.mContext);
        this.mBound = this.mContext.bindService(PlaybackServiceClient.getServiceIntent(this.mContext), this.mServiceConnection, 9);
    }

    @MainThread
    public void disconnect() {
        if (this.mBound) {
            this.mBound = false;
            this.mContext.unbindService(this.mServiceConnection);
        }
    }

    public static void restartService(Context context) {
        PlaybackServiceClient.stopService(context);
        PlaybackServiceClient.startService(context);
    }
}

