/*
 * Decompiled with CFR 0.152.
 */
package dk.nota.lyt.libvlc;

import android.content.Context;
import android.support.annotation.MainThread;
import dk.nota.lyt.libvlc.ConnectionCallback;
import dk.nota.lyt.libvlc.PlaybackService;
import dk.nota.lyt.libvlc.PlaybackServiceClient;
import java.util.ArrayList;

public class PlaybackServiceHelper {
    private ArrayList<ConnectionCallback> callbacks = new ArrayList();
    private PlaybackServiceClient mClient;
    protected PlaybackService mService;
    private final ConnectionCallback mClientCallback = new ConnectionCallback(){

        @Override
        public void onConnected(PlaybackService service) {
            PlaybackServiceHelper.this.mService = service;
            for (ConnectionCallback callback : PlaybackServiceHelper.this.callbacks) {
                callback.onConnected(PlaybackServiceHelper.this.mService);
            }
        }

        @Override
        public void onDisconnected() {
            PlaybackServiceHelper.this.mService = null;
            for (ConnectionCallback callback : PlaybackServiceHelper.this.callbacks) {
                callback.onDisconnected();
            }
        }
    };

    public PlaybackServiceHelper(Context context) {
        this.mClient = new PlaybackServiceClient(context, this.mClientCallback);
    }

    public PlaybackServiceHelper(Context context, ConnectionCallback callback) {
        this(context);
        this.registerConnectionCallback(callback);
    }

    @MainThread
    public void registerConnectionCallback(ConnectionCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.callbacks.add(callback);
        if (this.mService != null) {
            callback.onConnected(this.mService);
        }
    }

    @MainThread
    public void unregisterConnectionCallback(ConnectionCallback callback) {
        if (this.mService != null) {
            callback.onDisconnected();
        }
        this.callbacks.remove(callback);
    }

    @MainThread
    public void onStart() {
        this.mClient.connect();
    }

    @MainThread
    public void onStop() {
        this.mClientCallback.onDisconnected();
        this.mClient.disconnect();
    }
}

