/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.util;

import dev.yumi.gradle.licenser.YumiLicenserGradleExtension;
import dev.yumi.gradle.licenser.YumiLicenserGradlePlugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("Utils only contains static definitions.");
    }

    public static void debugLog(Project project, String message, Object ... params) {
        if (YumiLicenserGradlePlugin.DEBUG_MODE) {
            project.getLogger().lifecycle("[" + project.getPath() + "][Yumi Gradle Licenser] " + message, params);
        }
    }

    public static boolean matchCharAt(String source, int index, char expected) {
        return index >= 0 && index < source.length() && source.charAt(index) == expected;
    }

    public static boolean matchOtherCharAt(String source, int index, char unexpected) {
        return index >= 0 && index < source.length() && source.charAt(index) != unexpected;
    }

    public static int findInteger(@NotNull String source, @Range(from=0L, to=0x7FFFFFFFL) int start) {
        for (int i = start; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return i == start ? -1 : i;
        }
        return -1;
    }

    public static <T> void trimLines(@NotNull List<T> list, @NotNull Predicate<T> emptyPredicate) {
        Iterator<T> it = list.iterator();
        while (it.hasNext() && emptyPredicate.test(it.next())) {
            it.remove();
        }
        int toRemoveAtEnd = list.size();
        for (int i = toRemoveAtEnd - 1; i >= 0; --i) {
            if (emptyPredicate.test(list.get(i))) continue;
            toRemoveAtEnd = i + 1;
            break;
        }
        if (toRemoveAtEnd != list.size()) {
            list.subList(toRemoveAtEnd, list.size()).clear();
        }
    }

    @Nullable
    public static Path getBackupPath(Project project, Path rootPath, Path path) throws IOException {
        Path backupDir = ((File)project.getLayout().getBuildDirectory().getAsFile().get()).toPath().resolve("yumi/licenser");
        Files.createDirectories(backupDir, new FileAttribute[0]);
        String pathAsString = path.toAbsolutePath().toString();
        String rootPathAsString = rootPath.toString();
        if (pathAsString.startsWith(rootPathAsString)) {
            return backupDir.resolve(Paths.get(pathAsString.substring(rootPathAsString.length() + 1), new String[0])).normalize();
        }
        return null;
    }

    public static int getProjectCreationYear(Project project) {
        if (project.getRootProject() != project) {
            YumiLicenserGradleExtension ext = (YumiLicenserGradleExtension)project.getRootProject().getExtensions().findByType(YumiLicenserGradleExtension.class);
            if (ext != null && ext.getProjectCreationYear().isPresent()) {
                return (Integer)ext.getProjectCreationYear().get();
            }
            return Utils.getProjectCreationYear(project.getRootProject());
        }
        try {
            Instant instant = Files.readAttributes(project.getProjectDir().toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant();
            LocalDate localDate = LocalDate.ofInstant(instant, ZoneId.systemDefault());
            int localCreationYear = localDate.getYear();
            return localCreationYear;
        }
        catch (IOException e) {
            throw new GradleException("Could not read creation year of the root project directory.");
        }
    }
}

