/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GitUtils {
    private GitUtils() {
        throw new UnsupportedOperationException("GitUtils only contains static definitions.");
    }

    @NotNull
    private static String getStandardizedPath(@NotNull Path path) {
        String strValue = path.toString();
        if (!path.getFileSystem().getSeparator().equals("/")) {
            strValue = strValue.replace(path.getFileSystem().getSeparator(), "/");
        }
        return strValue;
    }

    private static Git openGit(Project project) throws IOException {
        return Git.open((File)project.getRootDir());
    }

    private static Path getRepoRoot(Git git) {
        return git.getRepository().getDirectory().toPath().getParent();
    }

    @Nullable
    private static AbstractTreeIterator prepareTreeParser(Repository repository, String ref) throws IOException {
        Ref head = repository.getRefDatabase().findRef(ref);
        if (head.getObjectId() == null) {
            return null;
        }
        RevWalk walk = new RevWalk(repository);
        RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
        RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
        CanonicalTreeParser oldTreeParser = new CanonicalTreeParser();
        try (ObjectReader oldReader = repository.newObjectReader();){
            oldTreeParser.reset(oldReader, (AnyObjectId)tree.getId());
        }
        return oldTreeParser;
    }

    @Nullable
    public static RevCommit getFirstCommit(@NotNull Git git) {
        RevWalk walker = new RevWalk(git.getRepository());
        RevCommit first = null;
        Iterator iterator = walker.iterator();
        while (iterator.hasNext()) {
            RevCommit commit;
            first = commit = (RevCommit)iterator.next();
        }
        return first;
    }

    @Nullable
    public static RevCommit getLatestCommit(@NotNull Git git, @NotNull Path path) {
        try {
            Iterator iterator;
            String pathStr = GitUtils.getStandardizedPath(path);
            LogCommand log = git.log();
            if (!pathStr.isEmpty()) {
                log.addPath(pathStr);
            }
            if (!(iterator = log.setMaxCount(1).call().iterator()).hasNext()) {
                return null;
            }
            return (RevCommit)iterator.next();
        }
        catch (GitAPIException e) {
            throw new GradleException(String.format("Failed to get commit hash of last commit of path %s", path), (Throwable)e);
        }
    }

    private static int getLatestCommitYear(Git git, Path path) {
        RevCommit latestCommit = GitUtils.getLatestCommit(git, path);
        if (latestCommit != null) {
            PersonIdent authorIdent = latestCommit.getAuthorIdent();
            Instant instant = authorIdent.getWhenAsInstant();
            TimeZone authorTimeZone = authorIdent.getTimeZone();
            return instant.atZone(authorTimeZone.toZoneId()).getYear();
        }
        return Calendar.getInstance().get(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getModificationYear(@NotNull Project project, @NotNull Path path) {
        try (Git git = GitUtils.openGit(project);){
            Path repoRoot = GitUtils.getRepoRoot(git);
            path = repoRoot.relativize(path);
            String pathString = GitUtils.getStandardizedPath(path);
            DiffFormatter formatter = new DiffFormatter((OutputStream)System.out);
            formatter.setRepository(git.getRepository());
            AbstractTreeIterator commitTreeIterator = GitUtils.prepareTreeParser(git.getRepository(), "HEAD");
            if (commitTreeIterator == null) {
                int n = GitUtils.getLatestCommitYear(git, path);
                return n;
            }
            FileTreeIterator workTreeIterator = new FileTreeIterator(git.getRepository());
            List diffEntries = formatter.scan(commitTreeIterator, (AbstractTreeIterator)workTreeIterator);
            for (DiffEntry entry : diffEntries) {
                if (!entry.getNewPath().equals(pathString)) continue;
                int n = Calendar.getInstance().get(1);
                return n;
            }
            int n = GitUtils.getLatestCommitYear(git, path);
            return n;
        }
        catch (IOException | GradleException throwable) {
            return Calendar.getInstance().get(1);
        }
    }
}

