/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.task;

import dev.yumi.gradle.licenser.api.comment.HeaderComment;
import dev.yumi.gradle.licenser.api.comment.HeaderCommentManager;
import dev.yumi.gradle.licenser.task.SourceConsumer;
import java.io.IOException;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class SourceDirectoryBasedTask
extends DefaultTask {
    protected final SourceDirectorySet sourceDirectorySet;
    protected final PatternFilterable patternFilterable;

    protected SourceDirectoryBasedTask(SourceDirectorySet sourceDirectorySet, PatternFilterable patternFilterable) {
        this.sourceDirectorySet = sourceDirectorySet;
        this.patternFilterable = patternFilterable;
    }

    void execute(HeaderCommentManager headerCommentManager, SourceConsumer consumer) {
        this.sourceDirectorySet.matching(this.patternFilterable).visit(fileVisitDetails -> {
            if (fileVisitDetails.isDirectory()) {
                return;
            }
            HeaderComment headerComment = headerCommentManager.findHeaderComment((FileTreeElement)fileVisitDetails);
            if (headerComment != null) {
                Path sourcePath = fileVisitDetails.getFile().toPath();
                try {
                    consumer.consume(this.getProject(), this.getLogger(), this.getProject().getProjectDir().toPath(), headerComment, sourcePath);
                }
                catch (IOException e) {
                    throw new GradleException("Failed to load file " + sourcePath, (Throwable)e);
                }
            }
        });
        consumer.end(this.getLogger());
    }
}

