/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.task;

import dev.yumi.gradle.licenser.YumiLicenserGradleExtension;
import dev.yumi.gradle.licenser.api.comment.HeaderComment;
import dev.yumi.gradle.licenser.api.comment.HeaderCommentManager;
import dev.yumi.gradle.licenser.impl.LicenseHeader;
import dev.yumi.gradle.licenser.impl.ValidationError;
import dev.yumi.gradle.licenser.task.SourceConsumer;
import dev.yumi.gradle.licenser.task.SourceDirectoryBasedTask;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CheckLicenseTask
extends SourceDirectoryBasedTask {
    private final LicenseHeader licenseHeader;
    private final HeaderCommentManager headerCommentManager;

    @Inject
    public CheckLicenseTask(SourceDirectorySet sourceDirectorySet, YumiLicenserGradleExtension extension) {
        super(sourceDirectorySet, extension.asPatternFilterable());
        this.licenseHeader = extension.getLicenseHeader();
        this.headerCommentManager = extension.getHeaderCommentManager();
        this.setDescription("Checks whether source files in the " + sourceDirectorySet.getName() + " source set contain a valid license header.");
        this.setGroup("verification");
        if (!this.licenseHeader.isValid()) {
            this.setEnabled(false);
        }
    }

    @TaskAction
    public void execute() {
        this.execute(this.headerCommentManager, new Consumer(this.licenseHeader));
    }

    static class Consumer
    implements SourceConsumer {
        private final LicenseHeader licenseHeader;
        private final List<FailedCheck> failedChecks = new ArrayList<FailedCheck>();
        private int total = 0;

        public Consumer(LicenseHeader licenseHeader) {
            this.licenseHeader = licenseHeader;
        }

        @Override
        public void consume(Project project, Logger logger, Path rootPath, HeaderComment headerComment, Path path) throws IOException {
            HeaderComment.Result result = headerComment.readHeaderComment(Files.readString(path));
            if (result.existing() == null) {
                this.failedChecks.add(new FailedCheck(path, List.of("Missing header comment.")));
            } else {
                List<ValidationError> errors = this.licenseHeader.validate(result.existing());
                if (!errors.isEmpty()) {
                    this.failedChecks.add(new FailedCheck(path, errors.stream().map(error -> error.headerRule() + ": " + error.error().getMessage()).toList()));
                }
            }
            ++this.total;
        }

        @Override
        public void end(Logger logger) {
            if (!this.failedChecks.isEmpty()) {
                for (FailedCheck failedCheck : this.failedChecks) {
                    logger.error(" - {} - license checks have failed.", (Object)failedCheck.path());
                    for (String error : failedCheck.errors()) {
                        logger.error("    -> {}", (Object)error);
                    }
                }
                throw new GradleException(String.format("License header checks have failed on %s out of %d files.", this.failedChecks.size(), this.total));
            }
            logger.lifecycle("All license header checks passed ({} files).", new Object[]{this.total});
        }
    }

    record FailedCheck(Path path, List<String> errors) {
    }
}

