/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.task;

import dev.yumi.gradle.licenser.YumiLicenserGradleExtension;
import dev.yumi.gradle.licenser.YumiLicenserGradlePlugin;
import dev.yumi.gradle.licenser.api.comment.HeaderComment;
import dev.yumi.gradle.licenser.api.comment.HeaderCommentManager;
import dev.yumi.gradle.licenser.impl.LicenseHeader;
import dev.yumi.gradle.licenser.task.SourceConsumer;
import dev.yumi.gradle.licenser.task.SourceDirectoryBasedTask;
import dev.yumi.gradle.licenser.util.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ApplyLicenseTask
extends SourceDirectoryBasedTask {
    private final LicenseHeader licenseHeader;
    private final HeaderCommentManager headerCommentManager;

    @Inject
    public ApplyLicenseTask(SourceDirectorySet sourceDirectorySet, YumiLicenserGradleExtension extension) {
        super(sourceDirectorySet, extension.asPatternFilterable());
        this.licenseHeader = extension.getLicenseHeader();
        this.headerCommentManager = extension.getHeaderCommentManager();
        this.setDescription("Applies the correct license headers to source files in the " + sourceDirectorySet.getName() + " source set.");
        this.setGroup("generation");
        if (!this.licenseHeader.isValid()) {
            this.setEnabled(false);
        }
    }

    @TaskAction
    public void execute() {
        this.execute(this.headerCommentManager, new Consumer(this.licenseHeader));
    }

    static class Consumer
    implements SourceConsumer {
        private final LicenseHeader licenseHeader;
        private final List<Path> updatedFiles = new ArrayList<Path>();
        private int total = 0;

        public Consumer(LicenseHeader licenseHeader) {
            this.licenseHeader = licenseHeader;
        }

        @Override
        public void consume(Project project, Logger logger, Path rootPath, HeaderComment headerComment, Path path) throws IOException {
            String read;
            HeaderComment.Result readComment;
            List<String> lines;
            if (YumiLicenserGradlePlugin.DEBUG_MODE) {
                logger.lifecycle("=> Visiting {}...", new Object[]{path});
            }
            if ((lines = this.licenseHeader.format(project, logger, path, (readComment = headerComment.readHeaderComment(read = Files.readString(path, StandardCharsets.UTF_8))).existing())) != null) {
                this.updatedFiles.add(path);
                String start = "";
                if (readComment.start() != 0 && (start = read.substring(0, readComment.start())).isBlank()) {
                    start = "";
                }
                Object end = read.substring(readComment.end());
                if (readComment.start() == readComment.end() && readComment.start() == 0) {
                    end = readComment.separator() + readComment.separator() + (String)end;
                }
                String content = start + headerComment.writeHeaderComment(lines, readComment.separator()) + (String)end;
                try {
                    Path backupPath = Utils.getBackupPath(project, rootPath, path);
                    if (backupPath == null) {
                        throw new GradleException("Cannot backup file " + path + ", abandoning formatting.");
                    }
                    if (!Files.isDirectory(backupPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(backupPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(path, backupPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new GradleException("Cannot backup file " + path + ", abandoning formatting.", (Throwable)e);
                }
                Files.writeString(path, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            ++this.total;
        }

        @Override
        public void end(Logger logger) {
            for (Path path : this.updatedFiles) {
                logger.lifecycle(" - Updated file {}", new Object[]{path});
            }
            logger.lifecycle("Updated {} out of {} files.", new Object[]{this.updatedFiles.size(), this.total});
        }
    }
}

