/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.impl;

import dev.yumi.gradle.licenser.YumiLicenserGradlePlugin;
import dev.yumi.gradle.licenser.api.rule.HeaderFileContext;
import dev.yumi.gradle.licenser.api.rule.HeaderRule;
import dev.yumi.gradle.licenser.impl.ValidationError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LicenseHeader {
    private final List<HeaderRule> rules;

    public LicenseHeader(HeaderRule ... rules) {
        this(new ArrayList<HeaderRule>(List.of(rules)));
    }

    public LicenseHeader(List<HeaderRule> rules) {
        this.rules = rules;
    }

    public boolean isValid() {
        return !this.rules.isEmpty();
    }

    public void addRule(HeaderRule rule) {
        this.rules.add(rule);
    }

    @NotNull
    public List<ValidationError> validate(@NotNull List<String> header) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (HeaderRule rule : this.rules) {
            HeaderRule.ParsedData result = rule.parseHeader(header);
            if (result.error() != null) {
                errors.add(new ValidationError(rule.getName(), result.error()));
                continue;
            }
            return List.of();
        }
        return errors;
    }

    @Nullable
    public List<String> format(Project project, Logger logger, Path path, @Nullable List<String> readComment) {
        List<String> newHeader = null;
        if (readComment == null) {
            if (YumiLicenserGradlePlugin.DEBUG_MODE) {
                logger.lifecycle("  => Could not find header. Using default rule.", new Object[]{path});
            }
            newHeader = this.format(project, path, this.rules.get(0), new HeaderRule.ParsedData(Map.of(), Collections.emptySet(), null));
        } else {
            HeaderRule.ParsedData first = null;
            for (HeaderRule rule : this.rules) {
                HeaderRule.ParsedData data = rule.parseHeader(readComment);
                if (data.error() == null) {
                    if (YumiLicenserGradlePlugin.DEBUG_MODE) {
                        logger.lifecycle("  => Found rule in lookup.", new Object[]{path});
                    }
                    newHeader = this.format(project, path, rule, data);
                    break;
                }
                if (first != null) continue;
                first = data;
            }
            if (newHeader == null) {
                if (YumiLicenserGradlePlugin.DEBUG_MODE) {
                    logger.lifecycle("  => Could not find rule in lookup. Using default rule.", new Object[]{path});
                }
                newHeader = this.format(project, path, this.rules.get(0), first);
            }
        }
        if (!newHeader.equals(readComment)) {
            return newHeader;
        }
        return null;
    }

    private List<String> format(Project project, Path path, HeaderRule rule, HeaderRule.ParsedData parsed) {
        try {
            int creationYear = rule.getYearSelectionMode().getCreationYear(project, path);
            int lastModifiedYear = rule.getYearSelectionMode().getModificationYear(project, path);
            HeaderFileContext context = new HeaderFileContext(path.getFileName().toString(), creationYear, lastModifiedYear);
            return rule.apply(parsed, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

