/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.compat;

import dev.yumi.gradle.licenser.YumiLicenserGradleExtension;
import dev.yumi.gradle.licenser.task.ApplyLicenseTask;
import dev.yumi.gradle.licenser.task.CheckLicenseTask;
import dev.yumi.gradle.licenser.util.Utils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class KotlinMultiplatformCompat {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private KotlinMultiplatformCompat() {
        throw new UnsupportedOperationException("KotlinMultiplatformCompat only contains static definitions.");
    }

    public static void applyTasksForKotlinMultiplatform(Project project, YumiLicenserGradleExtension ext) throws Throwable {
        Utils.debugLog(project, "Found Kotlin Multiplatform plugin, applying special configuration...", new Object[0]);
        Object kotlinExt = project.getExtensions().getByName("kotlin");
        MethodHandle getSourceSets = LOOKUP.unreflect(kotlinExt.getClass().getMethod("getSourceSets", new Class[0]));
        NamedDomainObjectContainer sourceSets = getSourceSets.invoke(kotlinExt);
        sourceSets.all(sourceSet -> {
            try {
                String name = LOOKUP.unreflect(sourceSet.getClass().getMethod("getName", new Class[0])).invoke(sourceSet);
                if (ext.isSourceSetExcluded(name)) {
                    return;
                }
                SourceDirectorySet kotlinSet = LOOKUP.unreflect(sourceSet.getClass().getMethod("getKotlin", new Class[0])).invoke(sourceSet);
                project.getTasks().register(KotlinMultiplatformCompat.getTaskName("check", name), CheckLicenseTask.class, new Object[]{kotlinSet, ext}).configure(task -> task.onlyIf(t -> !ext.isSourceSetExcluded(name)));
                project.getTasks().register(KotlinMultiplatformCompat.getTaskName("apply", name), ApplyLicenseTask.class, new Object[]{kotlinSet, ext}).configure(task -> task.onlyIf(t -> !ext.isSourceSetExcluded(name)));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static String getTaskName(String action, String sourceSetName) {
        return action + "License" + Character.toUpperCase(sourceSetName.charAt(0)) + (sourceSetName.length() > 1 ? sourceSetName.substring(1) : "");
    }
}

