/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.api.rule.variable;

import dev.yumi.gradle.licenser.api.rule.HeaderFileContext;
import dev.yumi.gradle.licenser.api.rule.variable.VariableType;
import dev.yumi.gradle.licenser.util.Utils;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YearListVariableType
implements VariableType<int[]> {
    public static final YearListVariableType INSTANCE = new YearListVariableType();

    @Override
    @NotNull
    public Optional<VariableType.ParseResult<int[]>> parseVar(@NotNull String input, int start) {
        int numberEnd;
        IntStream.Builder years = IntStream.builder();
        boolean foundOne = false;
        int totalEnd = -1;
        while ((numberEnd = Utils.findInteger(input, start)) != -1) {
            boolean foundNext;
            totalEnd = numberEnd;
            foundOne = true;
            years.add(Integer.parseInt(input.substring(start, numberEnd)));
            if (Utils.matchCharAt(input, numberEnd, ',') && Utils.matchCharAt(input, numberEnd + 1, ' ')) {
                start = numberEnd + 2;
                foundNext = true;
            } else {
                foundNext = false;
            }
            if (foundNext) continue;
        }
        if (!foundOne) {
            return Optional.empty();
        }
        return Optional.of(new VariableType.ParseResult<int[]>(years.build().sorted().toArray(), totalEnd));
    }

    @Override
    @NotNull
    public String getAsString(int @NotNull [] value) {
        return Arrays.stream(value).mapToObj(String::valueOf).collect(Collectors.joining(", "));
    }

    @Override
    public int @NotNull [] getUpToDate(@NotNull HeaderFileContext context, int @Nullable [] old) {
        int lastModified = context.lastModifiedYear();
        if (old != null) {
            int[] years = old;
            int lastKnown = years[years.length - 1];
            if (lastKnown < lastModified) {
                IntStream yearsStream = IntStream.of(years);
                IntStream newYears = IntStream.rangeClosed(lastKnown + 1, lastModified);
                years = IntStream.concat(yearsStream, newYears).distinct().sorted().toArray();
            }
            return years;
        }
        return IntStream.rangeClosed(context.creationYear(), lastModified).toArray();
    }
}

