/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.api.rule.variable;

import dev.yumi.gradle.licenser.api.rule.HeaderFileContext;
import dev.yumi.gradle.licenser.api.rule.variable.VariableType;
import dev.yumi.gradle.licenser.util.Utils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YearLenientRangeVariableType
implements VariableType<int[]> {
    public static final YearLenientRangeVariableType INSTANCE = new YearLenientRangeVariableType();

    @Override
    @NotNull
    public Optional<VariableType.ParseResult<int[]>> parseVar(@NotNull String input, int start) {
        int firstYearEnd = Utils.findInteger(input, start);
        if (firstYearEnd == -1) {
            return Optional.empty();
        }
        int secondYearEnd = -1;
        int secondYear = -1;
        if (Utils.matchCharAt(input, firstYearEnd, '-') && (secondYearEnd = Utils.findInteger(input, firstYearEnd + 1)) != -1) {
            secondYear = Integer.parseInt(input.substring(firstYearEnd + 1, secondYearEnd));
        }
        int[] years = new int[secondYear == -1 ? 1 : 2];
        years[0] = Integer.parseInt(input.substring(start, firstYearEnd));
        if (secondYear != -1) {
            years[1] = secondYear;
        }
        return Optional.of(new VariableType.ParseResult<int[]>(years, secondYear == -1 ? firstYearEnd : secondYearEnd));
    }

    @Override
    @NotNull
    public String getAsString(int @NotNull [] value) {
        String start = String.valueOf(value[0]);
        if (value.length > 1) {
            return start + "-" + value[1];
        }
        return start;
    }

    @Override
    public int @NotNull [] getUpToDate(@NotNull HeaderFileContext context, int @Nullable [] old) {
        int modifiedYear = context.lastModifiedYear();
        if (old != null) {
            int[] years = old;
            if (years.length > 1) {
                if (years[1] < modifiedYear) {
                    years[1] = modifiedYear;
                }
            } else if (years[0] < modifiedYear) {
                years = new int[]{years[0], modifiedYear};
            }
            return years;
        }
        int creationYear = context.creationYear();
        if (creationYear != modifiedYear) {
            return new int[]{creationYear, modifiedYear};
        }
        return new int[]{creationYear};
    }
}

