/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.api.rule;

import dev.yumi.gradle.licenser.YumiLicenserGradleExtension;
import dev.yumi.gradle.licenser.util.GitUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import org.gradle.api.Project;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public enum LicenseYearSelectionMode {
    PROJECT((project, path) -> project.getRootProject().getProjectDir().toPath()),
    FILE((project, path) -> path);

    private static final List<LicenseYearSelectionMode> VALUES;
    private final CommitPathReference commitPathReference;

    private LicenseYearSelectionMode(CommitPathReference commitPathReference) {
        this.commitPathReference = commitPathReference;
    }

    public int getCreationYear(@NotNull Project project, @NotNull Path path) throws IOException {
        Path commitPath = this.commitPathReference.getPathForCommitFetching(project, path);
        if (commitPath != path) {
            return (Integer)((YumiLicenserGradleExtension)project.getExtensions().getByType(YumiLicenserGradleExtension.class)).getProjectCreationYear().get();
        }
        Instant instant = Files.readAttributes(commitPath, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant();
        LocalDate localDate = LocalDate.ofInstant(instant, ZoneId.systemDefault());
        return localDate.getYear();
    }

    public int getModificationYear(@NotNull Project project, @NotNull Path path) {
        Path commitPath = this.commitPathReference.getPathForCommitFetching(project, path);
        return GitUtils.getModificationYear(project, commitPath);
    }

    @Contract(pure=true)
    public static LicenseYearSelectionMode byName(@NotNull String name) {
        for (LicenseYearSelectionMode mode : VALUES) {
            if (!mode.name().equals(name)) continue;
            return mode;
        }
        return null;
    }

    static {
        VALUES = List.of(LicenseYearSelectionMode.values());
    }

    @FunctionalInterface
    static interface CommitPathReference {
        @NotNull
        public Path getPathForCommitFetching(Project var1, Path var2);
    }
}

