/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.api.rule;

import dev.yumi.gradle.licenser.api.rule.HeaderFileContext;
import dev.yumi.gradle.licenser.api.rule.HeaderLine;
import dev.yumi.gradle.licenser.api.rule.HeaderParseException;
import dev.yumi.gradle.licenser.api.rule.LicenseYearSelectionMode;
import dev.yumi.gradle.licenser.api.rule.token.RuleToken;
import dev.yumi.gradle.licenser.api.rule.token.TextToken;
import dev.yumi.gradle.licenser.api.rule.token.VarToken;
import dev.yumi.gradle.licenser.api.rule.variable.VariableType;
import dev.yumi.gradle.licenser.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class HeaderRule {
    private final String name;
    private final List<HeaderLine> lines;
    private final Map<String, VariableType<?>> variables;
    private final LicenseYearSelectionMode yearSelectionMode;

    public HeaderRule(@NotNull String name, @NotNull List<HeaderLine> lines, @NotNull Map<String, VariableType<?>> variables, @NotNull LicenseYearSelectionMode yearSelectionMode) {
        this.name = name;
        this.lines = lines;
        this.variables = variables;
        this.yearSelectionMode = yearSelectionMode;
    }

    @Contract(pure=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Contract(pure=true)
    public @UnmodifiableView @NotNull List<HeaderLine> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    @Contract(pure=true)
    @NotNull
    public LicenseYearSelectionMode getYearSelectionMode() {
        return this.yearSelectionMode;
    }

    @NotNull
    public ParsedData parseHeader(@NotNull List<String> header) {
        HashMap<String, Object> variableValues = new HashMap<String, Object>();
        HashSet<Integer> presentOptionalLines = new HashSet<Integer>();
        int ruleLineIndex = 0;
        for (int headerLineIndex = 0; headerLineIndex < header.size(); ++headerLineIndex) {
            String error;
            String headerLine = header.get(headerLineIndex);
            if (ruleLineIndex >= this.lines.size()) {
                return new ParsedData(variableValues, presentOptionalLines, new HeaderParseException(headerLineIndex, "There is unexpected extra header lines."));
            }
            HeaderLine ruleLine = this.lines.get(ruleLineIndex);
            while ((error = this.parseLine(headerLine, ruleLine, variableValues)) != null) {
                if (ruleLine.optional()) {
                    ruleLine = this.lines.get(++ruleLineIndex);
                    continue;
                }
                return new ParsedData(variableValues, presentOptionalLines, new HeaderParseException(headerLineIndex, error));
            }
            if (ruleLine.optional()) {
                presentOptionalLines.add(ruleLineIndex);
            }
            ++ruleLineIndex;
        }
        return new ParsedData(variableValues, presentOptionalLines, null);
    }

    @Nullable
    private String parseLine(@NotNull String headerLine, @NotNull HeaderLine currentLine, @NotNull Map<String, Object> variablesMap) {
        int currentIndex = 0;
        for (RuleToken token : currentLine.tokens()) {
            if (token instanceof TextToken) {
                TextToken textToken = (TextToken)token;
                String text = textToken.content();
                int theoreticalEnd = currentIndex + text.length();
                if (theoreticalEnd > headerLine.length()) {
                    return "Header is cut short, stopped at " + headerLine.length() + " instead of " + theoreticalEnd + ".";
                }
                String toCheck = headerLine.substring(currentIndex, theoreticalEnd);
                if (!text.equals(toCheck)) {
                    return "Text differs at " + currentIndex + ", got \"" + toCheck + "\", expected \"" + text + "\".";
                }
                currentIndex += text.length();
                continue;
            }
            if (!(token instanceof VarToken)) continue;
            VarToken varToken = (VarToken)token;
            VariableType<?> type = this.variables.get(varToken.variable());
            Optional<VariableType.ParseResult<?>> result = type.parseVar(headerLine, currentIndex);
            if (result.isEmpty()) {
                return "Failed to parse variable \"" + varToken.variable() + "\" at " + currentIndex + ".";
            }
            Object old = variablesMap.put(varToken.variable(), result.get().data());
            if (old != null && !old.equals(result.get().data())) {
                return "Diverging variable values for \"" + varToken.variable() + "\".";
            }
            currentIndex = result.get().end();
        }
        return null;
    }

    @NotNull
    public List<String> apply(@NotNull ParsedData data, @NotNull HeaderFileContext context) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.lines.size(); ++i) {
            HeaderLine line = this.lines.get(i);
            if (line.optional() && !data.presentOptionalLines.contains(i)) continue;
            StringBuilder builder = new StringBuilder();
            for (RuleToken token : line.tokens()) {
                if (token instanceof TextToken) {
                    TextToken textToken = (TextToken)token;
                    builder.append(textToken.content());
                    continue;
                }
                if (!(token instanceof VarToken)) continue;
                VarToken varToken = (VarToken)token;
                VariableType<?> type = this.variables.get(varToken.variable());
                Object previous = data.variables.get(varToken.variable());
                Object newValue = type.getUpToDate(context, previous);
                builder.append(type.getAsString(newValue));
            }
            result.add(builder.toString());
        }
        Utils.trimLines(result, String::isEmpty);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeaderRule that = (HeaderRule)o;
        return Objects.equals(this.lines, that.lines);
    }

    public int hashCode() {
        return Objects.hash(this.lines);
    }

    public String toString() {
        return "HeaderRule{lines=" + this.lines + "}";
    }

    @NotNull
    public static HeaderRule parse(@NotNull String name, @NotNull List<String> raw) throws HeaderParseException {
        ArrayList<HeaderLine> parsed = new ArrayList<HeaderLine>();
        HashMap variables = new HashMap();
        LicenseYearSelectionMode yearSelectionMode = LicenseYearSelectionMode.PROJECT;
        boolean optionalMode = false;
        for (int i = 0; i < raw.size(); ++i) {
            String line = raw.get(i);
            if (line.startsWith("#")) {
                String[] instruction = line.substring(1).trim().split("\\s+");
                if (instruction.length == 0) {
                    throw new HeaderParseException(i, "No valid instructions could be found.");
                }
                switch (instruction[0]) {
                    case "optional": {
                        optionalMode = true;
                        break;
                    }
                    case "end": {
                        optionalMode = false;
                        break;
                    }
                    case "type": {
                        if (instruction.length != 3) {
                            throw new HeaderParseException(i, "Invalid type instruction. Expected variable name and type.");
                        }
                        String variableName = instruction[1];
                        String variableTypeRaw = instruction[2];
                        VariableType<?> variableType = VariableType.TYPES.get(variableTypeRaw);
                        if (variableType == null) {
                            throw new HeaderParseException(i, "Invalid variable type \"" + variableTypeRaw + "\" for variable \"" + variableName + "\".");
                        }
                        variables.put(variableName, variableType);
                        break;
                    }
                    case "year_selection": {
                        if (instruction.length != 2) {
                            throw new HeaderParseException(i, "Invalid year selection instruction. Expected selection mode (project or file).");
                        }
                        String modeName = instruction[1];
                        LicenseYearSelectionMode mode = LicenseYearSelectionMode.byName(modeName.toUpperCase());
                        if (mode == null) {
                            throw new HeaderParseException(i, "Invalid year selection mode \"" + modeName + "\".");
                        }
                        yearSelectionMode = mode;
                        break;
                    }
                    default: {
                        throw new HeaderParseException(i, "Unknown instruction: \"" + instruction[0] + "\".");
                    }
                }
                continue;
            }
            parsed.add(HeaderRule.parseLine(line, optionalMode));
        }
        Utils.trimLines(parsed, HeaderLine::isEmpty);
        variables.putAll(VariableType.DEFAULT_VARIABLES);
        HashSet<String> undeclaredVariables = new HashSet<String>();
        for (HeaderLine line : parsed) {
            for (RuleToken token : line.tokens()) {
                VarToken varToken;
                if (!(token instanceof VarToken) || variables.containsKey((varToken = (VarToken)token).variable())) continue;
                undeclaredVariables.add(varToken.variable());
            }
        }
        if (!undeclaredVariables.isEmpty()) {
            throw new HeaderParseException(0, "Undeclared variables found: " + String.join((CharSequence)", ", undeclaredVariables) + ".");
        }
        return new HeaderRule(name, parsed, variables, yearSelectionMode);
    }

    @NotNull
    private static HeaderLine parseLine(@NotNull String line, boolean optional) {
        ArrayList<RuleToken> tokens = new ArrayList<RuleToken>();
        int lastLandmark = 0;
        boolean backslash = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '$' && !backslash && Utils.matchCharAt(line, i + 1, '{')) {
                String variable = HeaderRule.readVar(line, i + 2);
                if (variable == null) continue;
                if (lastLandmark != i) {
                    tokens.add(new TextToken(line.substring(lastLandmark, i)));
                }
                tokens.add(new VarToken(variable));
                lastLandmark = (i += variable.length() + 2) + 1;
                continue;
            }
            backslash = c == '\\' ? !backslash : false;
        }
        if (lastLandmark < line.length()) {
            tokens.add(new TextToken(line.substring(lastLandmark)));
        }
        return new HeaderLine(tokens, optional);
    }

    @Nullable
    private static String readVar(@NotNull String line, int start) {
        int end = start;
        for (int i = start; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '_' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            if (c == '}') {
                end = i;
                break;
            }
            return null;
        }
        if (end != start) {
            return line.substring(start, end);
        }
        return null;
    }

    public record ParsedData(Map<String, ?> variables, Set<Integer> presentOptionalLines, @Nullable HeaderParseException error) {
    }
}

