/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.api.comment;

import dev.yumi.gradle.licenser.api.comment.CStyleHeaderComment;
import dev.yumi.gradle.licenser.api.comment.HeaderComment;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaderCommentManager {
    private final Map<PatternSet, HeaderComment> headers = new HashMap<PatternSet, HeaderComment>();

    public HeaderCommentManager() {
        this.register(new PatternSet().include(new String[]{"**/*.c", "**/*.cpp", "**/*.cxx", "**/*.h", "**/*.hpp", "**/*.hxx", "**/*.java", "**/*.kt", "**/*.kts", "**/*.scala"}), CStyleHeaderComment.INSTANCE);
    }

    public void register(@NotNull PatternSet filePattern, @NotNull HeaderComment headerComment) {
        this.headers.put(filePattern, headerComment);
    }

    @Nullable
    public HeaderComment findHeaderComment(@NotNull FileTreeElement file) {
        for (Map.Entry<PatternSet, HeaderComment> entry : this.headers.entrySet()) {
            if (!entry.getKey().getAsSpec().isSatisfiedBy((Object)file)) continue;
            return entry.getValue();
        }
        return null;
    }
}

