/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser.api.comment;

import dev.yumi.gradle.licenser.api.comment.HeaderComment;
import dev.yumi.gradle.licenser.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CStyleHeaderComment
implements HeaderComment {
    public static final CStyleHeaderComment INSTANCE = new CStyleHeaderComment();

    @Override
    @NotNull
    public HeaderComment.Result readHeaderComment(@NotNull String source) {
        int end;
        int start = 0;
        String found = null;
        for (end = 0; end < source.length(); ++end) {
            char c = source.charAt(end);
            if (c == '/') {
                if (!Utils.matchCharAt(source, end + 1, '*') || !Utils.matchOtherCharAt(source, end + 2, '*')) break;
                start = end;
                int j = end + 2;
                while (j < source.length()) {
                    if ((j = source.indexOf(42, j + 1)) == -1) {
                        found = source.substring(end + 2);
                        break;
                    }
                    if (j + 1 == source.length()) {
                        found = source.substring(end + 2);
                        end = j;
                        break;
                    }
                    if (source.charAt(j + 1) != '/') continue;
                    found = source.substring(end + 2, j - 1);
                    end = j + 2;
                    break;
                }
                if (found == null) continue;
                break;
            }
            if (!Character.isWhitespace(c)) break;
        }
        String separator = this.extractLineSeparator(source);
        ArrayList<String> result = null;
        if (found != null) {
            String[] lines = found.split("\r?\n( ?\\* ?)?");
            lines[0] = lines[0].stripLeading();
            result = new ArrayList<String>(List.of(lines));
            if (((String)result.get(0)).isBlank()) {
                result.remove(0);
            }
        }
        return new HeaderComment.Result(start, end, result, separator);
    }

    @Override
    @NotNull
    public String writeHeaderComment(List<String> header, String separator) {
        StringBuilder builder = new StringBuilder("/*").append(separator);
        for (String line : header) {
            if (line.isBlank()) {
                builder.append(" *").append(separator);
                continue;
            }
            builder.append(" * ").append(line).append(separator);
        }
        return builder + " */";
    }
}

