/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser;

import dev.yumi.gradle.licenser.YumiLicenserGradleExtension;
import dev.yumi.gradle.licenser.compat.KotlinMultiplatformCompat;
import dev.yumi.gradle.licenser.task.ApplyLicenseTask;
import dev.yumi.gradle.licenser.task.CheckLicenseTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public class YumiLicenserGradlePlugin
implements Plugin<Project> {
    public static final String LICENSE_TASK_SUFFIX = "License";
    public static final String CHECK_TASK_PREFIX = "check";
    public static final String APPLY_TASK_PREFIX = "apply";
    private static final String DEBUG_MODE_PROPERTY = "yumi.gradle.licenser.debug";
    public static final boolean DEBUG_MODE = Boolean.getBoolean("yumi.gradle.licenser.debug");

    public void apply(Project project) {
        YumiLicenserGradleExtension ext = (YumiLicenserGradleExtension)project.getExtensions().create("license", YumiLicenserGradleExtension.class, new Object[]{project});
        project.getPlugins().withType(JavaBasePlugin.class).configureEach(plugin -> {
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            sourceSets.matching(sourceSet -> !ext.isSourceSetExcluded((SourceSet)sourceSet)).all(sourceSet -> {
                project.getTasks().register(YumiLicenserGradlePlugin.getTaskName(CHECK_TASK_PREFIX, sourceSet), CheckLicenseTask.class, new Object[]{sourceSet.getAllSource(), ext}).configure(task -> task.onlyIf(t -> !ext.isSourceSetExcluded((SourceSet)sourceSet)));
                project.getTasks().register(YumiLicenserGradlePlugin.getTaskName(APPLY_TASK_PREFIX, sourceSet), ApplyLicenseTask.class, new Object[]{sourceSet.getAllSource(), ext}).configure(task -> task.onlyIf(t -> !ext.isSourceSetExcluded((SourceSet)sourceSet)));
            });
        });
        project.getPlugins().withId("org.jetbrains.kotlin.multiplatform", plugin -> {
            try {
                KotlinMultiplatformCompat.applyTasksForKotlinMultiplatform(project, ext);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        TaskProvider<Task> globalCheck = this.registerGroupedTask(project, CHECK_TASK_PREFIX, (Action<Task>)((Action)task -> {
            task.dependsOn(new Object[]{project.getTasks().withType(CheckLicenseTask.class)});
            task.setDescription("Checks whether source files in every source sets contain a valid license header.");
            task.setGroup("verification");
        }));
        this.registerGroupedTask(project, APPLY_TASK_PREFIX, (Action<Task>)((Action)task -> {
            task.dependsOn(new Object[]{project.getTasks().withType(ApplyLicenseTask.class)});
            task.setDescription("Applies the correct license headers to source files in every source sets.");
            task.setGroup("generation");
        }));
        project.getPlugins().withType(LifecycleBasePlugin.class).configureEach(plugin -> project.getTasks().named(CHECK_TASK_PREFIX).configure(task -> task.dependsOn(new Object[]{globalCheck})));
    }

    public static String getTaskName(String action, SourceSet sourceSet) {
        if (sourceSet.getName().equals("main")) {
            return action + "LicenseMain";
        }
        return sourceSet.getTaskName(action + LICENSE_TASK_SUFFIX, null);
    }

    private TaskProvider<Task> registerGroupedTask(Project project, String action, Action<Task> consumer) {
        TaskProvider task = project.getTasks().register(action + "Licenses");
        task.configure(consumer);
        return task;
    }
}

