/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.gradle.licenser;

import dev.yumi.gradle.licenser.api.comment.HeaderCommentManager;
import dev.yumi.gradle.licenser.api.rule.HeaderParseException;
import dev.yumi.gradle.licenser.api.rule.HeaderRule;
import dev.yumi.gradle.licenser.impl.LicenseHeader;
import dev.yumi.gradle.licenser.util.Utils;
import groovy.lang.Closure;
import groovy.lang.Delegate;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class YumiLicenserGradleExtension
implements PatternFilterable {
    @Delegate
    public PatternFilterable patternFilterable;
    final LicenseHeader header = new LicenseHeader(new ArrayList<HeaderRule>());
    final Property<Integer> projectCreationYear;
    final TextResourceFactory textResources;
    final List<String> excludedSourceSets = new ArrayList<String>();
    final HeaderCommentManager headerCommentManager = new HeaderCommentManager();

    @Inject
    public YumiLicenserGradleExtension(ObjectFactory objects, Project project) {
        this.patternFilterable = new PatternSet();
        this.textResources = project.getResources().getText();
        this.projectCreationYear = objects.property(Integer.class).convention(project.provider(() -> Utils.getProjectCreationYear(project)));
        this.exclude("**/*.txt", "**/*.json", "**/*.yml", "**/*.apng", "**/*.bmp", "**/*.gif", "**/*.ico", "**/*.jpg", "**/*.png", "**/*.qoi", "**/*.webp", "**/*.bin", "**/*.class", "**/*.jar", "**/*.tar", "**/*.war", "**/*.zip", "**/MANIFEST.MF", "**/META-INF/services/**");
    }

    public void rule(@NotNull Object header) {
        List<String> lines;
        String name;
        if (header instanceof Path) {
            Path path = (Path)header;
            name = path.toString();
            try {
                lines = Files.readAllLines(path);
            }
            catch (IOException e) {
                throw new GradleException(String.format("Failed to load license header %s", path), (Throwable)e);
            }
        }
        Path path = this.textResources.fromFile(header).asFile().toPath();
        name = path.toString();
        try {
            lines = Files.readAllLines(path);
        }
        catch (IOException e) {
            throw new GradleException(String.format("Failed to load license header %s", path), (Throwable)e);
        }
        try {
            this.rule(HeaderRule.parse(name, lines));
        }
        catch (HeaderParseException e) {
            throw new GradleException(String.format("Failed to load license header %s", header), (Throwable)e);
        }
    }

    public void rule(HeaderRule rule) {
        this.header.addRule(rule);
    }

    public LicenseHeader getLicenseHeader() {
        return this.header;
    }

    public Property<Integer> getProjectCreationYear() {
        return this.projectCreationYear;
    }

    public PatternFilterable asPatternFilterable() {
        return this.patternFilterable;
    }

    @NotNull
    public Set<String> getIncludes() {
        return this.patternFilterable.getIncludes();
    }

    @NotNull
    public Set<String> getExcludes() {
        return this.patternFilterable.getExcludes();
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension setIncludes(@NotNull Iterable<String> includes) {
        this.patternFilterable.setIncludes(includes);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension setExcludes(@NotNull Iterable<String> excludes) {
        this.patternFilterable.setExcludes(excludes);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension include(String ... includes) {
        this.patternFilterable.include(includes);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension include(@NotNull Iterable<String> includes) {
        this.patternFilterable.include(includes);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension include(@NotNull Spec<FileTreeElement> includeSpec) {
        this.patternFilterable.include(includeSpec);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension include(@NotNull Closure includeSpec) {
        this.patternFilterable.include(includeSpec);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension exclude(String ... excludes) {
        this.patternFilterable.exclude(excludes);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension exclude(Iterable<String> excludes) {
        this.patternFilterable.exclude(excludes);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension exclude(@NotNull Spec<FileTreeElement> excludeSpec) {
        this.patternFilterable.exclude(excludeSpec);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension exclude(@NotNull Closure excludeSpec) {
        this.patternFilterable.exclude(excludeSpec);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension excludeSourceSet(@NotNull String sourceSetName) {
        this.excludedSourceSets.add(sourceSetName);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public YumiLicenserGradleExtension exclude(@NotNull SourceSet sourceSet) {
        return this.excludeSourceSet(sourceSet.getName());
    }

    public boolean isSourceSetExcluded(String sourceSetName) {
        return this.excludedSourceSets.contains(sourceSetName);
    }

    public boolean isSourceSetExcluded(SourceSet sourceSet) {
        return this.isSourceSetExcluded(sourceSet.getName());
    }

    @NotNull
    public HeaderCommentManager getHeaderCommentManager() {
        return this.headerCommentManager;
    }
}

