/*
 * Decompiled with CFR 0.152.
 */
package dev.miku.r2dbc.mysql.message.server;

import dev.miku.r2dbc.mysql.ServerVersion;
import dev.miku.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public final class HandshakeHeader {
    private final short protocolVersion;
    private final ServerVersion serverVersion;
    private final int connectionId;

    private HandshakeHeader(short protocolVersion, ServerVersion serverVersion, int connectionId) {
        this.protocolVersion = protocolVersion;
        this.serverVersion = AssertUtils.requireNonNull(serverVersion, "serverVersion must not be null");
        this.connectionId = connectionId;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    static HandshakeHeader decode(ByteBuf buf) {
        short protocolVersion = buf.readUnsignedByte();
        ServerVersion serverVersion = ServerVersion.parse(HandshakeHeader.readCStringAscii(buf));
        return new HandshakeHeader(protocolVersion, serverVersion, buf.readIntLE());
    }

    public String toString() {
        return String.format("HandshakeHeader{protocolVersion=%d, serverVersion=%s, connectionId=%d}", this.protocolVersion, this.serverVersion, this.connectionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandshakeHeader)) {
            return false;
        }
        HandshakeHeader that = (HandshakeHeader)o;
        if (this.protocolVersion != that.protocolVersion) {
            return false;
        }
        if (this.connectionId != that.connectionId) {
            return false;
        }
        return this.serverVersion.equals(that.serverVersion);
    }

    public int hashCode() {
        int result = this.protocolVersion;
        result = 31 * result + this.serverVersion.hashCode();
        result = 31 * result + this.connectionId;
        return result;
    }

    static String readCStringAscii(ByteBuf buf) {
        int length = buf.bytesBefore((byte)0);
        if (length < 0) {
            throw new IllegalArgumentException("buf has no C-style string terminal");
        }
        if (length == 0) {
            buf.skipBytes(1);
            return "";
        }
        String result = buf.toString(buf.readerIndex(), length, StandardCharsets.US_ASCII);
        buf.skipBytes(length + 1);
        return result;
    }
}

