/*
 * Decompiled with CFR 0.152.
 */
package dev.markcharles.tinytextstyler;

import android.graphics.Color;
import android.graphics.Typeface;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import dev.markcharles.tinytextstyler.CustomTypefaceSpan;
import dev.markcharles.tinytextstyler.TinyTextStyler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Ldev/markcharles/tinytextstyler/DefaultTextStyler;", "Ldev/markcharles/tinytextstyler/TinyTextStyler;", "()V", "getAbsoluteSize", "", "value", "", "getBackgroundColor", "getCharacterStyle", "Landroid/text/style/CharacterStyle;", "key", "getForegroundColor", "getRelativeSize", "", "getSpanClickListener", "Landroid/view/View$OnClickListener;", "getTypeface", "Landroid/graphics/Typeface;", "parseColor", "tinytextstyler_release"})
public abstract class DefaultTextStyler
implements TinyTextStyler {
    @Override
    @Nullable
    public CharacterStyle getCharacterStyle(@NotNull String key, @NotNull String value) {
        CharacterStyle characterStyle;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        block9 : switch (key) {
            case "style": {
                switch (value) {
                    case "normal": {
                        characterStyle = (CharacterStyle)new StyleSpan(0);
                        break block9;
                    }
                    case "bold": {
                        characterStyle = (CharacterStyle)new StyleSpan(1);
                        break block9;
                    }
                    case "italic": {
                        characterStyle = (CharacterStyle)new StyleSpan(2);
                        break block9;
                    }
                    case "bold_italic": {
                        characterStyle = (CharacterStyle)new StyleSpan(3);
                        break block9;
                    }
                    case "strike": {
                        characterStyle = (CharacterStyle)new StrikethroughSpan();
                        break block9;
                    }
                    case "underline": {
                        characterStyle = (CharacterStyle)new UnderlineSpan();
                        break block9;
                    }
                }
                characterStyle = null;
                break;
            }
            case "click": {
                ClickableSpan clickableSpan;
                View.OnClickListener onClickListener = this.getSpanClickListener(value);
                if (onClickListener != null) {
                    View.OnClickListener onClickListener2 = onClickListener;
                    boolean bl = false;
                    boolean bl2 = false;
                    View.OnClickListener it = onClickListener2;
                    boolean bl3 = false;
                    clickableSpan = new ClickableSpan(it){
                        final /* synthetic */ View.OnClickListener $it;

                        public void onClick(@NotNull View widget) {
                            Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
                            this.$it.onClick(widget);
                        }
                        {
                            this.$it = $captured_local_variable$0;
                        }
                    };
                } else {
                    clickableSpan = null;
                }
                characterStyle = (CharacterStyle)clickableSpan;
                break;
            }
            case "bg_color": {
                int n = this.getBackgroundColor(value);
                boolean bl = false;
                boolean bl4 = false;
                int p1 = n;
                boolean bl5 = false;
                characterStyle = (CharacterStyle)new BackgroundColorSpan(p1);
                break;
            }
            case "color": {
                int n = this.getForegroundColor(value);
                boolean bl = false;
                boolean bl6 = false;
                int p1 = n;
                boolean bl7 = false;
                characterStyle = (CharacterStyle)new ForegroundColorSpan(p1);
                break;
            }
            case "abs_size": {
                int n = this.getAbsoluteSize(value);
                boolean bl = false;
                boolean bl8 = false;
                int p1 = n;
                boolean bl9 = false;
                characterStyle = (CharacterStyle)new AbsoluteSizeSpan(p1);
                break;
            }
            case "rel_size": {
                float f = this.getRelativeSize(value);
                boolean bl = false;
                boolean bl10 = false;
                float p1 = f;
                boolean bl11 = false;
                characterStyle = (CharacterStyle)new RelativeSizeSpan(p1);
                break;
            }
            case "typeface": {
                CustomTypefaceSpan customTypefaceSpan;
                Typeface typeface = this.getTypeface(value);
                if (typeface != null) {
                    Typeface typeface2 = typeface;
                    boolean bl = false;
                    boolean bl12 = false;
                    Typeface p1 = typeface2;
                    boolean bl13 = false;
                    customTypefaceSpan = new CustomTypefaceSpan(p1);
                } else {
                    customTypefaceSpan = null;
                }
                characterStyle = (CharacterStyle)customTypefaceSpan;
                break;
            }
            default: {
                characterStyle = null;
            }
        }
        return characterStyle;
    }

    public int getAbsoluteSize(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        boolean bl = false;
        return Integer.parseInt(string);
    }

    public float getRelativeSize(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value;
        boolean bl = false;
        return Float.parseFloat(string);
    }

    @Nullable
    public Typeface getTypeface(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return null;
    }

    public int getForegroundColor(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.parseColor(value);
    }

    public int getBackgroundColor(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.parseColor(value);
    }

    @Nullable
    public View.OnClickListener getSpanClickListener(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return null;
    }

    private final int parseColor(String value) {
        int n;
        switch (value) {
            case "green": {
                n = -16711936;
                break;
            }
            case "blue": {
                n = -16776961;
                break;
            }
            case "yellow": {
                n = -256;
                break;
            }
            case "red": {
                n = -65536;
                break;
            }
            case "gray": {
                n = -7829368;
                break;
            }
            case "cyan": {
                n = -16711681;
                break;
            }
            case "white": {
                n = -1;
                break;
            }
            case "black": {
                n = -16777216;
                break;
            }
            default: {
                int n2;
                try {
                    n2 = Color.parseColor((String)value);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    n2 = -16777216;
                }
                n = n2;
            }
        }
        return n;
    }
}

