/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import java.lang.reflect.Type;

class GsonChatMessageAdapter
implements JsonDeserializer<ChatMessage>,
JsonSerializer<ChatMessage> {
    private static final Gson GSON = new Gson();
    private static final String CHAT_MESSAGE_TYPE = "type";

    GsonChatMessageAdapter() {
    }

    public JsonElement serialize(ChatMessage chatMessage, Type ignored, JsonSerializationContext context) {
        JsonObject messageJsonObject = GSON.toJsonTree((Object)chatMessage).getAsJsonObject();
        messageJsonObject.addProperty(CHAT_MESSAGE_TYPE, chatMessage.type().toString());
        return messageJsonObject;
    }

    public ChatMessage deserialize(JsonElement messageJsonElement, Type ignored, JsonDeserializationContext context) throws JsonParseException {
        String chatMessageTypeString = messageJsonElement.getAsJsonObject().get(CHAT_MESSAGE_TYPE).getAsString();
        ChatMessageType chatMessageType = ChatMessageType.valueOf(chatMessageTypeString);
        return (ChatMessage)GSON.fromJson(messageJsonElement, ChatMessageType.classOf(chatMessageType));
    }
}

